/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class JuniperSecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;

    public JuniperSecretKey() {
        this.keyType_.setLongValue(Key.KeyType.JUNIPER);
    }

    protected JuniperSecretKey(Session session, long l2) throws TokenException {
        super(session, l2);
        this.keyType_.setLongValue(Key.KeyType.JUNIPER);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        JuniperSecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        JuniperSecretKey juniperSecretKey = (JuniperSecretKey)super.clone();
        juniperSecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        JuniperSecretKey.putAttributesInTable(juniperSecretKey);
        return juniperSecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof JuniperSecretKey) {
            JuniperSecretKey juniperSecretKey = (JuniperSecretKey)object;
            bl = this == juniperSecretKey || super.equals(juniperSecretKey) && this.value_.equals(juniperSecretKey.value_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        return new JuniperSecretKey(session, l2);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(JuniperSecretKey juniperSecretKey) {
        if (juniperSecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        juniperSecretKey.attributeTable_.put(Attribute.VALUE, juniperSecretKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

