/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.CK_DATE;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class Util {
    public static CK_ATTRIBUTE[] convertAttributesVectorToArray(Vector vector) {
        if (vector == null) {
            return null;
        }
        int n2 = vector.size();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[n2];
        int n3 = 0;
        while (n3 < n2) {
            Object e2 = vector.elementAt(n3);
            cK_ATTRIBUTEArray[n3] = e2 instanceof CK_ATTRIBUTE ? (CK_ATTRIBUTE)e2 : null;
            ++n3;
        }
        return cK_ATTRIBUTEArray;
    }

    public static CK_DATE convertToCkDate(Date date) {
        CK_DATE cK_DATE = null;
        if (date != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            int n2 = gregorianCalendar.get(1);
            int n3 = gregorianCalendar.get(2) + 1;
            int n4 = gregorianCalendar.get(5);
            cK_DATE = new CK_DATE();
            cK_DATE.year = Util.toCharArray(n2, 4);
            cK_DATE.month = Util.toCharArray(n3, 2);
            cK_DATE.day = Util.toCharArray(n4, 2);
        }
        return cK_DATE;
    }

    public static Date convertToDate(CK_DATE cK_DATE) {
        Date date = null;
        if (cK_DATE != null) {
            int n2 = Integer.parseInt(new String(cK_DATE.year));
            int n3 = Integer.parseInt(new String(cK_DATE.month));
            int n4 = Integer.parseInt(new String(cK_DATE.day));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.set(n2, n3 - 1, n4);
            date = gregorianCalendar.getTime();
        }
        return date;
    }

    public static Date parseTime(char[] cArray) {
        Date date;
        block2: {
            date = null;
            if (cArray == null || cArray.length <= 2) break block2;
            String string = new String(cArray, 0, cArray.length - 2);
            try {
                date = new SimpleDateFormat("yyyyMMddhhmmss").parse(string);
            }
            catch (ParseException parseException) {}
        }
        return date;
    }

    public static char[] toCharArray(int n2, int n3) {
        char[] cArray = null;
        String string = Integer.toString(n2);
        char[] cArray2 = string.toCharArray();
        if (cArray2.length > n3) {
            cArray = new char[n3];
            int n4 = 0;
            while (n4 < cArray.length) {
                cArray[n4] = cArray2[n4];
                ++n4;
            }
        } else if (cArray2.length < n3) {
            cArray = new char[n3];
            int n5 = n3 - cArray2.length;
            int n6 = 0;
            while (n6 < cArray.length) {
                cArray[n6] = n6 < n5 ? 48 : cArray2[n6 - n5];
                ++n6;
            }
        } else {
            cArray = cArray2;
        }
        return cArray;
    }

    public static char[] toPaddedCharArray(String string, int n2, char c2) {
        char[] cArray = null;
        if (string != null) {
            int n3 = string.length();
            cArray = new char[n2];
            string.getChars(0, Math.min(n3, n2), cArray, 0);
            int n4 = n3;
            while (n4 < cArray.length) {
                cArray[n4] = c2;
                ++n4;
            }
        }
        return cArray;
    }

    public static byte[] unsignedBigIntergerToByteArray(BigInteger bigInteger) {
        byte[] byArray;
        if (bigInteger == null) {
            return null;
        }
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length > 0 && byArray2[0] == 0) {
            byArray = new byte[byArray2.length - 1];
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = byArray2[n2 + 1];
                ++n2;
            }
        } else {
            byArray = byArray2;
        }
        return byArray;
    }
}

