/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.security.provider.IAIK;
import iaik.utils.Base64InputStream;
import iaik.utils.CryptoUtils;
import iaik.utils.TracedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.security.MessageDigest;

public class ASN1 {
    private int a = 1;
    private byte[] d;
    private ASN1Object c;
    private static final int e = 10;
    private static final int f = 13;
    private static final byte[] b = new byte[]{45, 45, 45, 45, 45, 66, 69, 71, 73, 78};
    public static final String startLine = "-----BEGIN";
    public static final int PEM = 2;
    public static final int DER = 1;

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    public String toString() {
        return ASN1.a(this.toASN1Object(), "");
    }

    public byte[] toByteArray() {
        if (this.d == null) {
            if (this.c == null) {
                return null;
            }
            this.d = DerCoder.encode(this.c);
        }
        return this.d;
    }

    public ASN1Object toASN1Object() {
        try {
            if (this.c == null) {
                if (this.d == null) {
                    throw new NullPointerException("ASN1 array not set");
                }
                this.c = DerCoder.decode(this.d);
            }
            return this.c;
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    private static String a(ASN1Object aSN1Object, String string) {
        StringBuffer stringBuffer;
        block4: {
            string = string.concat("  ");
            if (aSN1Object == null) {
                return "";
            }
            stringBuffer = new StringBuffer(aSN1Object.toString());
            stringBuffer.append("\n");
            if (!(aSN1Object instanceof ConstructedType)) break block4;
            try {
                int n2 = 0;
                while (n2 < aSN1Object.countComponents()) {
                    stringBuffer.append(string);
                    stringBuffer.append(ASN1.a(aSN1Object.getComponentAt(n2), string));
                    ++n2;
                }
            }
            catch (CodingException codingException) {}
        }
        return stringBuffer.toString();
    }

    public static String print(ASN1Object aSN1Object) {
        return ASN1.a(aSN1Object, "");
    }

    public int getFormat() {
        return this.a;
    }

    public byte[] getFirstObject() throws CodingException {
        byte[] byArray = this.toByteArray();
        if (byArray == null) {
            throw new CodingException("Cannot parse data from a null object!");
        }
        int n2 = 0;
        if (byArray[n2++] != 48) {
            throw new CodingException("getFirstObject: No SEQUENCE!");
        }
        int[] nArray = new int[1];
        int n3 = ASN1.a(byArray, n2, nArray);
        n2 = nArray[0];
        if (byArray[n2] != 48) {
            throw new CodingException("getFirstObject: No SEQUENCE in a SEQUENCE!");
        }
        n3 = ASN1.a(byArray, n2 + 1, nArray);
        byte[] byArray2 = new byte[n3 + nArray[0] - n2];
        System.arraycopy(byArray, n2, byArray2, 0, n3 + nArray[0] - n2);
        return byArray2;
    }

    public ASN1Object getComponentAt(int n2) throws CodingException {
        ASN1Object aSN1Object = this.toASN1Object();
        return aSN1Object.getComponentAt(n2);
    }

    private void a(InputStream inputStream) throws IOException, CodingException {
        FilterInputStream filterInputStream;
        int n2;
        boolean bl;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 20);
        byte[] byArray = new byte[10];
        int n3 = -1;
        if (pushbackInputStream.read(byArray) >= 6) {
            n3 = ASN1.a(byArray);
        }
        if (bl = CryptoUtils.equalsBlock(byArray, b)) {
            while ((n2 = pushbackInputStream.read()) != 13 && n2 != 10 && n2 != -1) {
            }
            if (n2 == -1) {
                throw new IOException("Unexpected EOF in encoding!");
            }
            if (n2 == 13) {
                pushbackInputStream.read();
            }
            this.a = 2;
            filterInputStream = new Base64InputStream(pushbackInputStream);
        } else {
            pushbackInputStream.unread(byArray);
            n2 = pushbackInputStream.read();
            pushbackInputStream.unread(n2);
            if (n2 >= 65 && n2 <= 77 || n2 >= 103 && n2 <= 122) {
                this.a = 2;
                filterInputStream = new Base64InputStream(pushbackInputStream);
            } else {
                this.a = 1;
                filterInputStream = pushbackInputStream;
            }
        }
        TracedInputStream tracedInputStream = new TracedInputStream(filterInputStream, n3);
        this.c = DerCoder.decode(tracedInputStream);
        this.d = tracedInputStream.getTracedData();
        if (bl) {
            ((FilterInputStream)pushbackInputStream).skip(10L);
            while ((n2 = pushbackInputStream.read()) != 13 && n2 != 10 && n2 != -1) {
            }
            if (n2 == 13) {
                pushbackInputStream.read();
            }
        }
    }

    public byte[] fingerprint() {
        MessageDigest messageDigest = IAIK.getMd5();
        messageDigest.update(this.toByteArray());
        return messageDigest.digest();
    }

    private static int a(byte[] byArray) {
        int n2 = byArray[0] & 0xFF;
        if ((n2 & 0x1F) == 31) {
            return -1;
        }
        int n3 = byArray[1] & 0xFF;
        if (n3 < 128) {
            return n3 + 2;
        }
        if (n3 == 128) {
            return -1;
        }
        if ((n3 &= 0x7F) < 1 || n3 > 4) {
            return -1;
        }
        int n4 = 2;
        int n5 = 0;
        while (n3-- > 0) {
            n5 <<= 8;
            n5 |= byArray[n4++] & 0xFF;
        }
        return n5 + n4;
    }

    private static int a(byte[] byArray, int n2, int[] nArray) throws CodingException {
        int n3;
        if ((n3 = byArray[n2++] & 0xFF) <= 127) {
            nArray[0] = n2;
            return n3;
        }
        if (n3 == 128) {
            nArray[0] = n2;
            int n4 = n2;
            try {
                while (true) {
                    if (byArray[n4] != 0) {
                        ++n4;
                        continue;
                    }
                    if (byArray[n4 + 1] == 0) {
                        return n4 - n2;
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                throw new CodingException("Error decoding ASN1 indefinite format: " + exception.toString());
            }
        }
        if ((n3 &= 0x7F) > 4) {
            throw new CodingException("Too large ASN.1 object");
        }
        int n5 = 0;
        while (--n3 >= 0) {
            n5 = n5 << 8 | byArray[n2++] & 0xFF;
        }
        nArray[0] = n2;
        return n5;
    }

    public int countComponents() throws CodingException {
        ASN1Object aSN1Object = this.toASN1Object();
        return aSN1Object.countComponents();
    }

    public void clearByteArray() {
        this.toASN1Object();
        this.d = null;
    }

    public void clearASN1Object() {
        this.toByteArray();
        this.c = null;
    }

    public ASN1(byte[] byArray) throws CodingException {
        if (byArray == null) {
            throw new CodingException("Cannot parse an ASN1 object from a null byte array!");
        }
        try {
            this.a(new ByteArrayInputStream(byArray));
            return;
        }
        catch (IOException iOException) {
            throw new CodingException("Unexpected end of ASN.1 object.");
        }
    }

    public ASN1(InputStream inputStream) throws CodingException, IOException {
        if (inputStream == null) {
            throw new IOException("Cannot parse an ASN1 object from a null input stream!");
        }
        this.a(inputStream);
    }

    public ASN1(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new CodingException("Cannot parse an ASN1 object from a null object.");
        }
        this.c = aSN1Object;
    }

    public ASN1() {
    }
}

