/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen.router;

import fi.iki.elonen.NanoHTTPD;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RouterNanoHTTPD
extends NanoHTTPD {
    private static final Logger LOG = Logger.getLogger(RouterNanoHTTPD.class.getName());
    private UriRouter router = new UriRouter();

    public static String normalizeUri(String value) {
        if (value == null) {
            return value;
        }
        if (value.startsWith("/")) {
            value = value.substring(1);
        }
        if (value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public RouterNanoHTTPD(int port) {
        super(port);
    }

    public RouterNanoHTTPD(String hostname, int port) {
        super(hostname, port);
    }

    public void addMappings() {
        this.router.setNotImplemented(NotImplementedHandler.class);
        this.router.setNotFoundHandler(Error404UriHandler.class);
        this.router.addRoute("/", 0x3FFFFFFF, IndexHandler.class, new Object[0]);
        this.router.addRoute("/index.html", 0x3FFFFFFF, IndexHandler.class, new Object[0]);
    }

    public void addRoute(String url, Class<?> handler, Object ... initParameter) {
        this.router.addRoute(url, 100, handler, initParameter);
    }

    public <T extends UriResponder> void setNotImplementedHandler(Class<T> handler) {
        this.router.setNotImplemented(handler);
    }

    public <T extends UriResponder> void setNotFoundHandler(Class<T> handler) {
        this.router.setNotFoundHandler(handler);
    }

    public void removeRoute(String url) {
        this.router.removeRoute(url);
    }

    public void setRoutePrioritizer(IRoutePrioritizer routePrioritizer) {
        this.router.setRoutePrioritizer(routePrioritizer);
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        return this.router.process(session);
    }

    public static class UriRouter {
        private UriResource error404Url;
        private IRoutePrioritizer routePrioritizer = new DefaultRoutePrioritizer();

        public NanoHTTPD.Response process(NanoHTTPD.IHTTPSession session) {
            String work = RouterNanoHTTPD.normalizeUri(session.getUri());
            Map<String, String> params = null;
            UriResource uriResource = this.error404Url;
            for (UriResource u2 : this.routePrioritizer.getPrioritizedRoutes()) {
                params = u2.match(work);
                if (params == null) continue;
                uriResource = u2;
                break;
            }
            return uriResource.process(params, session);
        }

        private void addRoute(String url, int priority, Class<?> handler, Object ... initParameter) {
            this.routePrioritizer.addRoute(url, priority, handler, initParameter);
        }

        private void removeRoute(String url) {
            this.routePrioritizer.removeRoute(url);
        }

        public void setNotFoundHandler(Class<?> handler) {
            this.error404Url = new UriResource(null, 100, handler, new Object[0]);
        }

        public void setNotImplemented(Class<?> handler) {
            this.routePrioritizer.setNotImplemented(handler);
        }

        public void setRoutePrioritizer(IRoutePrioritizer routePrioritizer) {
            this.routePrioritizer = routePrioritizer;
        }
    }

    public static class InsertionOrderRoutePrioritizer
    extends BaseRoutePrioritizer {
        @Override
        protected Collection<UriResource> newMappingCollection() {
            return new ArrayList<UriResource>();
        }
    }

    public static class DefaultRoutePrioritizer
    extends BaseRoutePrioritizer {
        @Override
        protected Collection<UriResource> newMappingCollection() {
            return new PriorityQueue<UriResource>();
        }
    }

    public static class ProvidedPriorityRoutePrioritizer
    extends BaseRoutePrioritizer {
        @Override
        public void addRoute(String url, int priority, Class<?> handler, Object ... initParameter) {
            if (url != null) {
                UriResource resource = null;
                resource = handler != null ? new UriResource(url, handler, initParameter) : new UriResource(url, handler, this.notImplemented);
                resource.setPriority(priority);
                this.mappings.add(resource);
            }
        }

        @Override
        protected Collection<UriResource> newMappingCollection() {
            return new PriorityQueue<UriResource>();
        }
    }

    public static abstract class BaseRoutePrioritizer
    implements IRoutePrioritizer {
        protected Class<?> notImplemented = NotImplementedHandler.class;
        protected final Collection<UriResource> mappings = this.newMappingCollection();

        @Override
        public void addRoute(String url, int priority, Class<?> handler, Object ... initParameter) {
            if (url != null) {
                if (handler != null) {
                    this.mappings.add(new UriResource(url, priority + this.mappings.size(), handler, initParameter));
                } else {
                    this.mappings.add(new UriResource(url, priority + this.mappings.size(), this.notImplemented, new Object[0]));
                }
            }
        }

        @Override
        public void removeRoute(String url) {
            String uriToDelete = RouterNanoHTTPD.normalizeUri(url);
            Iterator<UriResource> iter = this.mappings.iterator();
            while (iter.hasNext()) {
                UriResource uriResource = iter.next();
                if (!uriToDelete.equals(uriResource.getUri())) continue;
                iter.remove();
                break;
            }
        }

        @Override
        public Collection<UriResource> getPrioritizedRoutes() {
            return Collections.unmodifiableCollection(this.mappings);
        }

        @Override
        public void setNotImplemented(Class<?> handler) {
            this.notImplemented = handler;
        }

        protected abstract Collection<UriResource> newMappingCollection();
    }

    public static interface IRoutePrioritizer {
        public void addRoute(String var1, int var2, Class<?> var3, Object ... var4);

        public void removeRoute(String var1);

        public Collection<UriResource> getPrioritizedRoutes();

        public void setNotImplemented(Class<?> var1);
    }

    public static class UriResource
    implements Comparable<UriResource> {
        private static final Pattern PARAM_PATTERN = Pattern.compile("(?<=(^|/)):[a-zA-Z0-9_-]+(?=(/|$))");
        private static final String PARAM_MATCHER = "([A-Za-z0-9\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=\\s]+)";
        private static final Map<String, String> EMPTY = Collections.unmodifiableMap(new HashMap());
        private final String uri;
        private final Pattern uriPattern;
        private int priority;
        private final Class<?> handler;
        private final Object[] initParameter;
        private final List<String> uriParams = new ArrayList<String>();

        public UriResource(String uri, int priority, Class<?> handler, Object ... initParameter) {
            this(uri, handler, initParameter);
            this.priority = priority + this.uriParams.size() * 1000;
        }

        public UriResource(String uri, Class<?> handler, Object ... initParameter) {
            this.handler = handler;
            this.initParameter = initParameter;
            if (uri != null) {
                this.uri = RouterNanoHTTPD.normalizeUri(uri);
                this.parse();
                this.uriPattern = this.createUriPattern();
            } else {
                this.uriPattern = null;
                this.uri = null;
            }
        }

        private void parse() {
        }

        private Pattern createUriPattern() {
            String patternUri = this.uri;
            Matcher matcher = PARAM_PATTERN.matcher(patternUri);
            int start = 0;
            while (matcher.find(start)) {
                this.uriParams.add(patternUri.substring(matcher.start() + 1, matcher.end()));
                patternUri = patternUri.substring(0, matcher.start()) + PARAM_MATCHER + patternUri.substring(matcher.end());
                start = matcher.start() + PARAM_MATCHER.length();
                matcher = PARAM_PATTERN.matcher(patternUri);
            }
            return Pattern.compile(patternUri);
        }

        public NanoHTTPD.Response process(Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            String error = "General error!";
            if (this.handler != null) {
                try {
                    Object object = this.handler.newInstance();
                    if (object instanceof UriResponder) {
                        UriResponder responder = (UriResponder)object;
                        switch (session.getMethod()) {
                            case GET: {
                                return responder.get(this, urlParams, session);
                            }
                            case POST: {
                                return responder.post(this, urlParams, session);
                            }
                            case PUT: {
                                return responder.put(this, urlParams, session);
                            }
                            case DELETE: {
                                return responder.delete(this, urlParams, session);
                            }
                        }
                        return responder.other(session.getMethod().toString(), this, urlParams, session);
                    }
                    return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain", "Return: " + this.handler.getCanonicalName() + ".toString() -> " + object);
                }
                catch (Exception e2) {
                    error = "Error: " + e2.getClass().getName() + " : " + e2.getMessage();
                    LOG.log(Level.SEVERE, error, e2);
                }
            }
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", error);
        }

        public String toString() {
            return "UrlResource{uri='" + (this.uri == null ? "/" : this.uri) + "', urlParts=" + this.uriParams + '}';
        }

        public String getUri() {
            return this.uri;
        }

        public <T> T initParameter(Class<T> paramClazz) {
            return this.initParameter(0, paramClazz);
        }

        public <T> T initParameter(int parameterIndex, Class<T> paramClazz) {
            if (this.initParameter.length > parameterIndex) {
                return paramClazz.cast(this.initParameter[parameterIndex]);
            }
            LOG.severe("init parameter index not available " + parameterIndex);
            return null;
        }

        public Map<String, String> match(String url) {
            Matcher matcher = this.uriPattern.matcher(url);
            if (matcher.matches()) {
                if (this.uriParams.size() > 0) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    for (int i2 = 1; i2 <= matcher.groupCount(); ++i2) {
                        result.put(this.uriParams.get(i2 - 1), matcher.group(i2));
                    }
                    return result;
                }
                return EMPTY;
            }
            return null;
        }

        @Override
        public int compareTo(UriResource that) {
            if (that == null) {
                return 1;
            }
            if (this.priority > that.priority) {
                return 1;
            }
            if (this.priority < that.priority) {
                return -1;
            }
            return 0;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }
    }

    public static class NotImplementedHandler
    extends DefaultHandler {
        @Override
        public String getText() {
            return "<html><body><h2>The uri is mapped in the router, but no handler is specified. <br> Status: Not implemented!</h3></body></html>";
        }

        @Override
        public String getMimeType() {
            return "text/html";
        }

        @Override
        public NanoHTTPD.Response.IStatus getStatus() {
            return NanoHTTPD.Response.Status.OK;
        }
    }

    public static class IndexHandler
    extends DefaultHandler {
        @Override
        public String getText() {
            return "<html><body><h2>Hello world!</h3></body></html>";
        }

        @Override
        public String getMimeType() {
            return "text/html";
        }

        @Override
        public NanoHTTPD.Response.IStatus getStatus() {
            return NanoHTTPD.Response.Status.OK;
        }
    }

    public static class Error404UriHandler
    extends DefaultHandler {
        @Override
        public String getText() {
            return "<html><body><h3>Error 404: the requested page doesn't exist.</h3></body></html>";
        }

        @Override
        public String getMimeType() {
            return "text/html";
        }

        @Override
        public NanoHTTPD.Response.IStatus getStatus() {
            return NanoHTTPD.Response.Status.NOT_FOUND;
        }
    }

    public static class StaticPageHandler
    extends DefaultHandler {
        private static String[] getPathArray(String uri) {
            String[] array = uri.split("/");
            ArrayList<String> pathArray = new ArrayList<String>();
            for (String s2 : array) {
                if (s2.length() <= 0) continue;
                pathArray.add(s2);
            }
            return pathArray.toArray(new String[0]);
        }

        @Override
        public String getText() {
            throw new IllegalStateException("this method should not be called");
        }

        @Override
        public String getMimeType() {
            throw new IllegalStateException("this method should not be called");
        }

        @Override
        public NanoHTTPD.Response.IStatus getStatus() {
            return NanoHTTPD.Response.Status.OK;
        }

        @Override
        public NanoHTTPD.Response get(UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            String baseUri = uriResource.getUri();
            String realUri = RouterNanoHTTPD.normalizeUri(session.getUri());
            for (int index = 0; index < Math.min(baseUri.length(), realUri.length()); ++index) {
                if (baseUri.charAt(index) == realUri.charAt(index)) continue;
                realUri = RouterNanoHTTPD.normalizeUri(realUri.substring(index));
                break;
            }
            File fileOrdirectory = uriResource.initParameter(File.class);
            for (String pathPart : StaticPageHandler.getPathArray(realUri)) {
                fileOrdirectory = new File(fileOrdirectory, pathPart);
            }
            if (fileOrdirectory.isDirectory() && !(fileOrdirectory = new File(fileOrdirectory, "index.html")).exists()) {
                fileOrdirectory = new File(fileOrdirectory.getParentFile(), "index.htm");
            }
            if (!fileOrdirectory.exists() || !fileOrdirectory.isFile()) {
                return new Error404UriHandler().get(uriResource, urlParams, session);
            }
            try {
                return NanoHTTPD.newChunkedResponse(this.getStatus(), NanoHTTPD.getMimeTypeForFile(fileOrdirectory.getName()), this.fileToInputStream(fileOrdirectory));
            }
            catch (IOException ioe) {
                return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.REQUEST_TIMEOUT, "text/plain", null);
            }
        }

        protected BufferedInputStream fileToInputStream(File fileOrdirectory) throws IOException {
            return new BufferedInputStream(new FileInputStream(fileOrdirectory));
        }
    }

    public static class GeneralHandler
    extends DefaultHandler {
        @Override
        public String getText() {
            throw new IllegalStateException("this method should not be called");
        }

        @Override
        public String getMimeType() {
            return "text/html";
        }

        @Override
        public NanoHTTPD.Response.IStatus getStatus() {
            return NanoHTTPD.Response.Status.OK;
        }

        @Override
        public NanoHTTPD.Response get(UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            StringBuilder text = new StringBuilder("<html><body>");
            text.append("<h1>Url: ");
            text.append(session.getUri());
            text.append("</h1><br>");
            Map<String, String> queryParams = session.getParms();
            if (queryParams.size() > 0) {
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    text.append("<p>Param '");
                    text.append(key);
                    text.append("' = ");
                    text.append(value);
                    text.append("</p>");
                }
            } else {
                text.append("<p>no params in url</p><br>");
            }
            return NanoHTTPD.newFixedLengthResponse(this.getStatus(), this.getMimeType(), text.toString());
        }
    }

    public static abstract class DefaultHandler
    extends DefaultStreamHandler {
        public abstract String getText();

        @Override
        public abstract NanoHTTPD.Response.IStatus getStatus();

        @Override
        public NanoHTTPD.Response get(UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            return NanoHTTPD.newFixedLengthResponse(this.getStatus(), this.getMimeType(), this.getText());
        }

        @Override
        public InputStream getData() {
            throw new IllegalStateException("this method should not be called in a text based nanolet");
        }
    }

    public static abstract class DefaultStreamHandler
    implements UriResponder {
        public abstract String getMimeType();

        public abstract NanoHTTPD.Response.IStatus getStatus();

        public abstract InputStream getData();

        @Override
        public NanoHTTPD.Response get(UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            return NanoHTTPD.newChunkedResponse(this.getStatus(), this.getMimeType(), this.getData());
        }

        @Override
        public NanoHTTPD.Response post(UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            return this.get(uriResource, urlParams, session);
        }

        @Override
        public NanoHTTPD.Response put(UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            return this.get(uriResource, urlParams, session);
        }

        @Override
        public NanoHTTPD.Response delete(UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            return this.get(uriResource, urlParams, session);
        }

        @Override
        public NanoHTTPD.Response other(String method, UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            return this.get(uriResource, urlParams, session);
        }
    }

    public static interface UriResponder {
        public NanoHTTPD.Response get(UriResource var1, Map<String, String> var2, NanoHTTPD.IHTTPSession var3);

        public NanoHTTPD.Response put(UriResource var1, Map<String, String> var2, NanoHTTPD.IHTTPSession var3);

        public NanoHTTPD.Response post(UriResource var1, Map<String, String> var2, NanoHTTPD.IHTTPSession var3);

        public NanoHTTPD.Response delete(UriResource var1, Map<String, String> var2, NanoHTTPD.IHTTPSession var3);

        public NanoHTTPD.Response other(String var1, UriResource var2, Map<String, String> var3, NanoHTTPD.IHTTPSession var4);
    }
}

