/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.contrib;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;
import org.cocktail.trv.zap.contrib.StringCtrl;

public class ZapDateCtrl {
    public static final String DATE_SEPARATOR = "/";
    public static final String TIME_SEPARATOR = ":";
    public static final String DEFAULT_DATE_FORMAT = "dd/MM/yyyy";
    public static final String DEFAULT_TIME_FORMAT = "kk:mm:ss";
    public static final String DEFAULT_FULL_FORMAT = "dd/MM/yyyy kk:mm:ss";

    public static String dateCompletion(String uneDate) {
        String jour;
        GregorianCalendar calendar = new GregorianCalendar();
        String annee = String.valueOf(calendar.get(1));
        String mois = String.valueOf(calendar.get(2) + 1);
        if (mois.length() <= 1) {
            mois = "0" + mois;
        }
        if ((jour = String.valueOf(calendar.get(5))).length() <= 1) {
            jour = "0" + jour;
        }
        String maChaine = "";
        if (uneDate != null) {
            StringTokenizer st = new StringTokenizer(uneDate, DATE_SEPARATOR);
            while (st.hasMoreTokens()) {
                maChaine = maChaine + st.nextToken();
            }
        }
        switch (maChaine.length()) {
            case 0: {
                break;
            }
            case 1: {
                jour = "0" + maChaine;
                break;
            }
            case 2: {
                jour = maChaine;
                break;
            }
            case 3: {
                jour = maChaine.substring(0, 2);
                mois = "0" + maChaine.substring(2);
                break;
            }
            case 4: {
                jour = maChaine.substring(0, 2);
                mois = maChaine.substring(2);
                break;
            }
            case 5: {
                jour = maChaine.substring(0, 2);
                mois = maChaine.substring(2).substring(0, 2);
                annee = annee.substring(0, 3) + maChaine.substring(4);
                break;
            }
            case 6: {
                jour = maChaine.substring(0, 2);
                mois = maChaine.substring(2).substring(0, 2);
                annee = annee.substring(0, 2) + maChaine.substring(4);
                break;
            }
            case 7: {
                jour = maChaine.substring(0, 2);
                mois = maChaine.substring(2).substring(0, 2);
                annee = annee.charAt(0) + maChaine.substring(4);
                break;
            }
            default: {
                jour = maChaine.substring(0, 2);
                mois = maChaine.substring(2).substring(0, 2);
                annee = maChaine.substring(4).substring(0, 4);
            }
        }
        String retour = jour + DATE_SEPARATOR + mois + DATE_SEPARATOR + annee;
        if (!ZapDateCtrl.isValid(retour)) {
            retour = "";
        }
        return retour;
    }

    public static boolean isValid(String dateString) {
        return ZapDateCtrl.dateToString(ZapDateCtrl.stringToDate(dateString)).equals(dateString);
    }

    private static boolean isSameDay(Timestamp date1, Timestamp date2) {
        return ZapDateCtrl.dateToString(date1).equals(ZapDateCtrl.dateToString(date2));
    }

    public static boolean isBeforeEq(Timestamp date1, Timestamp date2) {
        return date1.getTime() <= date2.getTime();
    }

    public static boolean isBefore(Timestamp date1, Timestamp date2) {
        return date1.getTime() < date2.getTime();
    }

    public static boolean isAfterEq(Timestamp date1, Timestamp date2) {
        return ZapDateCtrl.isBeforeEq(date2, date1);
    }

    public static boolean isAfter(Timestamp date1, Timestamp date2) {
        return ZapDateCtrl.isBefore(date2, date1);
    }

    public static String dateToString(Timestamp date, String dateFormat) {
        String dateString = null;
        if (StringCtrl.normalize(dateFormat).length() > 0) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                dateString = formatter.format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateString;
    }

    public static String dateToString(Timestamp gregorianDate) {
        return ZapDateCtrl.dateToString(gregorianDate, DEFAULT_DATE_FORMAT);
    }

    public static Timestamp stringToDate(String sDate, String dateFormat) {
        Timestamp date = null;
        if (dateFormat == null || dateFormat.trim().length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
            date = (Timestamp)formatter.parseObject(sDate);
            if (!sDate.equals(ZapDateCtrl.dateToString(date, dateFormat))) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Timestamp stringToDate(String dateString) {
        return ZapDateCtrl.stringToDate(dateString, DEFAULT_DATE_FORMAT);
    }

    public static int getDayOfWeek(int dayOfWeek) {
        return dayOfWeek == 0 ? dayOfWeek + 6 : dayOfWeek - 1;
    }

    public static int getDayOfWeek(Timestamp date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(2);
        return calendar.get(7);
    }

    public static Timestamp now() {
        return ZapDateCtrl.toTimestamp(ZapDateCtrl.nowDate());
    }

    public static Timestamp toTimestamp(Date nowDate) {
        return new Timestamp(nowDate.getTime());
    }

    public static Date nowDate() {
        return new Date();
    }

    public static Vector holidaysFR(int year) {
        int mois;
        int jour;
        Vector<Timestamp> result = new Vector<Timestamp>();
        result.addElement(ZapDateCtrl.stringToDate("01/01/" + year, DEFAULT_DATE_FORMAT));
        result.addElement(ZapDateCtrl.stringToDate("01/05/" + year, DEFAULT_DATE_FORMAT));
        result.addElement(ZapDateCtrl.stringToDate("08/05/" + year, DEFAULT_DATE_FORMAT));
        result.addElement(ZapDateCtrl.stringToDate("14/07/" + year, DEFAULT_DATE_FORMAT));
        result.addElement(ZapDateCtrl.stringToDate("15/08/" + year, DEFAULT_DATE_FORMAT));
        result.addElement(ZapDateCtrl.stringToDate("01/11/" + year, DEFAULT_DATE_FORMAT));
        result.addElement(ZapDateCtrl.stringToDate("11/11/" + year, DEFAULT_DATE_FORMAT));
        result.addElement(ZapDateCtrl.stringToDate("25/12/" + year, DEFAULT_DATE_FORMAT));
        if (year == 1954 || year == 2049) {
            jour = 18;
            mois = 4;
        } else if (year == 1981 || year == 2076) {
            jour = 19;
            mois = 4;
        } else {
            int nCycleLunaire = year % 19;
            int nC1 = (nCycleLunaire * 19 + 24) % 30;
            int nBissextile = year % 4;
            int nLettDimanche = year % 7;
            int nC2 = (nBissextile * 2 + nLettDimanche * 4 + nC1 * 6 + 5) % 7;
            int nC3 = nC1 + nC2;
            if (nC3 <= 9) {
                jour = 22 + nC3;
                mois = 3;
            } else {
                jour = nC3 - 9;
                mois = 4;
            }
        }
        Timestamp leJourTemp = new Timestamp(new GregorianCalendar(year, mois, jour, 0, 0, 0).getTimeInMillis());
        leJourTemp = ZapDateCtrl.timestampByAddingDays(leJourTemp, 1);
        result.addElement(leJourTemp);
        leJourTemp = ZapDateCtrl.timestampByAddingDays(leJourTemp, 38);
        result.addElement(leJourTemp);
        return result;
    }

    public static boolean isHolidayFR(Timestamp aDate) {
        GregorianCalendar aCalendar = new GregorianCalendar();
        aCalendar.setTime(aDate);
        Vector dates = ZapDateCtrl.holidaysFR(aCalendar.get(1));
        for (int i2 = 0; i2 < dates.size(); ++i2) {
            if (!ZapDateCtrl.isSameDay((Timestamp)dates.elementAt(i2), aDate)) continue;
            return true;
        }
        return false;
    }

    public static int weekNumber(Timestamp aDate) {
        GregorianCalendar aCalendar = new GregorianCalendar();
        aCalendar.setTime(aDate);
        return aCalendar.get(3);
    }

    public static Timestamp timestampByAddingDays(Timestamp reference, int days) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(reference.getTime());
        cal.add(5, days);
        return new Timestamp(cal.getTimeInMillis());
    }
}

