/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.contrib;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class StreamCtrl {
    public static final int BUFFER_SIZE = 1024;

    public static String readStringFromStream(DataInputStream dataIn) throws IOException {
        int i2 = dataIn.readInt();
        if (i2 > 0) {
            byte[] bytes = new byte[i2];
            dataIn.read(bytes);
            return new String(bytes);
        }
        return "";
    }

    public static void writeStringToStream(String aString, DataOutputStream dataOut) throws IOException {
        if (aString != null && aString.length() != 0) {
            byte[] bytes = aString.getBytes();
            dataOut.writeInt(bytes.length);
            dataOut.write(bytes, 0, bytes.length);
        } else {
            dataOut.writeInt(0);
        }
    }

    public static void saveContentToFile(InputStream content, String filePath) throws IOException {
        StreamCtrl.saveContentToFile(content, filePath, -1L);
    }

    public static void saveContentToFile(InputStream content, String filePath, long contentSize) throws IOException {
        FileOutputStream out = null;
        if (filePath != null) {
            out = new FileOutputStream(filePath);
        }
        StreamCtrl.writeContentToStream(content, out, contentSize);
        if (out != null) {
            out.flush();
            StreamCtrl.forceClose(out);
        }
    }

    public static void writeContentToStream(InputStream content, OutputStream out, long contentSize) throws IOException {
        int bytesRead;
        byte[] bBuffer = new byte[1024];
        long bytesTotal = 0L;
        do {
            if ((bytesRead = content.read(bBuffer, 0, 1024)) <= 0) continue;
            if (out != null) {
                out.write(bBuffer, 0, bytesRead);
            }
            bytesTotal += (long)bytesRead;
        } while ((contentSize < 0L || bytesTotal < contentSize) && bytesRead > 0);
        if (out != null) {
            out.flush();
        }
    }

    public static void writeContentToStream(InputStream content, OutputStream out) throws IOException {
        StreamCtrl.writeContentToStream(content, out, -1L);
    }

    public static void forceClose(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void forceClose(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void forceClose(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

