/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.contrib;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;
import org.cocktail.trv.zap.contrib.StringCtrl;

public class FileCtrl {
    public static final String SEPARATOR = "/";

    public static boolean existsFile(String path) {
        try {
            return new File(path).exists();
        }
        catch (Throwable var2) {
            var2.printStackTrace();
            return false;
        }
    }

    public static boolean deleteFile(String filePath) {
        try {
            return new File(filePath).delete();
        }
        catch (Throwable var2) {
            var2.printStackTrace();
            return false;
        }
    }

    public static boolean deleteFiles(String filesPattern) {
        boolean noErrors = true;
        try {
            String[] files = FileCtrl.listDir(FileCtrl.getParentDirectory(filesPattern), FileCtrl.getFileName(filesPattern), true);
            if (files != null) {
                for (int i2 = 0; i2 < files.length; ++i2) {
                    if (FileCtrl.deleteFile(files[i2])) continue;
                    noErrors = false;
                }
            }
        }
        catch (Throwable var4) {
            var4.printStackTrace();
            noErrors = false;
        }
        return noErrors;
    }

    public static boolean deleteDir(String dirPath, boolean recursive) {
        try {
            File f2 = new File(dirPath);
            if (!f2.isDirectory()) {
                return false;
            }
            String[] subFiles = f2.list();
            if (!recursive && subFiles.length > 0) {
                return false;
            }
            return recursive ? FileCtrl.cleanDir(dirPath, true) : FileCtrl.deleteFile(dirPath);
        }
        catch (Throwable var7) {
            var7.printStackTrace();
            return false;
        }
    }

    public static boolean deletePath(String path) {
        if (FileCtrl.existsFile(path)) {
            return FileCtrl.isDirectory(path) ? FileCtrl.deleteDir(path, true) : FileCtrl.deleteFile(path);
        }
        return true;
    }

    public static boolean cleanDir(String dirPath) {
        return FileCtrl.cleanDir(dirPath, false);
    }

    private static boolean cleanDir(String dirPath, boolean deleteDir) {
        boolean hasError = false;
        try {
            File f2 = new File(dirPath);
            if (!f2.isDirectory()) {
                return false;
            }
            String[] subFiles = f2.list();
            String absPath = FileCtrl.normalizeDirName(dirPath);
            for (int i2 = 0; i2 < subFiles.length; ++i2) {
                String path = absPath + subFiles[i2];
                f2 = new File(path);
                if (f2.isDirectory()) {
                    if (FileCtrl.cleanDir(path, true)) continue;
                    hasError = true;
                    continue;
                }
                if (FileCtrl.deleteFile(path)) continue;
                hasError = true;
            }
            if (deleteDir && !new File(dirPath).delete()) {
                hasError = true;
            }
            return !hasError;
        }
        catch (Throwable var8) {
            var8.printStackTrace();
            return false;
        }
    }

    public static String[] listDir(String dirPath) {
        return FileCtrl.listDir(dirPath, "*", false);
    }

    public static String[] listDir(String dirPath, String fileNamePattern, boolean useFullPath) {
        try {
            File dir = new File(dirPath);
            if (dir.isDirectory()) {
                if (fileNamePattern == null) {
                    fileNamePattern = "*";
                }
                String[] files = dir.list(new FileListFilter(fileNamePattern));
                if (useFullPath) {
                    for (int i2 = 0; i2 < files.length; ++i2) {
                        files[i2] = FileCtrl.normalizeDirName(dirPath) + files[i2];
                    }
                }
                return files;
            }
        }
        catch (Throwable var6) {
            var6.printStackTrace();
        }
        return null;
    }

    public static Vector findFiles(String dirPath, String filePattern, boolean recursive) {
        Vector<String> files = new Vector<String>();
        Vector subFiles = new Vector();
        String[] dirContent = FileCtrl.listDir(dirPath, "*", true);
        if (dirContent != null) {
            int i2;
            for (i2 = 0; i2 < dirContent.length; ++i2) {
                if (StringCtrl.like(FileCtrl.getFileName(dirContent[i2]), filePattern)) {
                    files.addElement(dirContent[i2]);
                }
                if (!recursive || !FileCtrl.isDirectory(dirContent[i2])) continue;
                Vector v2 = FileCtrl.findFiles(dirContent[i2], filePattern, recursive);
                for (int j2 = 0; j2 < v2.size(); ++j2) {
                    subFiles.addElement(v2.elementAt(j2));
                }
            }
            for (i2 = 0; i2 < subFiles.size(); ++i2) {
                files.addElement((String)subFiles.elementAt(i2));
            }
        }
        return files;
    }

    public static boolean renameFile(String oldPath, String newPath) {
        try {
            File fileSource = new File(oldPath);
            File fileDest = new File(newPath);
            return fileSource.renameTo(fileDest);
        }
        catch (Throwable var4) {
            var4.printStackTrace();
            return false;
        }
    }

    public static boolean makeDir(String dirName) {
        try {
            return new File(dirName).mkdir();
        }
        catch (Throwable var2) {
            var2.printStackTrace();
            return false;
        }
    }

    public static boolean makeDirs(String path, String mustExistPath) {
        if (mustExistPath == null || FileCtrl.existsFile(mustExistPath) && path.startsWith(mustExistPath)) {
            String subPath = !path.startsWith(SEPARATOR) && !path.startsWith("\\") ? "" : SEPARATOR;
            Vector vpath = FileCtrl.pathToVector(path);
            try {
                for (int i2 = 0; i2 < vpath.size(); ++i2) {
                    if (subPath.length() > 0 && !subPath.equals(SEPARATOR)) {
                        subPath = subPath + SEPARATOR;
                    }
                    if (FileCtrl.existsFile(subPath = subPath + vpath.elementAt(i2)) || new File(subPath).mkdir()) continue;
                    return false;
                }
                return true;
            }
            catch (Throwable var5) {
                var5.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static long getFileSize(String fileName) {
        try {
            if (FileCtrl.existsFile(fileName)) {
                return new File(fileName).length();
            }
        }
        catch (Throwable var2) {
            var2.printStackTrace();
        }
        return -1L;
    }

    public static String getFullPath(String fileName) {
        try {
            return new File(fileName).getAbsolutePath();
        }
        catch (Throwable var2) {
            var2.printStackTrace();
            return "";
        }
    }

    public static String getFileName(String path) {
        return FileCtrl.getFileName(path, false);
    }

    public static String getFileName(String path, boolean stripExtention) {
        try {
            path = path.trim();
            if (path.endsWith(SEPARATOR) || path.endsWith("\\")) {
                return "";
            }
            StringTokenizer st = new StringTokenizer(path, "/\\");
            while (st.hasMoreTokens()) {
                path = st.nextToken();
            }
            if (path != null) {
                if (stripExtention && path.indexOf(46) >= 0) {
                    path = path.substring(0, path.indexOf(46));
                }
                return path;
            }
        }
        catch (Throwable var4) {
            var4.printStackTrace();
        }
        return "";
    }

    public static String getParentDirectory(String fullPath) {
        String path = fullPath;
        try {
            if (path.endsWith(SEPARATOR) || path.endsWith("\\")) {
                path = path.substring(0, path.length() - 1);
            }
            StringTokenizer st = new StringTokenizer(path, "/\\");
            while (st.hasMoreTokens()) {
                path = st.nextToken();
            }
            if (path != null && path.length() != 0) {
                int i2 = fullPath.lastIndexOf(path);
                if (i2 > 0) {
                    path = fullPath.substring(0, i2);
                }
            } else {
                path = fullPath;
            }
            if (path.length() > 1 && (path.endsWith(SEPARATOR) || path.endsWith("\\"))) {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }
        catch (Throwable var5) {
            var5.printStackTrace();
            return "";
        }
    }

    public static String getNewNameInDir(String dir) {
        String s2 = FileCtrl.currentDateForName().substring(2);
        int i2 = 0;
        while (FileCtrl.existsFile(dir + s2 + "." + i2)) {
            ++i2;
        }
        return s2 + "." + i2;
    }

    public static String getNewNameInDir(String dir, String defaultPrefix) {
        dir = dir != null && dir.length() != 0 ? FileCtrl.normalizeDirName(dir) : "";
        defaultPrefix = defaultPrefix + "." + new Date().getTime();
        if (!FileCtrl.existsFile(dir + defaultPrefix)) {
            return defaultPrefix;
        }
        int i2 = 0;
        while (FileCtrl.existsFile(dir + defaultPrefix + "." + i2)) {
            ++i2;
        }
        return defaultPrefix + "." + i2;
    }

    private static String currentDateForName() {
        GregorianCalendar cal = new GregorianCalendar();
        String sb = cal.get(1) + StringCtrl.get0Int(cal.get(2) + 1, 2) + StringCtrl.get0Int(cal.get(5), 2) + StringCtrl.get0Int(cal.get(11), 2) + StringCtrl.get0Int(cal.get(12), 2);
        return sb;
    }

    public static String getNewNameFromName(String fileName, String prefix, String suffix, boolean unique) {
        String dir = FileCtrl.getParentDirectory(fileName);
        String newName = "";
        if (prefix != null) {
            newName = prefix;
        }
        newName = newName + FileCtrl.getFileName(fileName);
        if (suffix != null) {
            newName = newName + suffix;
        }
        dir = FileCtrl.normalizeDirName(dir);
        return unique ? dir + FileCtrl.getNewNameInDir(dir, newName) : dir + newName;
    }

    public static String getNewNameFromName(String fileName, String prefix, String suffix) {
        return FileCtrl.getNewNameFromName(fileName, prefix, suffix, true);
    }

    public static String normalizeDirName(String dirName) {
        if (dirName == null) {
            return null;
        }
        return !dirName.endsWith(SEPARATOR) && !dirName.endsWith("\\") ? dirName + SEPARATOR : dirName;
    }

    public static boolean isBasicName(String fileName) {
        return StringCtrl.toBasicString(fileName).equals(fileName);
    }

    public static boolean isBasicPath(String path) {
        Vector vpath = FileCtrl.pathToVector(path);
        for (int i2 = 0; i2 < vpath.size(); ++i2) {
            if (FileCtrl.isBasicName((String)vpath.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static Vector pathToVector(String path) {
        Vector<String> vpath = new Vector<String>();
        StringTokenizer st = new StringTokenizer(path, "\\/");
        while (st.hasMoreElements()) {
            vpath.addElement(st.nextToken());
        }
        return vpath;
    }

    public static boolean isAbsolutePath(String path) {
        try {
            return new File(path).isAbsolute();
        }
        catch (Throwable var2) {
            return false;
        }
    }

    public static boolean isDirectory(String path) {
        try {
            return new File(path).isDirectory();
        }
        catch (Throwable var2) {
            return false;
        }
    }

    public static class FileListFilter
    implements FilenameFilter {
        private final String pattern;

        public FileListFilter(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(File dir, String fileName) {
            return StringCtrl.like(fileName, this.pattern);
        }
    }
}

