/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.Server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.cocktail.trv.zap.CAS.HTTPSClient;
import org.cocktail.trv.zap.Dock;

public class HttpServer
extends RouterNanoHTTPD {
    public HttpServer() {
        super(0);
        this.addMappings();
    }

    @Override
    public void addMappings() {
        super.addMappings();
        this.addRoute("/cas-credentials", CredentialsHandler.class, new Object[0]);
        this.addRoute("/invalid-token", InvalidTokenHandler.class, new Object[0]);
    }

    public static class InvalidTokenHandler
    extends RouterNanoHTTPD.DefaultHandler {
        @Override
        public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                session.parseBody(map);
                HashMap params = new Gson().fromJson(map.get("postData"), HashMap.class);
                String invalidToken = (String)params.get("token");
                String applicationName = (String)params.get("application");
                String appIdStr = (String)params.get("app-uuid");
                UUID appId = appIdStr != null ? UUID.fromString(appIdStr) : null;
                Dock.getInstance().getAuthentification().tokenExpired(invalidToken, applicationName, appId);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            catch (NanoHTTPD.ResponseException e3) {
                e3.printStackTrace();
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            return super.post(uriResource, urlParams, session);
        }

        @Override
        public String getText() {
            return "InvalidTokenHandler received";
        }

        @Override
        public NanoHTTPD.Response.IStatus getStatus() {
            return NanoHTTPD.Response.Status.OK;
        }

        @Override
        public String getMimeType() {
            return "application/json";
        }
    }

    public static class CredentialsHandler
    extends RouterNanoHTTPD.DefaultHandler {
        @Override
        public String getText() {
            Gson gson = new Gson();
            String json = gson.toJson(Dock.getInstance().getAuthentification().cas.getCookie());
            return this.addUserAgent(this.patchCookieVersion(json));
        }

        private String patchCookieVersion(String json) {
            if (json != null) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    Map result = mapper.readValue(json, HashMap.class);
                    result.put("cookieVersion", 0);
                    result.put("hasPathAttribute", true);
                    json = mapper.writeValueAsString(result);
                }
                catch (JsonMappingException jsonMappingException) {
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            return json;
        }

        private String addUserAgent(String json) {
            if (json != null) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    Map result = mapper.readValue(json, HashMap.class);
                    result.put("user-agent", HTTPSClient.USER_AGENT);
                    json = mapper.writeValueAsString(result);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            return json;
        }

        @Override
        public NanoHTTPD.Response.IStatus getStatus() {
            return NanoHTTPD.Response.Status.OK;
        }

        @Override
        public String getMimeType() {
            return "application/json";
        }
    }
}

