/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.Server;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.hc.client5.http.cookie.Cookie;
import org.cocktail.trv.zap.Constants;
import org.cocktail.trv.zap.Dock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Communication
extends Thread {
    static final String CRLF = "\r\n";
    private static final Logger LOGGER = LoggerFactory.getLogger(Communication.class);
    private final Socket socket;
    private final OutputStream output;
    private final BufferedReader br;
    private String ticket = null;

    public Communication(Socket sock) throws IOException {
        this.socket = sock;
        this.output = this.socket.getOutputStream();
        this.br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
    }

    @Override
    public void run() {
        try {
            this.processRequest();
        }
        catch (Exception e2) {
            LOGGER.error(e2.getMessage(), e2);
        }
    }

    private void processRequest() throws Exception {
        LOGGER.trace("Attente de communication...");
        String headerLine = this.br.readLine();
        LOGGER.trace("headerLine:" + headerLine);
        if (headerLine.equals(CRLF) || headerLine.equals("")) {
            this.close();
            return;
        }
        StringTokenizer s2 = new StringTokenizer(headerLine);
        String method = s2.nextToken();
        if (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("RAWGET")) {
            HashMap<String, Object> tab;
            this.extractTicket(s2);
            try {
                tab = Dock.isTicketValid(Long.parseLong(this.ticket));
            }
            catch (Exception e2) {
                this.close();
                return;
            }
            if (tab == null) {
                this.close();
                return;
            }
            if (method.equalsIgnoreCase("GET")) {
                this.httpResponse(tab);
            } else if (method.equalsIgnoreCase("RAWGET")) {
                this.tcpResponse();
            }
        }
        this.close();
    }

    private void tcpResponse() throws IOException {
        LOGGER.info("Envoi du login...");
        DataOutputStream data = new DataOutputStream(this.output);
        byte[] bytes = Dock.getInstance().getLogin().getBytes();
        data.writeInt(Dock.getInstance().getLogin().getBytes().length);
        data.write(Dock.getInstance().getLogin().getBytes());
        data.flush();
        LOGGER.info("Login envoye");
    }

    private void httpResponse(HashMap<String, Object> tab) throws IOException {
        String serverLine = "TcpServer: Dock\r\n";
        String appliURL = (String)tab.get("url");
        LOGGER.info("url de l'application:" + appliURL);
        Cookie cookie = (Cookie)tab.get("cookie");
        if (appliURL == null || cookie == null) {
            this.sendError("GET");
            LOGGER.trace("AppliURL ou cookie null");
            return;
        }
        String entityBody = "\r\n<HTML><HEAD><meta http-equiv=\"refresh\" content=\"0;url=" + appliURL + "\"></HEAD></HTML>";
        String statusLine = "HTTP/1.0 200 OK\r\n";
        String contentTypeLine = "Content-type: text/html\r\n";
        String contentLengthLine = "Content-Length: " + entityBody.length() + CRLF;
        String cookieLine = "Set-Cookie: " + cookie.getName() + "=" + cookie.getValue() + ";path=" + cookie.getPath() + ";domain=" + Constants.getInstance().valueForKey("DOMAIN") + CRLF;
        LOGGER.trace("cookieLine" + cookieLine);
        this.output.write(statusLine.getBytes());
        this.output.write(serverLine.getBytes());
        this.output.write(contentTypeLine.getBytes());
        this.output.write(cookieLine.getBytes());
        this.output.write(contentLengthLine.getBytes());
        this.output.write(cookieLine.getBytes());
        this.output.write(CRLF.getBytes());
        this.output.write(entityBody.getBytes());
        this.output.flush();
    }

    private void sendError(String method) throws IOException {
        if (method.equalsIgnoreCase("GET")) {
            String serverLine = "TcpServer: Dock\r\n";
            String statusLine = "HTTP/1.0 404 Not Found\r\n";
            String contentTypeLine = "text/html";
            String entityBody = "<HTML><HEAD><TITLE>404 Not Found</TITLE></HEAD><BODY>404 Not Found</BODY></HTML>";
            String contentLengthLine = "";
            this.output.write(statusLine.getBytes());
            this.output.write(serverLine.getBytes());
            this.output.write(contentTypeLine.getBytes());
            this.output.write(contentLengthLine.getBytes());
            this.output.write(CRLF.getBytes());
            this.output.write(entityBody.getBytes());
        } else if (method.equalsIgnoreCase("RAWGET")) {
            LOGGER.info("Envoi login error...");
            DataOutputStream data = new DataOutputStream(this.socket.getOutputStream());
            data.writeByte(10);
        }
        this.ticket = null;
        this.close();
    }

    private void extractTicket(StringTokenizer s2) {
        this.ticket = s2.nextToken();
        this.ticket = this.ticket.replaceFirst("/", "");
        int end = this.ticket.indexOf(63);
        if (end > 0) {
            this.ticket = this.ticket.substring(0, end);
        }
        LOGGER.info("ticket: " + this.ticket);
    }

    private void close() {
        try {
            this.output.flush();
            this.output.close();
            this.br.close();
            this.socket.close();
            LOGGER.info("Communication.close()");
            if (this.ticket != null) {
                Dock.deleteTicket(Long.parseLong(this.ticket));
            }
        }
        catch (Exception e2) {
            LOGGER.error(e2.getMessage(), e2);
        }
    }
}

