/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.cocktail.trv.zap.Gui.Favoris;
import org.cocktail.trv.zap.Messages;
import org.cocktail.trv.zap.contrib.StringCtrl;
import org.cocktail.trv.zap.contrib.SystemCtrl;
import org.cocktail.trv.zap.json.Application;
import org.cocktail.trv.zap.json.Root;
import org.cocktail.trv.zap.json.Theme;
import org.cocktail.trv.zap.misc.Utils;
import org.json.JSONObject;
import org.json.XML;
import org.json.XMLParserConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lister {
    private static final Logger LOGGER = LoggerFactory.getLogger(Lister.class);
    List<Theme> themes = new Vector<Theme>();
    Vector applicationsName = new Vector();
    List<Application> favoris = new Vector<Application>();
    Vector favorisName = new Vector();
    List<Theme> themeWindows = null;
    List<Theme> themeUnix = null;

    public void listApplications(URL url) {
        try {
            String xmlContent = Utils.getAsString(url);
            LOGGER.trace(xmlContent);
            this.themes = Lister.parse(xmlContent);
            this.themeUnix = null;
            this.themeWindows = null;
            this.postTraitement();
        }
        catch (Exception e2) {
            LOGGER.error(e2.getMessage(), e2);
            JOptionPane.showMessageDialog(null, Messages.getString("Favoris.unableToGetAppList") + url.toString(), Messages.getString("error"), 0);
        }
    }

    public static List<Theme> parse(String xmlContent) {
        HashSet<String> liste = new HashSet<String>(Arrays.asList("ThemeApplication", "Application"));
        XMLParserConfiguration config = new XMLParserConfiguration().withForceList(liste);
        JSONObject xmlJSONObj = XML.toJSONObject((Reader)new StringReader(xmlContent), config);
        String jsonPrettyPrintString = xmlJSONObj.toString(4);
        LOGGER.debug(jsonPrettyPrintString);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Root root = mapper.readValue(jsonPrettyPrintString, Root.class);
            return root.listeApplication.themeApplication;
        }
        catch (JsonProcessingException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void postTraitement() {
        this.themes.forEach(theme -> {
            if (theme.getApplications() != null) {
                List<Application> apps = theme.getApplications().stream().filter(app -> this.checkOs((Application)app)).collect(Collectors.toList());
                theme.setApplications(apps);
            }
        });
    }

    public void listFavoris() {
        this.favoris = Favoris.getFavoris();
    }

    public List<Theme> getAllThemes() {
        return this.themes;
    }

    public List<Application> getAllFavoris() {
        return this.favoris;
    }

    public List<Application> refreshFavoris() {
        return Favoris.refreshFavoris();
    }

    public Application getAppliBy(Predicate<Application> predicate) {
        Optional<Application> app = this.themes.stream().flatMap(a2 -> a2.getApplications().stream()).filter(predicate).filter(this::checkOs).findFirst();
        return app.get();
    }

    public Application getAppliByName(String name) {
        Predicate<Application> predicate = application -> name.equals(application.getName());
        return this.getAppliBy(predicate);
    }

    public Application getAppliByUUID(UUID uuid) {
        Predicate<Application> predicate = application -> uuid.equals(application.getId());
        return this.getAppliBy(predicate);
    }

    private boolean isWindowsOS() {
        return StringCtrl.containsIgnoreCase(SystemCtrl.osName(), "windows");
    }

    private boolean checkOs(Application application) {
        if (application.isExeWin()) {
            return this.isWindowsOS();
        }
        if (application.isExeUnix()) {
            return !this.isWindowsOS();
        }
        return true;
    }

    public Optional<Application> getFavoriByName(String name) {
        return this.favoris.stream().filter(fav -> fav.getName().equalsIgnoreCase(name)).findFirst();
    }

    public List<Application> getApplications(Predicate<Application> predicate) {
        return this.themes.stream().flatMap(a2 -> a2.getApplications().stream()).filter(predicate).collect(Collectors.toList());
    }

    public List<Application> getApplicationsWindows() {
        Predicate<Application> isWindowsApp = Application::isExeWin;
        return this.getApplications(isWindowsApp);
    }

    public List<Application> getApplicationsUnix() {
        Predicate<Application> isUnixApp = Application::isExeUnix;
        return this.getApplications(isUnixApp);
    }

    public List<Application> getApplicationsForMySystem() {
        if (this.isWindowsOS()) {
            return this.getApplicationsWindows();
        }
        LOGGER.trace("System de type Unix");
        return this.getApplicationsUnix();
    }

    public List<Theme> getThemesForMySystem() {
        return this.getAllThemes();
    }
}

