/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.Gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cocktail.trv.zap.Constants;
import org.cocktail.trv.zap.Messages;

public class OptionWin
extends AbstractAction
implements ChangeListener {
    final JCheckBox proxy = new JCheckBox("", Constants.getInstance().valueForKey("PROXY").equals("YES"));
    final JTextField proxyHost = new JTextField(Constants.getInstance().valueForKey("PROXY_HOST"));
    final JLabel proxyHostLabel = new JLabel(Messages.getString("OptionWin.proxyHost"), 4);
    final JTextField proxyPort = new JTextField(Constants.getInstance().valueForKey("PROXY_PORT"));
    final JLabel proxyPortLabel = new JLabel(Messages.getString("OptionWin.proxyPort"), 4);
    final JTextField nonProxyDomain = new JTextField(Constants.getInstance().valueForKey("NON_PROXY"));
    final JLabel nonProxyDomainLabel = new JLabel(Messages.getString("OptionWin.noProxyFor"), 4);
    JTextField xmlURL = new JTextField();
    private JDialog dialog;

    public void buildInterface() {
        this.dialog = new JDialog();
        this.dialog.setResizable(false);
        this.dialog.setSize(410, 180);
        this.dialog.setTitle(Messages.getString("OptionWin.title"));
        JPanel p1 = new JPanel(new GridLayout(6, 2, 5, 5));
        p1.add(new JLabel(Messages.getString("OptionWin.proxyUsage"), 4));
        this.proxy.setHorizontalAlignment(2);
        p1.add(this.proxy);
        this.proxy.addChangeListener(this);
        p1.add(this.proxyHostLabel);
        p1.add(this.proxyHost);
        if (!this.proxy.isSelected()) {
            this.proxyHost.setEnabled(false);
        }
        p1.add(this.proxyPortLabel);
        p1.add(this.proxyPort);
        if (!this.proxy.isSelected()) {
            this.proxyPort.setEnabled(false);
        }
        p1.add(this.nonProxyDomainLabel);
        p1.add(this.nonProxyDomain);
        if (!this.proxy.isSelected()) {
            this.nonProxyDomain.setEnabled(false);
        }
        JButton ok = new JButton(Messages.getString("validate"));
        JButton cancel = new JButton(Messages.getString("cancel"));
        ok.setActionCommand("ok");
        ok.addActionListener(this);
        cancel.setActionCommand("cancel");
        cancel.addActionListener(this);
        p1.add(ok);
        p1.add(cancel);
        JPanel p2 = new JPanel(new BorderLayout(0, 10));
        p2.add((Component)p1, "Center");
        p2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialog.setContentPane(p2);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.dialog.getSize();
        this.dialog.setLocation((screen.width - window.width) / 2, (screen.height - window.height) / 2);
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getActionCommand().equalsIgnoreCase("ok")) {
            String useProxy = this.proxy.isSelected() ? "YES" : "NO";
            String host = this.proxyHost.getText();
            String port = this.proxyPort.getText();
            String non = this.nonProxyDomain.getText();
            Constants.getInstance().setProperty("PROXY", useProxy);
            Constants.getInstance().setProperty("PROXY_HOST", host);
            Constants.getInstance().setProperty("PROXY_PORT", port);
            Constants.getInstance().setProperty("NON_PROXY", non);
        }
        this.dialog.setVisible(false);
    }

    @Override
    public void stateChanged(ChangeEvent e2) {
        if (this.proxy.isSelected()) {
            this.proxyHost.setEnabled(true);
            this.proxyPort.setEnabled(true);
            this.nonProxyDomain.setEnabled(true);
            this.proxyHostLabel.setEnabled(true);
            this.proxyPortLabel.setEnabled(true);
            this.nonProxyDomainLabel.setEnabled(true);
        } else {
            this.proxyHost.setEnabled(false);
            this.proxyPort.setEnabled(false);
            this.nonProxyDomain.setEnabled(false);
            this.proxyHostLabel.setEnabled(false);
            this.proxyPortLabel.setEnabled(false);
            this.nonProxyDomainLabel.setEnabled(false);
        }
    }
}

