/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.Gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import org.cocktail.trv.zap.Dock;
import org.cocktail.trv.zap.Gui.AppliTunningWin;
import org.cocktail.trv.zap.Gui.Favoris;
import org.cocktail.trv.zap.Gui.OptionWin;
import org.cocktail.trv.zap.Messages;
import org.cocktail.trv.zap.json.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Mouse
implements MouseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mouse.class);
    private final Dock dock = Dock.getInstance();
    private final String command;
    private JPopupMenu popup;
    private JFrame frame;

    public Mouse(String command) {
        this.command = command;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        String second;
        String first;
        StringTokenizer token;
        int input_modifiers = e2.getModifiers();
        if ((input_modifiers & 4) != 0 || (input_modifiers & 8) != 0 || (input_modifiers & 2) != 0 && (input_modifiers & 0x10) != 0) {
            token = new StringTokenizer(this.command, "/");
            first = token.nextToken();
            if (first.equalsIgnoreCase("menu")) {
                second = token.nextToken();
                if (second.equalsIgnoreCase("Application")) {
                    String theme = token.nextToken();
                    String application = token.nextToken();
                    int answer = JOptionPane.showConfirmDialog(this.frame, Messages.getString("message.confirmAddToFavorite"));
                    if (answer == 0) {
                        try {
                            Favoris.getInstance().add(Dock.getInstance().getLister().getAppliByName(application));
                            Dock.getInstance().repaint();
                        }
                        catch (IOException e1) {
                            LOGGER.error(e1.getMessage(), e1);
                            e1.printStackTrace();
                        }
                    }
                    return;
                }
            } else if (first.equalsIgnoreCase("button")) {
                String action = token.nextToken();
                String favoris = token.nextToken();
                this.popup = new JPopupMenu();
                JMenuItem item = new JMenuItem(Messages.getString("Favoris.removeFromFavorit"));
                JMenuItem item2 = new JMenuItem(Messages.getString("Favoris.preferences"));
                item.addMouseListener(new Mouse("button/popup/remove/" + favoris));
                item2.addMouseListener(new Mouse("button/popup/preference/" + favoris));
                this.popup.add(item);
                this.popup.add(item2);
                this.popup.show(e2.getComponent(), e2.getX(), e2.getY());
                return;
            }
        }
        if ((input_modifiers & 0x10) != 0) {
            token = new StringTokenizer(this.command, "/");
            first = token.nextToken();
            if (first.equalsIgnoreCase("menu")) {
                String third;
                second = token.nextToken();
                if (second.equalsIgnoreCase("Application")) {
                    String theme = token.nextToken();
                    String application = token.nextToken();
                    new Thread(() -> this.dock.launch(this.dock.getLister().getAppliByName(application))).start();
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    System.gc();
                    LOGGER.info("clearSelection Menu");
                }
                if (second.equalsIgnoreCase(Messages.getString("MainWin.display"))) {
                    int answer;
                    third = token.nextToken();
                    if (third.equalsIgnoreCase(Messages.getString("MainWin.refreshAppList"))) {
                        this.dock.repaint();
                    } else if (third.equalsIgnoreCase(Messages.getString("MainWin.reinitConfig")) && (answer = JOptionPane.showConfirmDialog(this.frame, Messages.getString("message.confirmReinitConfig"))) == 0) {
                        this.dock.reinitConf();
                    }
                } else if (second.equalsIgnoreCase(Messages.getString("MainWin.tools"))) {
                    third = token.nextToken();
                    if (third.equalsIgnoreCase(Messages.getString("MainWin.reinitConfig"))) {
                        int answer = JOptionPane.showConfirmDialog(this.frame, Messages.getString("message.confirmReinitConfig"));
                        if (answer == 0) {
                            this.dock.reinitConf();
                        }
                    } else if (third.equalsIgnoreCase(Messages.getString("MainWin.prefs"))) {
                        OptionWin proxyWin = new OptionWin();
                        proxyWin.buildInterface();
                    }
                } else if (second.equalsIgnoreCase("Quitter")) {
                    System.exit(0);
                }
            } else if (first.equalsIgnoreCase("button")) {
                second = token.nextToken();
                if (second.equalsIgnoreCase("launch")) {
                    String favoris = token.nextToken();
                    this.dock.launch(this.dock.getLister().getAppliByName(favoris));
                    System.gc();
                } else if (second.equalsIgnoreCase("popup")) {
                    String action = token.nextToken();
                    if (action.equalsIgnoreCase("remove")) {
                        Optional<Application> fav = this.dock.getLister().getFavoriByName(token.nextToken());
                        if (fav.isPresent()) {
                            try {
                                Favoris.getInstance().remove(fav.get());
                            }
                            catch (IOException e1) {
                                LOGGER.error(e1.getMessage(), e1);
                            }
                            this.dock.repaint();
                        }
                    } else if (action.equalsIgnoreCase("preference")) {
                        new AppliTunningWin(token.nextToken());
                    }
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }
}

