/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.Gui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.cocktail.trv.zap.Constants;
import org.cocktail.trv.zap.json.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Favoris {
    private static final Logger LOGGER = LoggerFactory.getLogger(Favoris.class);
    private static Favoris favoris;
    private final File myXml;
    private List<Application> liste = new ArrayList<Application>();
    private FileOutputStream xmlOs;

    private Favoris() {
        this.myXml = new File(Constants.getInstance().getFavorisFile());
        if (this.myXml.exists() && this.myXml.canRead()) {
            this.load();
        }
    }

    public static List<Application> getFavoris() {
        return Favoris.getInstance().liste;
    }

    public static Favoris getInstance() {
        if (favoris == null) {
            favoris = new Favoris();
        }
        return favoris;
    }

    public static List<Application> refreshFavoris() {
        favoris = new Favoris();
        return Favoris.favoris.liste;
    }

    private void load() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            List<Application> liste = mapper.readValue(this.myXml, new TypeReference<List<Application>>(){});
            this.liste = liste;
        }
        catch (JsonProcessingException e2) {
            throw new RuntimeException(e2);
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    public void store() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            byte[] bytes = mapper.writeValueAsBytes(this.liste);
            Files.write(this.myXml.toPath(), bytes, new OpenOption[0]);
        }
        catch (JsonProcessingException e2) {
            throw new RuntimeException(e2);
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    void add(Application appli) throws IOException {
        LOGGER.info(" ajout de " + appli.getName());
        if (appli.getShortName() != null) {
            appli.setShortName(appli.getShortName());
        }
        this.liste.add(appli);
        this.store();
    }

    void remove(Application appli) throws IOException {
        LOGGER.info(" retrait de " + appli.getName());
        this.liste.remove(appli);
        this.store();
    }

    private boolean isPresent(Application appli) {
        return this.liste.contains(appli);
    }
}

