/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.cocktail.trv.zap.Arguments;
import org.cocktail.trv.zap.Authentification;
import org.cocktail.trv.zap.Constants;
import org.cocktail.trv.zap.Gui.MainWin;
import org.cocktail.trv.zap.Launcher;
import org.cocktail.trv.zap.Lister;
import org.cocktail.trv.zap.Messages;
import org.cocktail.trv.zap.Server.HttpServer;
import org.cocktail.trv.zap.Server.Server;
import org.cocktail.trv.zap.contrib.FileCtrl;
import org.cocktail.trv.zap.json.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dock {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dock.class);
    protected static List<HashMap<String, Object>> ticketStore;
    private static Dock dock;
    private final List<Application> applications;
    private final Authentification authentification;
    private final Arguments arguments;
    private Server server;
    private final Lister lister;
    private final MainWin win;
    private HttpServer httpServer;

    public Dock(Arguments arguments) {
        this.arguments = arguments;
        ticketStore = new ArrayList<HashMap<String, Object>>();
        this.applications = null;
        this.lister = new Lister();
        dock = this;
        Constants.init(this);
        this.authentification = new Authentification();
        this.listApplications();
        this.initServer();
        this.initHttpdServer();
        this.cleanJnlp();
        LOGGER.info("Demarrage de Zap ");
        LOGGER.trace("Version: " + Constants.getInstance().valueForKey("VERSION"));
        this.win = new MainWin();
        this.win.buildInterface(this.lister.getThemesForMySystem(), this.lister.getAllFavoris());
    }

    public static HashMap<String, Object> isTicketValid(long ticket) {
        if (ticketStore == null) {
            return null;
        }
        for (int i2 = 0; i2 < ticketStore.size(); ++i2) {
            HashMap<String, Object> tab = ticketStore.get(i2);
            if ((Long)tab.get("ticket") != ticket) continue;
            return tab;
        }
        return null;
    }

    public static void deleteTicket(long ticket) {
        if (ticketStore != null) {
            for (int i2 = 0; i2 < ticketStore.size(); ++i2) {
                Map tab = ticketStore.get(i2);
                if ((Long)tab.get("ticket") != ticket) continue;
                ticketStore.remove(i2);
            }
        }
    }

    public static Dock getInstance() {
        if (dock == null) {
            throw new IllegalStateException("Le singleton Dock doit \u00eatre instanci\u00e9 avant l'acc\u00e8s \u00e0 cette m\u00e9thode !");
        }
        return dock;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        dock = new Dock(arguments);
    }

    public void initServer() {
        try {
            this.server = new Server();
            this.server.accept();
        }
        catch (IOException e2) {
            LOGGER.error(e2.getMessage(), e2);
            JOptionPane.showMessageDialog(null, e2.getMessage(), Messages.getString("error.socketError"), 0);
            System.exit(0);
        }
    }

    public void initHttpdServer() {
        this.httpServer = new HttpServer();
        try {
            this.httpServer.start(5000, true);
            LOGGER.info("Serveur HTTP d\u00e9marr\u00e9 sur " + this.httpServer.getListeningPort());
        }
        catch (IOException e2) {
            LOGGER.info("Erreur au lancement du serveur HTTP");
        }
    }

    public void listApplications() {
        try {
            URL url = new URL(Constants.getInstance().valueForKey("XML"));
            this.lister.listApplications(url);
            LOGGER.info("Chargement de la liste des application depuis l'URL: " + url);
        }
        catch (Exception e2) {
            LOGGER.error(e2.getMessage(), e2);
            JOptionPane.showMessageDialog(null, e2.getMessage(), Messages.getString("error.applistError"), 0);
        }
        this.lister.listFavoris();
    }

    public void reinitConf() {
        File configFile = new File(Constants.getInstance().getConfigFileParam());
        File favorisFile = new File(Constants.getInstance().getFavorisFile());
        LOGGER.info("suppression des fichiers:" + configFile.getAbsolutePath() + " , " + favorisFile.getAbsolutePath());
        configFile.delete();
        favorisFile.delete();
        Constants.getInstance().update(this);
        this.repaint();
    }

    public void launch(Application appli) {
        try {
            if (this.authentification.authenticate(appli)) {
                Long l2 = Launcher.start(appli, this.authentification.cas.getCookie());
            }
        }
        catch (IOException e2) {
            JOptionPane.showMessageDialog(null, e2.getMessage(), Messages.getString("error.launchError"), 0);
        }
        LOGGER.info("lancement termin\u00e9");
    }

    public String getLogin() {
        return this.authentification.getLogin();
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    public Authentification getAuthentification() {
        return this.authentification;
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    private void cleanJnlp() {
        FileCtrl.deleteFiles(Constants.getInstance().valueForKey("TEMP_DIR") + "*.jnlp");
    }

    public void repaint() {
        LOGGER.info("Rafraichissement de la liste des applications");
        this.listApplications();
        LOGGER.info("Reconstruction de l'interface graphique");
        this.win.buildInterface(this.lister.getThemesForMySystem(), this.lister.refreshFavoris());
    }

    protected void finalize() throws Throwable {
        try {
            this.server.close();
        }
        finally {
            super.finalize();
        }
    }

    public Lister getLister() {
        return this.lister;
    }

    public MainWin getWin() {
        return this.win;
    }

    public Arguments getArguments() {
        return this.arguments;
    }

    private static int getMajorJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dotIndex = version.indexOf(".");
            int dashIndex = version.indexOf("-");
            if (dotIndex != -1) {
                version = version.substring(0, dotIndex);
            } else if (dashIndex != -1) {
                version = version.substring(0, dashIndex);
            }
        }
        return Integer.parseInt(version);
    }

    private static void enableModuleExports() {
        try {
            StaticComponentContainer.Modules.exportAllToAll();
            LOGGER.info("Successfully exported all modules to all modules using Burningwave Core.");
        }
        catch (Exception e2) {
            LOGGER.error("Failed to export modules: " + e2.getMessage());
        }
    }

    private static void checkMajorJavaVersionAndConfigureModulesIfNecessary() {
        if (Dock.getMajorJavaVersion() >= 8) {
            Dock.enableModuleExports();
        }
    }

    static {
        Dock.checkMajorJavaVersionAndConfigureModulesIfNecessary();
    }
}

