/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.cocktail.trv.zap.Arguments;
import org.cocktail.trv.zap.Dock;
import org.cocktail.trv.zap.Ressources.Ressources;
import org.cocktail.trv.zap.contrib.SystemCtrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    private static final Logger LOGGER = LoggerFactory.getLogger(Constants.class);
    private static final String CONFIG = "org/cocktail/trv/zap/Ressources/ZAP.config";
    private static final String VERSION_PROPERTIES = "version.properties";
    private static final String VERSION = null;
    public static int DEBUG;
    public static String SERVER_PORT;
    private static Constants constants;
    private final Properties defaultConf;
    private Properties currentConf;
    private Properties userConf;

    public Constants(Arguments arguments) {
        LOGGER.info("Initialisation des param\u00e8tres...");
        this.defaultConf = this.loadZapConfFromFile(CONFIG);
        Properties versionConf = this.loadZapConfFromFile(VERSION_PROPERTIES);
        this.defaultConf.putAll((Map<?, ?>)versionConf);
        if (this.defaultConf == null) {
            LOGGER.info("org/cocktail/trv/zap/Ressources/ZAP.config fichier corrompu");
            System.exit(0);
        }
        this.currentConf = (Properties)this.defaultConf.clone();
        this.surchargeAvecArgumentsVenantDuJnlp(arguments);
        if (this.userConf != null) {
            if (this.isUserVersionOK(this.getConfigFileParam())) {
                LOGGER.info("Version correcte : utilisation de la configuration existante");
                this.updateCurrentConfWithUserConf();
            } else if (this.isUserVersionCompatible()) {
                this.updateUserConf();
                this.updateCurrentConfWithUserConf();
            } else {
                LOGGER.info("Ecriture d'une nouvelle configuration");
            }
        }
        if (this.valueForKey("PROXY") != null) {
            if (this.valueForKey("PROXY").equalsIgnoreCase("YES")) {
                LOGGER.trace("$$$$$Propertie AVANT" + System.getProperties().toString());
                LOGGER.trace("on set le PROXY");
                System.getProperties().put("proxySet", "true");
                System.getProperties().put("http.proxyHost", this.valueForKey("PROXY_HOST"));
                System.getProperties().put("http.proxyPort", this.valueForKey("PROXY_PORT"));
                System.getProperties().put("https.proxyHost", this.valueForKey("PROXY_HOST"));
                System.getProperties().put("https.proxyPort", this.valueForKey("PROXY_PORT"));
                System.getProperties().put("http.nonProxyHosts", this.valueForKey("NON_PROXY"));
                LOGGER.trace("$$$$$Propertie APRES" + System.getProperties().toString());
            } else {
                System.getProperties().put("proxySet", "false");
            }
        }
    }

    public static void init(Dock dock) {
        constants = new Constants(dock.getArguments());
    }

    public static Constants getInstance() {
        if (constants == null) {
            throw new IllegalStateException("Constants doit \u00eatre instanci\u00e9 avec le Dock");
        }
        return constants;
    }

    protected void surchargeAvecArgumentsVenantDuJnlp(Arguments arguments) {
        Properties currentConfCopy = (Properties)this.currentConf.clone();
        for (Map.Entry<Object, Object> entry : currentConfCopy.entrySet()) {
            String key = (String)entry.getKey();
            String existingArgumentFromJnlp = arguments.get(key);
            if (existingArgumentFromJnlp == null) continue;
            this.currentConf.setProperty(key, existingArgumentFromJnlp);
        }
    }

    public void restoreValueForKey(String key) {
        if (this.defaultConf != null && this.currentConf != null) {
            String value = this.defaultConf.getProperty(key);
            this.currentConf.setProperty(key, value);
            DEBUG = Integer.parseInt((String)this.currentConf.get("DEBUG"));
        }
    }

    public void restoreValues() {
        if (this.defaultConf != null && this.currentConf != null) {
            this.currentConf = (Properties)this.defaultConf.clone();
        }
    }

    public String valueForKey(String key) {
        if (this.currentConf != null) {
            return this.currentConf.getProperty(key);
        }
        return null;
    }

    public void setProperty(String key, String value) {
        if (this.currentConf != null) {
            this.currentConf.setProperty(key, value);
        }
    }

    private Properties loadZapConfFromFile(String file) {
        Properties prop = new Properties();
        ClassLoader cl = Ressources.class.getClassLoader();
        if (cl == null) {
            LOGGER.info("ClassLoader null");
            return null;
        }
        InputStream is = cl.getResourceAsStream(file);
        if (is == null) {
            LOGGER.info("InputStream null from " + file);
            return null;
        }
        try {
            prop.load(is);
            is.close();
            prop.setProperty("TEMP_DIR", SystemCtrl.tempDir());
            return prop;
        }
        catch (Exception e2) {
            LOGGER.info("Impossible de lire la configuration depuis " + file);
            return null;
        }
    }

    public String getConfigFileParam() {
        return System.getProperty("user.home") + System.getProperty("file.separator") + this.valueForKey("CONFIG_FILE");
    }

    public String getFavorisFile() {
        return System.getProperty("user.home") + System.getProperty("file.separator") + this.valueForKey("FAVORIS_FILE");
    }

    private void updateCurrentConfWithUserConf() {
        if (this.userConf.getProperty("DEBUG") != null) {
            this.currentConf.setProperty("DEBUG", this.userConf.getProperty("DEBUG"));
        }
        if (this.userConf.getProperty("PROXY") != null) {
            this.currentConf.setProperty("PROXY", this.userConf.getProperty("PROXY"));
        }
        if (this.userConf.getProperty("PROXY_HOST") != null) {
            this.currentConf.setProperty("PROXY_HOST", this.userConf.getProperty("PROXY_HOST"));
        }
        if (this.userConf.getProperty("PROXY_PORT") != null) {
            this.currentConf.setProperty("PROXY_PORT", this.userConf.getProperty("PROXY_PORT"));
        }
        if (this.userConf.getProperty("NON_PROXY") != null) {
            this.currentConf.setProperty("NON_PROXY", this.userConf.getProperty("NON_PROXY"));
        }
        if (this.userConf.getProperty("PBSAUTO") != null) {
            this.currentConf.setProperty("PBSAUTO", this.userConf.getProperty("PBSAUTO"));
        }
    }

    public void update(Dock dock) {
        constants = new Constants(dock.getArguments());
    }

    public boolean isUserVersionCompatible() {
        if (this.userConf.getProperty("VERSION") != null) {
            return this.userConf.getProperty("VERSION").equals("0.4.8");
        }
        return false;
    }

    public void updateUserConf() {
        this.userConf.setProperty("VERSION", this.defaultConf.getProperty("VERSION"));
    }

    private boolean isUserVersionOK(String file) {
        Properties prop = new Properties();
        File confFile = new File(file);
        if (confFile.exists() && confFile.canRead()) {
            try {
                FileInputStream fis = new FileInputStream(confFile);
                prop.load(fis);
                fis.close();
                LOGGER.info("Version de zap : " + this.defaultConf.getProperty("VERSION"));
                LOGGER.info("Version de la conf user : " + prop.getProperty("VERSION"));
                if (prop.getProperty("VERSION").equalsIgnoreCase((String)this.defaultConf.get("VERSION"))) {
                    LOGGER.info("version du fichier de conf OK");
                    return true;
                }
                LOGGER.info("Diff\ufffdrence de version entre " + prop.getProperty("VERSION") + "(user) vers " + this.defaultConf.get("VERSION") + "(ZAP)");
                return false;
            }
            catch (Exception e2) {
                LOGGER.error(e2.getMessage(), e2);
            }
        }
        return false;
    }

    private Properties loadUserConfFromFile(String file) {
        Properties prop = new Properties();
        File confFile = new File(file);
        if (confFile.exists() && confFile.canRead()) {
            LOGGER.trace("Lecture du fichier de conf:" + this.getConfigFileParam());
            try {
                FileInputStream fis = new FileInputStream(confFile);
                prop.load(fis);
                fis.close();
            }
            catch (Exception e2) {
                LOGGER.error(e2.getMessage(), e2);
            }
        }
        return prop;
    }

    public boolean isUsingXMLPerso() {
        return this.currentConf.equals(this.defaultConf);
    }

    static {
        SERVER_PORT = "";
    }
}

