/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap;

import iaik.x509.CertificateFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.cocktail.trv.zap.Constants;
import org.cocktail.trv.zap.Dock;
import org.cocktail.trv.zap.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Certificat {
    private static final Logger LOGGER = LoggerFactory.getLogger(Certificat.class);
    final X509Certificate cert;

    public Certificat(X509Certificate cert) {
        this.cert = cert;
    }

    private boolean verifyDate() {
        X509Certificate x509 = this.cert;
        try {
            x509.checkValidity();
            LOGGER.info("Date verifie");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean verifyCA() {
        Object acUtilisateurURL = null;
        Object acRacineURL = null;
        Object acUtilisateurPlusURL = null;
        Certificate ac_utilisateur_plus = null;
        Certificate ac_utilisateur = null;
        CertificateFactory cf = new CertificateFactory();
        ClassLoader cl = Dock.class.getClassLoader();
        try {
            InputStream isU = cl.getResourceAsStream(Constants.getInstance().valueForKey("AC_UTILISATEUR"));
            if (isU != null) {
                ac_utilisateur = (iaik.x509.X509Certificate)cf.engineGenerateCertificate(isU);
            }
            this.cert.verify(ac_utilisateur.getPublicKey());
            LOGGER.info("CA verifie");
            return true;
        }
        catch (Exception e2) {
            try {
                InputStream isUp = cl.getResourceAsStream(Constants.getInstance().valueForKey("AC_UTILISATEUR_PLUS"));
                if (isUp != null) {
                    ac_utilisateur_plus = (iaik.x509.X509Certificate)cf.engineGenerateCertificate(isUp);
                }
                this.cert.verify(ac_utilisateur_plus.getPublicKey());
                return true;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, Messages.getString("error.unableToCheckRootCert"), Messages.getString("error.certificatError"), 0);
                return false;
            }
        }
    }

    public boolean verifyCRL() {
        try {
            URL CRLUtilisateurURL = new URL(Constants.getInstance().valueForKey("CRL_UTILISATEUR_URL"));
            CertificateFactory cf = new CertificateFactory();
            X509CRL crlUtilisateur = (X509CRL)cf.engineGenerateCRL(CRLUtilisateurURL.openStream());
            if (crlUtilisateur.isRevoked(new iaik.x509.X509Certificate(this.cert.getEncoded()))) {
                URL CRLUtilisateurPlusURL = new URL(Constants.getInstance().valueForKey("CRL_UTILISATEUR_PLUS_URL"));
                X509CRL crlUtilisateurPlus = (X509CRL)cf.engineGenerateCRL(CRLUtilisateurURL.openStream());
                if (crlUtilisateurPlus.isRevoked(this.cert)) {
                    JOptionPane.showMessageDialog(null, Messages.getString("error.revokedCert"), Messages.getString("error.certificatError"), 0);
                    return false;
                }
                return true;
            }
            LOGGER.info("CRL verifi\ufffd");
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean verifyOID() {
        X509Certificate x509 = this.cert;
        String subject = x509.getSubjectDN().toString();
        subject = subject.replaceAll(",", "\n");
        ByteArrayInputStream is = new ByteArrayInputStream(subject.getBytes());
        Properties prop = new Properties();
        try {
            prop.load(is);
            if (prop.getProperty("O").equals(Constants.getInstance().valueForKey("OID"))) {
                LOGGER.info("OID valide");
                return true;
            }
            LOGGER.info("OID invalide");
            return false;
        }
        catch (IOException e2) {
            return false;
        }
    }

    public boolean verifyAll() {
        return this.verifyDate() && this.verifyCA() && this.verifyCRL() && this.verifyOID();
    }
}

