/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap;

import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.swing.JOptionPane;
import org.apache.hc.core5.http.ProtocolException;
import org.cocktail.trv.zap.CAS.AuthenticationCAS;
import org.cocktail.trv.zap.Certificat;
import org.cocktail.trv.zap.Constants;
import org.cocktail.trv.zap.Dock;
import org.cocktail.trv.zap.Gui.LoginWin;
import org.cocktail.trv.zap.Messages;
import org.cocktail.trv.zap.Ressources.Ressources;
import org.cocktail.trv.zap.Token.ChooseDialog;
import org.cocktail.trv.zap.Token.Token;
import org.cocktail.trv.zap.Token.TokenDialog;
import org.cocktail.trv.zap.contrib.StreamCtrl;
import org.cocktail.trv.zap.contrib.StringCtrl;
import org.cocktail.trv.zap.contrib.SystemCtrl;
import org.cocktail.trv.zap.json.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authentification {
    private static final Logger LOGGER = LoggerFactory.getLogger(Authentification.class);
    private static String login;
    private final HashMap<String, String> conf;
    public AuthenticationCAS cas;
    private boolean loginAuthenticated;
    private boolean certAuthenticated;
    private Token tok;

    public Authentification() {
        login = null;
        this.conf = new HashMap();
        this.conf.put("CAS_SERVICE_URL", Constants.getInstance().valueForKey("CAS_SERVICE_URL"));
        this.conf.put("CAS_SERVICE_URI", Constants.getInstance().valueForKey("CAS_SERVICE_URI"));
        this.conf.put("CAS_TGC_NAME", Constants.getInstance().valueForKey("CAS_TGC_NAME"));
        this.initCAS();
    }

    public void initCAS() {
        try {
            this.cas = AuthenticationCAS.getInstance(this.conf);
        }
        catch (IOException e2) {
            JOptionPane.showMessageDialog(null, e2.getMessage(), Messages.getString("error.casError"), 0);
        }
    }

    private boolean keychainAuthentification() {
        LOGGER.info("Keychain authentification");
        try {
            ClassLoader cl = Ressources.class.getClassLoader();
            InputStream is = cl.getResourceAsStream("fr/univlr/cri/DockAppli/Ressources/keychain");
            File key = new File(Constants.getInstance().valueForKey("TEMP_DIR") + System.getProperty("file.separator") + "keychain_lister");
            key.deleteOnExit();
            FileOutputStream os = new FileOutputStream(key);
            StreamCtrl.writeContentToStream(is, os);
            StreamCtrl.forceClose(is);
            StreamCtrl.forceClose(os);
            SystemCtrl.execCommand("chmod 700 " + key.getAbsolutePath());
            Process proc = Runtime.getRuntime().exec(key.getAbsolutePath());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            byte[] buffer = new byte[proc.getInputStream().available()];
            LOGGER.trace("keychain result:" + new String(buffer));
            X509Certificate certif = (X509Certificate)cf.generateCertificate(proc.getInputStream());
            for (int i2 = 0; i2 < 1; ++i2) {
                Certificat certificat = new Certificat(certif);
                if (!certificat.verifyAll()) continue;
                return true;
            }
            LOGGER.info("certificat invalide");
            return false;
        }
        catch (Exception e2) {
            LOGGER.trace(e2.getMessage());
            return false;
        }
    }

    private boolean tokenAuthentification() {
        if (StringCtrl.containsIgnoreCase(SystemCtrl.osName(), "mac")) {
            return this.keychainAuthentification();
        }
        boolean authenticated = false;
        while (!authenticated) {
            TokenDialog dial = new TokenDialog(Dock.getInstance().getWin().getFrame());
            if (dial.getPin() == null) {
                return false;
            }
            if (this.tok == null) {
                this.tok = new Token(dial.getPin());
            }
            this.tok.start();
            try {
                String alias;
                this.tok.join();
                List<String> aliases = this.tok.getCerts();
                if (aliases.size() == 0) {
                    return false;
                }
                if (aliases.size() > 1) {
                    ChooseDialog cdial = new ChooseDialog(aliases);
                    alias = cdial.getChoice();
                } else {
                    alias = aliases.get(0);
                }
                Certificat certif = new Certificat(this.tok.getCert(alias));
                authenticated = certif.verifyAll();
            }
            catch (Exception e2) {
                LOGGER.trace(e2.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean loginAuthentification() {
        try {
            if (this.loginAuthenticated) {
                login = this.cas.getNetId();
                if (login == null) {
                    this.loginAuthenticated = false;
                    return this.loginAuthentification();
                }
            } else {
                do {
                    HashMap ht;
                    if ((ht = this.authentificationCAS(login)) != null) {
                        try {
                            login = this.cas.getNetId((String)ht.get("login"), (String)ht.get("password"));
                            if (login != null) continue;
                            JOptionPane.showMessageDialog(null, Messages.getString("error.invalidCredential"), Messages.getString("error.authError"), 0);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            JOptionPane.showMessageDialog(null, e2.getMessage(), Messages.getString("error.authError"), 0);
                        }
                        continue;
                    }
                    return false;
                } while (login == null || login.equalsIgnoreCase(""));
            }
            return true;
        }
        catch (IOException e3) {
            JOptionPane.showMessageDialog(null, e3.getMessage(), Messages.getString("error"), 0);
            return false;
        }
        catch (ProtocolException e4) {
            JOptionPane.showMessageDialog(null, e4.getMessage(), Messages.getString("error"), 0);
            return false;
        }
    }

    protected boolean authenticate(Application appli) throws IOException {
        if (appli == null) {
            throw new IOException("Application nulle");
        }
        LOGGER.info("Authentification ...none:" + appli.withoutAuth() + " certificat:" + appli.requireCert() + " login:" + appli.requireLogin());
        if (appli.withoutAuth()) {
            LOGGER.info("aucune");
            return true;
        }
        if (appli.requireCert() && !appli.requireLogin()) {
            LOGGER.info("certificat");
            if (StringCtrl.like(SystemCtrl.osName().toLowerCase(), "*mac*")) {
                JOptionPane.showMessageDialog(null, Messages.getString("error.unavailableMacOsAuthMode"), Messages.getString("error.launchError"), 0);
                return false;
            }
            if (this.certAuthenticated) {
                return true;
            }
            this.certAuthenticated = this.tokenAuthentification();
            return this.certAuthenticated;
        }
        if (!appli.requireCert() && appli.requireLogin()) {
            LOGGER.info("login");
            if (this.loginAuthenticated) {
                return true;
            }
            this.loginAuthenticated = this.loginAuthentification();
            return this.loginAuthenticated;
        }
        if (appli.requireCert() && appli.requireLogin()) {
            LOGGER.info("login+certificat");
            if (this.certAuthenticated && this.loginAuthenticated) {
                return true;
            }
            if (!this.certAuthenticated && !this.loginAuthenticated) {
                this.certAuthenticated = this.tokenAuthentification();
                if (!this.certAuthenticated) {
                    return false;
                }
                this.loginAuthenticated = this.loginAuthentification();
                return this.certAuthenticated && this.loginAuthenticated;
            }
            if (!this.certAuthenticated) {
                this.certAuthenticated = this.tokenAuthentification();
                return this.certAuthenticated;
            }
            if (!this.loginAuthenticated) {
                this.loginAuthenticated = this.loginAuthentification();
                return this.loginAuthenticated;
            }
        }
        LOGGER.info("Authentification inconnu pour :" + appli.getName());
        return false;
    }

    public HashMap authentificationCAS(String login) {
        LoginWin logDiag = new LoginWin((Frame)Dock.getInstance().getWin().getFrame(), login);
        if (logDiag.isFilled()) {
            HashMap<String, String> logpasswd = new HashMap<String, String>();
            logpasswd.put("login", logDiag.getLoginName());
            logpasswd.put("password", logDiag.getPassword());
            return logpasswd;
        }
        return null;
    }

    public String getLogin() {
        return login;
    }

    public void tokenExpired(String token, String applicationName, UUID appId) throws IOException, ProtocolException {
        boolean isCookieToDelete;
        LOGGER.info("Token " + token + " expired.");
        boolean bl = isCookieToDelete = this.cas.getCookie().toString().indexOf(token) != 1;
        if (isCookieToDelete) {
            this.cas.logout();
            this.loginAuthenticated = false;
            this.cas.getNetId();
        } else {
            LOGGER.info("Token has changed, no invalidate to do. Let's go to launch");
        }
        Application application = Dock.getInstance().getLister().getAppliByUUID(appId);
        if (application == null) {
            application = Dock.getInstance().getLister().getAppliByName(applicationName);
        }
        if (application == null) {
            LOGGER.info("No Application found for name " + applicationName);
        } else {
            LOGGER.info("Application to relaunch " + application.getName());
            Dock.getInstance().launch(application);
        }
    }
}

