/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldFunction;
import io.github.toolfactory.jvm.function.catalog.GetLoadedClassesRetrieverFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.util.CleanableSupplier;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.burningwave.jvm.NativeExecutor;

public interface GetLoadedClassesRetrieverFunction
extends io.github.toolfactory.jvm.function.catalog.GetLoadedClassesRetrieverFunction {

    public static interface Native
    extends GetLoadedClassesRetrieverFunction {

        public static class ForJava7
        implements Native {
            protected Field classesField;
            protected NativeExecutor nativeExecutor;

            public ForJava7(Map<Object, Object> context) throws Throwable {
                ObjectProvider functionProvider = ObjectProvider.get(context);
                GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
                this.classesField = (Field)getDeclaredFieldFunction.apply(ClassLoader.class, "classes");
                this.nativeExecutor = NativeExecutor.getInstance();
            }

            @Override
            public CleanableSupplier<Collection<Class<?>>> apply(final ClassLoader classLoader) {
                if (classLoader == null) {
                    throw new NullPointerException("Input classLoader parameter can't be null");
                }
                return new CleanableSupplier<Collection<Class<?>>>(){
                    Collection<Class<?>> classes;

                    @Override
                    public Collection<Class<?>> get() {
                        if (this.classes != null) {
                            return this.classes;
                        }
                        this.classes = (Collection)ForJava7.this.nativeExecutor.getFieldValue(classLoader, ForJava7.this.classesField);
                        return this.classes;
                    }

                    @Override
                    public void clear() {
                        this.get();
                        if (this.classes != null) {
                            this.classes.clear();
                        }
                    }
                };
            }

            public static class ForSemeru
            extends GetLoadedClassesRetrieverFunction.ForJava7.ForSemeru {
                protected NativeExecutor nativeExecutor = NativeExecutor.getInstance();

                public ForSemeru(Map<Object, Object> context) throws Throwable {
                    super(context);
                }

                @Override
                protected GetLoadedClassesRetrieverFunction.ForJava7.ForSemeru.ClassNameBasedLockSupplier buildClassNameBasedLockSupplier(final Map<Object, Object> context) {
                    return new GetLoadedClassesRetrieverFunction.ForJava7.ForSemeru.ClassNameBasedLockSupplier(){
                        protected ThrowExceptionFunction throwExceptionFunction;
                        {
                            this.throwExceptionFunction = ObjectProvider.get(context).getOrBuildObject(ThrowExceptionFunction.class, context);
                        }

                        @Override
                        public Hashtable<String, Object> get(ClassLoader classLoader) {
                            return (Hashtable)ForSemeru.this.nativeExecutor.getFieldValue(classLoader, ForSemeru.this.classNameBasedLockField);
                        }

                        @Override
                        protected ClassLoader getClassLoader(Class<?> cls) {
                            return (ClassLoader)ForSemeru.this.nativeExecutor.getFieldValue(cls, ForSemeru.this.classLoaderField);
                        }
                    };
                }
            }
        }
    }
}

