/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.iterable;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.iterable.IterableObjectHelperImpl;

class TaskBasedIterator
extends IterableObjectHelperImpl.Iterator {
    TaskBasedIterator(IterableObjectHelperImpl iterableObjectHelper) {
        super(iterableObjectHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <I, IC, OC> OC iterate(IC items, Predicate<IC> predicateForParallelIteration, OC output, BiConsumer<I, Consumer<Consumer<OC>>> action, Integer priority) {
        if (items == IterableObjectHelperImpl.Iterator.NO_ITEMS) {
            return output;
        }
        Thread currentThread = Thread.currentThread();
        int initialThreadPriority = currentThread.getPriority();
        if (priority == null) {
            priority = initialThreadPriority;
        } else if (initialThreadPriority != priority) {
            currentThread.setPriority(priority);
        }
        try {
            int taskCountThatCanBeCreated;
            if (predicateForParallelIteration == null) {
                predicateForParallelIteration = collectionOrArray -> this.iterableObjectHelper.defaultMinimumCollectionSizeForParallelIterationPredicate.test(collectionOrArray);
            }
            if ((taskCountThatCanBeCreated = this.iterableObjectHelper.getCountOfTasksThatCanBeCreated(items, predicateForParallelIteration)) > 1) {
                int itemsCount;
                Consumer<Consumer<OC>> outputItemsHandler = this.buildOutputCollectionHandler(output);
                AtomicReference terminateIterationNotification = new AtomicReference();
                ConcurrentHashMap.KeySetView tasks = ConcurrentHashMap.newKeySet();
                if (items instanceof List) {
                    List itemList = (List)items;
                    int splittedIteratorSize = itemList.size() / taskCountThatCanBeCreated;
                    int currentIndex = 0;
                    int splittedIteratorIndex = 0;
                    while (currentIndex < taskCountThatCanBeCreated && terminateIterationNotification.get() == null) {
                        ListIterator itemIterator = itemList.listIterator(splittedIteratorIndex);
                        itemsCount = currentIndex != taskCountThatCanBeCreated - 1 ? splittedIteratorSize : itemList.size() - splittedIteratorSize * currentIndex;
                        ThrowingConsumer iterator = task -> {
                            try {
                                for (int remainedItems = itemsCount; terminateIterationNotification.get() == null && remainedItems > 0; --remainedItems) {
                                    action.accept(itemIterator.next(), outputItemsHandler);
                                }
                            }
                            catch (IterableObjectHelper.TerminateIteration exc) {
                                this.checkAndNotifyTerminationOfIteration(terminateIterationNotification, exc);
                            }
                            catch (Throwable exc) {
                                terminateIterationNotification.set(IterableObjectHelper.TerminateIteration.NOTIFICATION);
                                throw exc;
                            }
                            finally {
                                this.removeTask(tasks, (QueuedTaskExecutor.Task)task);
                            }
                        };
                        if (currentIndex < taskCountThatCanBeCreated - 1) {
                            tasks.add((QueuedTaskExecutor.Task)StaticComponentContainer.BackgroundExecutor.createTask(iterator, (int)priority).submit());
                        } else {
                            this.consume(iterator);
                        }
                        ++currentIndex;
                        splittedIteratorIndex += splittedIteratorSize;
                    }
                } else if (items instanceof Collection) {
                    Iterator itemIterator = ((Collection)items).iterator();
                    ThrowingConsumer iterator = task -> {
                        Object item = null;
                        try {
                            while (terminateIterationNotification.get() == null) {
                                try {
                                    Iterator iterator = itemIterator;
                                    synchronized (iterator) {
                                        item = itemIterator.next();
                                    }
                                }
                                catch (NoSuchElementException exc) {
                                    terminateIterationNotification.set(IterableObjectHelper.TerminateIteration.NOTIFICATION);
                                    break;
                                }
                                action.accept(item, outputItemsHandler);
                            }
                        }
                        catch (IterableObjectHelper.TerminateIteration exc) {
                            this.checkAndNotifyTerminationOfIteration(terminateIterationNotification, exc);
                        }
                        catch (Throwable exc) {
                            terminateIterationNotification.set(IterableObjectHelper.TerminateIteration.NOTIFICATION);
                            throw exc;
                        }
                        finally {
                            this.removeTask(tasks, (QueuedTaskExecutor.Task)task);
                        }
                    };
                    for (int taskIndex = 0; taskIndex < taskCountThatCanBeCreated && terminateIterationNotification.get() == null; ++taskIndex) {
                        if (taskIndex < taskCountThatCanBeCreated - 1) {
                            tasks.add((QueuedTaskExecutor.Task)StaticComponentContainer.BackgroundExecutor.createTask(iterator, (int)priority).submit());
                            continue;
                        }
                        this.consume(iterator);
                    }
                } else {
                    ThrowingConsumer iterator;
                    int arrayLength = Array.getLength(items);
                    int splittedIteratorSize = arrayLength / taskCountThatCanBeCreated;
                    Class<?> componentType = items.getClass().getComponentType();
                    if (componentType.isPrimitive()) {
                        Function<Integer, ?> itemRetriever = StaticComponentContainer.Classes.buildArrayValueRetriever(items);
                        int taskIndex = 0;
                        int currentSplittedIteratorIndex = 0;
                        while (taskIndex < taskCountThatCanBeCreated && terminateIterationNotification.get() == null) {
                            int itemsCount2 = taskIndex != taskCountThatCanBeCreated - 1 ? splittedIteratorSize : arrayLength - splittedIteratorSize * taskIndex;
                            int splittedIteratorIndex = currentSplittedIteratorIndex;
                            iterator = task -> {
                                try {
                                    int itemIndex = splittedIteratorIndex;
                                    for (int remainedItems = itemsCount2; terminateIterationNotification.get() == null && remainedItems > 0; --remainedItems) {
                                        action.accept(itemRetriever.apply(itemIndex++), outputItemsHandler);
                                    }
                                }
                                catch (IterableObjectHelper.TerminateIteration exc) {
                                    this.checkAndNotifyTerminationOfIteration(terminateIterationNotification, exc);
                                }
                                catch (Throwable exc) {
                                    terminateIterationNotification.set(IterableObjectHelper.TerminateIteration.NOTIFICATION);
                                    throw exc;
                                }
                                finally {
                                    this.removeTask(tasks, (QueuedTaskExecutor.Task)task);
                                }
                            };
                            if (taskIndex < taskCountThatCanBeCreated - 1) {
                                tasks.add((QueuedTaskExecutor.Task)StaticComponentContainer.BackgroundExecutor.createTask(iterator, (int)priority).submit());
                            } else {
                                this.consume(iterator);
                            }
                            ++taskIndex;
                            currentSplittedIteratorIndex += splittedIteratorSize;
                        }
                    } else {
                        int taskIndex = 0;
                        int currentSplittedIteratorIndex = 0;
                        while (taskIndex < taskCountThatCanBeCreated && terminateIterationNotification.get() == null) {
                            itemsCount = taskIndex != taskCountThatCanBeCreated - 1 ? splittedIteratorSize : arrayLength - splittedIteratorSize * taskIndex;
                            int splittedIteratorIndex = currentSplittedIteratorIndex;
                            Object[] itemArray = (Object[])items;
                            iterator = task -> {
                                try {
                                    int itemIndex = splittedIteratorIndex;
                                    for (int remainedItems = itemsCount; terminateIterationNotification.get() == null && remainedItems > 0; --remainedItems) {
                                        action.accept(itemArray[itemIndex++], outputItemsHandler);
                                    }
                                }
                                catch (IterableObjectHelper.TerminateIteration exc) {
                                    this.checkAndNotifyTerminationOfIteration(terminateIterationNotification, exc);
                                }
                                catch (Throwable exc) {
                                    terminateIterationNotification.set(IterableObjectHelper.TerminateIteration.NOTIFICATION);
                                    throw exc;
                                }
                                finally {
                                    this.removeTask(tasks, (QueuedTaskExecutor.Task)task);
                                }
                            };
                            if (taskIndex < taskCountThatCanBeCreated - 1) {
                                tasks.add((QueuedTaskExecutor.Task)StaticComponentContainer.BackgroundExecutor.createTask(iterator, (int)priority).submit());
                            } else {
                                this.consume(iterator);
                            }
                            ++taskIndex;
                            currentSplittedIteratorIndex += splittedIteratorSize;
                        }
                    }
                }
                for (QueuedTaskExecutor.Task task2 : tasks) {
                    task2.join();
                }
                Iterator<Object> arrayLength = output;
                return (OC)arrayLength;
            }
            Consumer<Consumer> outputItemsHandler = output != null ? outputCollectionConsumer -> outputCollectionConsumer.accept(output) : null;
            try {
                if (items instanceof Collection) {
                    for (Object item : (Collection)items) {
                        action.accept(item, outputItemsHandler);
                    }
                } else if (!items.getClass().getComponentType().isPrimitive()) {
                    Object[] itemArray;
                    for (Object item : itemArray = (Object[])items) {
                        action.accept(item, outputItemsHandler);
                    }
                } else {
                    Function<Integer, ?> itemRetriever = StaticComponentContainer.Classes.buildArrayValueRetriever(items);
                    int arrayLength = Array.getLength(items);
                    for (int i2 = 0; i2 < arrayLength; ++i2) {
                        action.accept(itemRetriever.apply(i2), outputItemsHandler);
                    }
                }
            }
            catch (IterableObjectHelper.TerminateIteration terminateIteration) {
                // empty catch block
            }
        }
        finally {
            if (initialThreadPriority != priority) {
                currentThread.setPriority(initialThreadPriority);
            }
        }
        return output;
    }

    void consume(ThrowingConsumer<QueuedTaskExecutor.Task, ? extends Throwable> iterator) {
        try {
            iterator.accept(null);
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
        }
    }

    void removeTask(Collection<QueuedTaskExecutor.Task> tasks, QueuedTaskExecutor.Task task) {
        if (task != null) {
            tasks.remove(task);
        }
    }
}

