/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassSourceGenerator;
import org.burningwave.core.classes.FunctionSourceGenerator;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;
import org.burningwave.core.classes.VariableSourceGenerator;
import org.burningwave.core.function.PentaConsumer;
import org.burningwave.core.function.TriConsumer;

public class PojoSourceGenerator {
    public static int ALL_OPTIONS_DISABLED = 0;
    public static int BUILDING_METHODS_CREATION_ENABLED = 1;
    public static int USE_OF_FULLY_QUALIFIED_CLASS_NAMES_ENABLED = 2;
    private TriConsumer<PojoSourceGenerator, ClassSourceGenerator, Map<String, VariableSourceGenerator>> fieldsBuilder;
    private PentaConsumer<PojoSourceGenerator, ClassSourceGenerator, FunctionSourceGenerator, Method, Integer> setterMethodsBodyBuilder;
    private PentaConsumer<PojoSourceGenerator, ClassSourceGenerator, FunctionSourceGenerator, Method, Integer> getterMethodsBodyBuilder;
    private PentaConsumer<PojoSourceGenerator, ClassSourceGenerator, Class<?>, Collection<Class<?>>, Integer> extraElementsBuilder;

    private PojoSourceGenerator(TriConsumer<PojoSourceGenerator, ClassSourceGenerator, Map<String, VariableSourceGenerator>> fieldsBuilder, PentaConsumer<PojoSourceGenerator, ClassSourceGenerator, FunctionSourceGenerator, Method, Integer> setterMethodsBodyBuilder, PentaConsumer<PojoSourceGenerator, ClassSourceGenerator, FunctionSourceGenerator, Method, Integer> getterMethodsBodyBuilder, PentaConsumer<PojoSourceGenerator, ClassSourceGenerator, Class<?>, Collection<Class<?>>, Integer> extraElementsBuilder) {
        this.fieldsBuilder = fieldsBuilder;
        this.setterMethodsBodyBuilder = setterMethodsBodyBuilder;
        this.getterMethodsBodyBuilder = getterMethodsBodyBuilder;
        this.extraElementsBuilder = extraElementsBuilder;
    }

    public static PojoSourceGenerator create() {
        return new PojoSourceGenerator((pSG, cls, fieldsMap) -> fieldsMap.entrySet().forEach(entry -> cls.addField(((VariableSourceGenerator)entry.getValue()).addModifier(2))), (pSG, cls, methodSG, method, options) -> {
            String fieldName = StaticComponentContainer.Strings.lowerCaseFirstCharacter(method.getName().replaceFirst("set", ""));
            methodSG.addBodyCodeLine("this." + fieldName + " = " + fieldName + ";");
        }, (pSG, cls, methodSG, method, options) -> {
            String prefix = method.getName().startsWith("get") ? "get" : "is";
            String fieldName = StaticComponentContainer.Strings.lowerCaseFirstCharacter(method.getName().replaceFirst(prefix, ""));
            methodSG.addBodyCodeLine("return this." + fieldName + ";");
        }, null);
    }

    public PojoSourceGenerator setFieldsBuilder(TriConsumer<PojoSourceGenerator, ClassSourceGenerator, Map<String, VariableSourceGenerator>> fieldsBuilder) {
        this.fieldsBuilder = fieldsBuilder;
        return this;
    }

    public PojoSourceGenerator setSetterMethodsBodyBuilder(PentaConsumer<PojoSourceGenerator, ClassSourceGenerator, FunctionSourceGenerator, Method, Integer> setterMethodsBodyBuilder) {
        this.setterMethodsBodyBuilder = setterMethodsBodyBuilder;
        return this;
    }

    public PojoSourceGenerator setGetterMethodsBodyBuilder(PentaConsumer<PojoSourceGenerator, ClassSourceGenerator, FunctionSourceGenerator, Method, Integer> getterMethodsBodyBuilder) {
        this.getterMethodsBodyBuilder = getterMethodsBodyBuilder;
        return this;
    }

    public PojoSourceGenerator setExtraElementsBuilder(PentaConsumer<PojoSourceGenerator, ClassSourceGenerator, Class<?>, Collection<Class<?>>, Integer> extraElementsBuilder) {
        this.extraElementsBuilder = extraElementsBuilder;
        return this;
    }

    public ClassSourceGenerator generate(String className, Class<?> ... superClasses) {
        return this.generate(className, ALL_OPTIONS_DISABLED, superClasses);
    }

    /*
     * WARNING - void declaration
     */
    public ClassSourceGenerator generate(String className, int options, Class<?> ... superClasses) {
        void var11_14;
        if (className.contains("$")) {
            StaticComponentContainer.Driver.throwException("{} Pojo could not be a inner class", className);
        }
        String packageName = StaticComponentContainer.Classes.retrievePackageName(className);
        String classSimpleName = StaticComponentContainer.Classes.retrieveSimpleName(className);
        ClassSourceGenerator cls = ClassSourceGenerator.create(TypeDeclarationSourceGenerator.create(classSimpleName)).addModifier(1);
        Class<?> superClass = null;
        LinkedHashSet interfaces = new LinkedHashSet();
        Class<?>[] classArray = superClasses;
        int n2 = classArray.length;
        boolean bl = false;
        while (var11_14 < n2) {
            Class<?> iteratedSuperClass = classArray[var11_14];
            if (iteratedSuperClass.isInterface()) {
                cls.addConcretizedType(this.createTypeDeclaration((options & USE_OF_FULLY_QUALIFIED_CLASS_NAMES_ENABLED) != 0, iteratedSuperClass));
                interfaces.add(iteratedSuperClass);
            } else if (superClass == null) {
                cls.expands(this.createTypeDeclaration(this.isUseFullyQualifiedClassNamesEnabled(options), iteratedSuperClass));
                superClass = iteratedSuperClass;
            } else {
                StaticComponentContainer.Driver.throwException("{} Pojo could not extends more than one class", className);
            }
            ++var11_14;
        }
        if (superClass != null) {
            String superClassPackage = Optional.ofNullable(superClass.getPackage()).map(pckg -> pckg.getName()).orElseGet(() -> "");
            Predicate<Executable> modifierTester = StaticComponentContainer.Strings.areEquals(packageName, superClassPackage) ? executable -> !Modifier.isPrivate(executable.getModifiers()) : executable -> Modifier.isPublic(executable.getModifiers()) || Modifier.isProtected(executable.getModifiers());
            for (Constructor<?> constructor2 : StaticComponentContainer.Classes.getDeclaredConstructors(superClass, constructor -> modifierTester.test((Executable)constructor))) {
                Integer modifiers = constructor2.getModifiers();
                if (this.isBuildingMethodsCreationEnabled(options) && Modifier.isPublic(modifiers)) {
                    modifiers = modifiers ^ 1;
                }
                cls.addConstructor(this.create(classSimpleName, constructor2, modifiers, (funct, params) -> funct.addBodyCodeLine("super(" + String.join((CharSequence)", ", params) + ");"), this.isUseFullyQualifiedClassNamesEnabled(options)));
                if (!this.isBuildingMethodsCreationEnabled(options)) continue;
                cls.addMethod(this.create("create", constructor2, modifiers, (funct, params) -> funct.addBodyCodeLine("return new " + classSimpleName + "(" + String.join((CharSequence)", ", params) + ");"), this.isUseFullyQualifiedClassNamesEnabled(options)).addModifier(9).setReturnType(classSimpleName));
            }
        }
        HashMap<String, VariableSourceGenerator> fieldsMap = new HashMap<String, VariableSourceGenerator>();
        for (Class clazz : interfaces) {
            for (Method method2 : StaticComponentContainer.Classes.getDeclaredMethods(clazz, method -> method.getName().startsWith("set") || method.getName().startsWith("get") || method.getName().startsWith("is"))) {
                Integer modifiers = method2.getModifiers();
                if (Modifier.isAbstract(modifiers)) {
                    modifiers = modifiers ^ 0x400;
                }
                FunctionSourceGenerator methodSG = FunctionSourceGenerator.create(method2.getName()).addModifier(modifiers);
                methodSG.setReturnType(this.createTypeDeclaration(this.isUseFullyQualifiedClassNamesEnabled(options), method2.getReturnType()));
                if (method2.getName().startsWith("set")) {
                    String fieldName = StaticComponentContainer.Strings.lowerCaseFirstCharacter(method2.getName().replaceFirst("set", ""));
                    Class<?> paramType = method2.getParameters()[0].getType();
                    fieldsMap.put(fieldName, VariableSourceGenerator.create(this.createTypeDeclaration(this.isUseFullyQualifiedClassNamesEnabled(options), paramType), fieldName));
                    methodSG.addParameter(VariableSourceGenerator.create(this.createTypeDeclaration(this.isUseFullyQualifiedClassNamesEnabled(options), paramType), fieldName));
                    if (this.setterMethodsBodyBuilder != null) {
                        this.setterMethodsBodyBuilder.accept(this, cls, methodSG, method2, options);
                    }
                } else if (method2.getName().startsWith("get") || method2.getName().startsWith("is")) {
                    String prefix = method2.getName().startsWith("get") ? "get" : "is";
                    String fieldName = StaticComponentContainer.Strings.lowerCaseFirstCharacter(method2.getName().replaceFirst(prefix, ""));
                    fieldsMap.put(fieldName, VariableSourceGenerator.create(this.createTypeDeclaration(this.isUseFullyQualifiedClassNamesEnabled(options), method2.getReturnType()), fieldName));
                    if (this.getterMethodsBodyBuilder != null) {
                        this.getterMethodsBodyBuilder.accept(this, cls, methodSG, method2, options);
                    }
                }
                cls.addMethod(methodSG);
            }
            if (this.fieldsBuilder == null) continue;
            this.fieldsBuilder.accept(this, cls, fieldsMap);
        }
        if (this.extraElementsBuilder != null) {
            this.extraElementsBuilder.accept(this, cls, superClass, interfaces, options);
        }
        return cls;
    }

    public boolean isUseFullyQualifiedClassNamesEnabled(int options) {
        return (options & USE_OF_FULLY_QUALIFIED_CLASS_NAMES_ENABLED) != 0;
    }

    public boolean isBuildingMethodsCreationEnabled(int options) {
        return (options & BUILDING_METHODS_CREATION_ENABLED) != 0;
    }

    TypeDeclarationSourceGenerator createTypeDeclaration(boolean useFullyQualifiedNames, Class<?> cls) {
        if (useFullyQualifiedNames) {
            return TypeDeclarationSourceGenerator.create(cls.getName().replace("$", "."));
        }
        return TypeDeclarationSourceGenerator.create(cls);
    }

    private FunctionSourceGenerator create(String functionName, Executable executable, Integer modifiers, BiConsumer<FunctionSourceGenerator, Collection<String>> bodyBuilder, boolean useFullyQualifiedNames) {
        FunctionSourceGenerator function = FunctionSourceGenerator.create(functionName);
        ArrayList<String> params = new ArrayList<String>();
        for (Parameter paramType : executable.getParameters()) {
            function.addParameter(VariableSourceGenerator.create(this.createTypeDeclaration(useFullyQualifiedNames, paramType.getType()), paramType.getName()));
            params.add(paramType.getName());
        }
        bodyBuilder.accept(function, params);
        return function;
    }
}

