/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import org.burningwave.core.Executable;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.BodySourceGenerator;
import org.burningwave.core.classes.ClassSourceGenerator;
import org.burningwave.core.classes.FunctionSourceGenerator;
import org.burningwave.core.classes.GenericSourceGenerator;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;
import org.burningwave.core.classes.VariableSourceGenerator;
import org.burningwave.core.function.MultiParamsConsumer;
import org.burningwave.core.function.MultiParamsFunction;
import org.burningwave.core.function.MultiParamsPredicate;

public class FunctionalInterfaceSourceGenerator {
    public static FunctionalInterfaceSourceGenerator create() {
        return new FunctionalInterfaceSourceGenerator();
    }

    public ClassSourceGenerator generateExecutor(String className, BodySourceGenerator body) {
        if (className.contains("$")) {
            StaticComponentContainer.Driver.throwException("{} code executor could not be a inner class", className);
        }
        String classSimpleName = StaticComponentContainer.Classes.retrieveSimpleName(className);
        FunctionSourceGenerator executeMethod = FunctionSourceGenerator.create("execute").setReturnType(Object.class).addModifier(1).addParameter(VariableSourceGenerator.create(TypeDeclarationSourceGenerator.create("Object... "), "parameter")).addOuterCodeLine("@Override").addBodyElement(body);
        ClassSourceGenerator cls = ClassSourceGenerator.create(TypeDeclarationSourceGenerator.create(classSimpleName)).addModifier(1).addConcretizedType(Executable.class).addMethod(executeMethod);
        return cls;
    }

    public ClassSourceGenerator generateConsumer(String className, int parametersLength) {
        String classSimpleName = StaticComponentContainer.Classes.retrieveSimpleName(className);
        if (className.contains("$")) {
            StaticComponentContainer.Driver.throwException("{} consumer could not be a inner class", className);
        }
        TypeDeclarationSourceGenerator typeDeclaration = TypeDeclarationSourceGenerator.create(classSimpleName);
        FunctionSourceGenerator acceptMethod = FunctionSourceGenerator.create("accept").setReturnType(Void.TYPE).addModifier(1025);
        FunctionSourceGenerator varArgsAcceptMethod = FunctionSourceGenerator.create("accept").setReturnType(Void.TYPE).addModifier(1).setDefault().addParameter(VariableSourceGenerator.create(TypeDeclarationSourceGenerator.create("Object..."), "params")).addOuterCodeLine("@Override");
        varArgsAcceptMethod.addBodyCodeLine("accept(");
        BodySourceGenerator applyMethodCodeOne = BodySourceGenerator.createSimple().setBodyElementSeparator(", ");
        for (int i2 = 0; i2 < parametersLength; ++i2) {
            typeDeclaration.addGeneric(GenericSourceGenerator.create("P" + i2));
            acceptMethod.addParameter(VariableSourceGenerator.create(TypeDeclarationSourceGenerator.create("P" + i2), "p" + i2));
            applyMethodCodeOne.addCode("(P" + i2 + ")params[" + i2 + "]");
        }
        varArgsAcceptMethod.addBodyElement(applyMethodCodeOne);
        varArgsAcceptMethod.addBodyCode(");");
        ClassSourceGenerator cls = ClassSourceGenerator.createInterface(typeDeclaration).addModifier(1).expands(TypeDeclarationSourceGenerator.create(MultiParamsConsumer.class)).addMethod(acceptMethod).addMethod(varArgsAcceptMethod).addOuterCodeLine("@FunctionalInterface");
        return cls;
    }

    public ClassSourceGenerator generatePredicate(String className, int parametersLength) {
        String classSimpleName = StaticComponentContainer.Classes.retrieveSimpleName(className);
        if (className.contains("$")) {
            StaticComponentContainer.Driver.throwException("{} Predicate could not be a inner class", className);
        }
        TypeDeclarationSourceGenerator typeDeclaration = TypeDeclarationSourceGenerator.create(classSimpleName);
        FunctionSourceGenerator testMethod = FunctionSourceGenerator.create("test").setReturnType(Boolean.TYPE).addModifier(1025);
        FunctionSourceGenerator varArgsTestMethod = FunctionSourceGenerator.create("test").setReturnType(Boolean.TYPE).addModifier(1).setDefault().addParameter(VariableSourceGenerator.create(TypeDeclarationSourceGenerator.create("Object..."), "params")).addOuterCodeLine("@Override");
        varArgsTestMethod.addBodyCodeLine("return test(");
        BodySourceGenerator applyMethodCodeOne = BodySourceGenerator.createSimple().setBodyElementSeparator(", ");
        for (int i2 = 0; i2 < parametersLength; ++i2) {
            typeDeclaration.addGeneric(GenericSourceGenerator.create("P" + i2));
            testMethod.addParameter(VariableSourceGenerator.create(TypeDeclarationSourceGenerator.create("P" + i2), "p" + i2));
            applyMethodCodeOne.addCode("(P" + i2 + ")params[" + i2 + "]");
        }
        varArgsTestMethod.addBodyElement(applyMethodCodeOne);
        varArgsTestMethod.addBodyCode(");");
        ClassSourceGenerator cls = ClassSourceGenerator.createInterface(typeDeclaration).addModifier(1).expands(TypeDeclarationSourceGenerator.create(MultiParamsPredicate.class)).addMethod(testMethod).addMethod(varArgsTestMethod).addOuterCodeLine("@FunctionalInterface");
        return cls;
    }

    public ClassSourceGenerator generateFunction(String className, int parametersLength) {
        String classSimpleName = StaticComponentContainer.Classes.retrieveSimpleName(className);
        if (className.contains("$")) {
            StaticComponentContainer.Driver.throwException("{} function could not be a inner class", className);
        }
        TypeDeclarationSourceGenerator typeDeclaration = TypeDeclarationSourceGenerator.create(classSimpleName);
        GenericSourceGenerator returnType = GenericSourceGenerator.create("R");
        FunctionSourceGenerator applyMethod = FunctionSourceGenerator.create("apply").setReturnType(returnType).addModifier(1025);
        FunctionSourceGenerator varArgsApplyMethod = FunctionSourceGenerator.create("apply").setReturnType(returnType).addModifier(1).setDefault().addParameter(VariableSourceGenerator.create(TypeDeclarationSourceGenerator.create("Object..."), "params")).addOuterCodeLine("@Override");
        varArgsApplyMethod.addBodyCodeLine("return apply(");
        BodySourceGenerator applyMethodCodeOne = BodySourceGenerator.createSimple().setBodyElementSeparator(", ");
        for (int i2 = 0; i2 < parametersLength; ++i2) {
            typeDeclaration.addGeneric(GenericSourceGenerator.create("P" + i2));
            applyMethod.addParameter(VariableSourceGenerator.create(TypeDeclarationSourceGenerator.create("P" + i2), "p" + i2));
            applyMethodCodeOne.addCode("(P" + i2 + ")params[" + i2 + "]");
        }
        varArgsApplyMethod.addBodyElement(applyMethodCodeOne);
        varArgsApplyMethod.addBodyCode(");");
        typeDeclaration.addGeneric(returnType);
        ClassSourceGenerator cls = ClassSourceGenerator.createInterface(typeDeclaration).addModifier(1).expands(TypeDeclarationSourceGenerator.create(MultiParamsFunction.class).addGeneric(returnType)).addMethod(applyMethod).addMethod(varArgsApplyMethod).addOuterCodeLine("@FunctionalInterface");
        return cls;
    }
}

