/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

public class DnsUtils {
    private DnsUtils() {
    }

    private static boolean isUpper(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }

    public static String normalize(String s2) {
        int remaining;
        if (s2 == null) {
            return null;
        }
        int pos = 0;
        for (remaining = s2.length(); remaining > 0 && !DnsUtils.isUpper(s2.charAt(pos)); --remaining) {
            ++pos;
        }
        if (remaining > 0) {
            StringBuilder buf = new StringBuilder(s2.length());
            buf.append(s2, 0, pos);
            while (remaining > 0) {
                char c2 = s2.charAt(pos);
                if (DnsUtils.isUpper(c2)) {
                    buf.append((char)(c2 + 32));
                } else {
                    buf.append(c2);
                }
                ++pos;
                --remaining;
            }
            return buf.toString();
        }
        return s2;
    }
}

