/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.util;

import io.github.toolfactory.jvm.util.BufferHandler;
import io.github.toolfactory.jvm.util.Classes;
import java.nio.ByteBuffer;

public class JavaClass {
    protected int modifiers;
    protected String name;
    protected String simpleName;
    protected String packageName;
    protected String superClassName;
    protected String[] interfaceNames;

    protected JavaClass(ByteBuffer byteCode) {
        this(Classes.File.Reader.retrieveInfo(BufferHandler.shareContent(byteCode)));
    }

    protected JavaClass(byte[] byteCode) {
        this(Classes.File.Reader.retrieveInfo(byteCode));
    }

    protected JavaClass(Classes.RawInfo rawInfo) {
        this.modifiers = rawInfo.modifiers;
        String rawName = rawInfo.getName();
        String[] classNames = this.retrieveNames(rawName);
        this.packageName = classNames[0];
        this.simpleName = classNames[1];
        this.name = classNames[2];
        this.superClassName = this.retrieveName(rawInfo.getSuperClassName());
        String[] interfaceRawNames = rawInfo.getInterfaceNames();
        this.interfaceNames = new String[interfaceRawNames.length];
        for (int i2 = 0; i2 < interfaceRawNames.length; ++i2) {
            this.interfaceNames[i2] = this.retrieveName(interfaceRawNames[i2]);
        }
    }

    public static JavaClass create(ByteBuffer byteCode) {
        return new JavaClass(byteCode);
    }

    public static JavaClass create(byte[] byteCode) {
        return new JavaClass(byteCode);
    }

    private String retrieveName(String rawName) {
        try {
            return rawName.replace("/", ".");
        }
        catch (NullPointerException exc) {
            return null;
        }
    }

    private String[] retrieveNames(String rawName) {
        String rawPackageName;
        String[] names = new String[3];
        String string = rawPackageName = rawName.contains("/") ? rawName.substring(0, rawName.lastIndexOf("/")) : null;
        if (rawPackageName != null) {
            names[0] = rawPackageName.replace("/", ".");
        }
        names[1] = rawName.contains("/") ? rawName.substring(rawName.lastIndexOf("/") + 1) : rawName;
        names[2] = (names[0] != null ? names[0] + "." : "") + names[1];
        return names;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotation() {
        return (this.modifiers & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }
}

