/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ENUMERATED;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.Util;
import iaik.x509.ocsp.Response;
import iaik.x509.ocsp.ResponseBytes;
import iaik.x509.ocsp.UnknownResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OCSPResponse {
    ResponseBytes b;
    int a;
    public static final int noMoreData = 7;
    public static final int unauthorized = 6;
    public static final int sigRequired = 5;
    public static final int tryLater = 3;
    public static final int internalError = 2;
    public static final int malformedRequest = 1;
    public static final int successful = 0;

    public void writeTo(OutputStream outputStream) throws IOException {
        DerCoder.encodeTo(this.toASN1Object(), outputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("responseStatus: " + this.getResponseStatusName());
        if (this.b != null) {
            stringBuffer.append("\n" + this.b.toString());
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new ENUMERATED(this.a));
        if (this.b != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, this.b.toASN1Object()));
        }
        return sEQUENCE;
    }

    public void setResponseBytes(ResponseBytes responseBytes) {
        this.a = 0;
        this.b = responseBytes;
    }

    public void setResponse(Response response) {
        this.a = 0;
        this.b = new ResponseBytes(response);
    }

    public ObjectID getResponseType() {
        if (this.b == null) {
            return null;
        }
        return this.b.getResponseType();
    }

    public String getResponseStatusName() {
        String string;
        switch (this.a) {
            case 0: {
                string = "successful";
                break;
            }
            case 1: {
                string = "malformedRequest";
                break;
            }
            case 2: {
                string = "internalError";
                break;
            }
            case 3: {
                string = "tryLater";
                break;
            }
            case 5: {
                string = "sigRequired";
                break;
            }
            case 6: {
                string = "unauthorized";
                break;
            }
            case 7: {
                string = "noMoreData";
                break;
            }
            default: {
                string = "undefined response status: " + this.a;
            }
        }
        return string;
    }

    public int getResponseStatus() {
        return this.a;
    }

    public ResponseBytes getResponseBytes() {
        return this.b;
    }

    public Response getResponse() {
        if (this.b == null) {
            return null;
        }
        return this.b.getResponse();
    }

    public byte[] getEncoded() {
        return DerCoder.encode(this.toASN1Object());
    }

    public void decode(InputStream inputStream) throws UnknownResponseException, IOException {
        try {
            this.decode(DerCoder.decode(inputStream));
            return;
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) throws UnknownResponseException, CodingException {
        this.a = (Integer)aSN1Object.getComponentAt(0).getValue();
        if (this.a < 0 || this.a == 4 || this.a > 7) {
            throw new CodingException("Cannot create OCSPResponse: Illegal response status: " + this.a);
        }
        if (aSN1Object.countComponents() == 2) {
            this.b = new ResponseBytes((ASN1Object)aSN1Object.getComponentAt(1).getValue());
        }
    }

    public OCSPResponse(byte[] byArray) throws UnknownResponseException, CodingException {
        this.decode(DerCoder.decode(byArray));
    }

    public OCSPResponse(InputStream inputStream) throws UnknownResponseException, IOException {
        this.decode(inputStream);
    }

    public OCSPResponse(ResponseBytes responseBytes) {
        this.a = 0;
        this.b = responseBytes;
    }

    public OCSPResponse(Response response) {
        this.a = 0;
        this.b = new ResponseBytes(response);
    }

    public OCSPResponse(ASN1Object aSN1Object) throws UnknownResponseException, CodingException {
        this.decode(aSN1Object);
    }

    public OCSPResponse(int n2) throws IllegalArgumentException {
        if (n2 < 0 || n2 == 4 || n2 > 7) {
            throw new IllegalArgumentException("Cannot create OCSPResponse: Illegal response status: " + n2);
        }
        this.a = n2;
    }

    static {
        Util.toString(null, -1, 1);
    }
}

