/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.ENUMERATED;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class ObjectDigestInfo {
    byte[] c;
    AlgorithmID d;
    ObjectID a;
    int b;
    public static final int OTHER_OBJECT_TYPES = 2;
    public static final int PUBLIC_KEY_CERT = 1;
    public static final int PUBLIC_KEY = 0;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digestObjectType: " + this.getObjectTypeName() + "\n");
        stringBuffer.append("digestAlgorithm: " + this.d + "\n");
        stringBuffer.append("objectDigest: " + Util.toString(this.c));
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new ENUMERATED(this.b));
        if (this.a != null) {
            sEQUENCE.addComponent(this.a);
        }
        sEQUENCE.addComponent(this.d.toASN1Object());
        sEQUENCE.addComponent(new BIT_STRING(this.c));
        return sEQUENCE;
    }

    public boolean identifiesKey(PublicKey publicKey) throws NoSuchAlgorithmException {
        if (this.b != 0) {
            return false;
        }
        ObjectDigestInfo.calculateDigest(publicKey.getEncoded(), this.d);
        return CryptoUtils.equalsBlock(this.c, this.c);
    }

    public boolean identifiesCert(X509Certificate x509Certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        if (this.b != 1) {
            return false;
        }
        byte[] byArray = ObjectDigestInfo.calculateDigest(x509Certificate.getEncoded(), this.d);
        return CryptoUtils.equalsBlock(this.c, byArray);
    }

    public int hashCode() {
        return Util.calculateHashCode(this.c);
    }

    public ObjectID getOtherObjectTypeID() {
        return this.a;
    }

    public String getObjectTypeName() {
        String string = "publicKey";
        switch (this.b) {
            case 1: {
                string = "publicKeyCert";
                break;
            }
            case 2: {
                string = "otherObjectTypes" + (this.a != null ? " (" + this.a.getName() + ")" : "");
                break;
            }
            default: {
                string = "unknown";
            }
            case 0: 
        }
        return string;
    }

    public int getObjectType() {
        return this.b;
    }

    public byte[] getObjectDigest() {
        return this.c;
    }

    public AlgorithmID getDigestAlgorithm() {
        return this.d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectDigestInfo)) {
            return false;
        }
        ObjectDigestInfo objectDigestInfo = (ObjectDigestInfo)object;
        if (this.b != objectDigestInfo.b) {
            return false;
        }
        if (!this.d.equals(objectDigestInfo.d)) {
            return false;
        }
        if (!CryptoUtils.equalsBlock(this.c, objectDigestInfo.c)) {
            return false;
        }
        if (this.a != null && objectDigestInfo.a != null) {
            return this.a.equals(objectDigestInfo.a);
        }
        return this.a == null && objectDigestInfo.a == null;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        this.b = (Integer)aSN1Object.getComponentAt(0).getValue();
        if (this.b < 0 || this.b > 2) {
            throw new CodingException("cannot decode ObjectDigestInfo. Invalid object type: " + this.b);
        }
        int n2 = 1;
        if (aSN1Object.countComponents() == 4) {
            this.a = (ObjectID)aSN1Object.getComponentAt(n2);
            ++n2;
        }
        if (this.b == 2 && this.a == null) {
            throw new CodingException("Cannot decode ObjectDigestInfo. Missing otherObjectTypeID for otherObjectTypes!");
        }
        this.d = new AlgorithmID(aSN1Object.getComponentAt(n2));
        this.c = (byte[])aSN1Object.getComponentAt(n2 + 1).getValue();
    }

    public static byte[] calculateDigest(byte[] byArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
        return messageDigest.digest(byArray);
    }

    public ObjectDigestInfo(X509Certificate x509Certificate, AlgorithmID algorithmID) throws CertificateEncodingException, NoSuchAlgorithmException {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing publicKey!");
        }
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing digestAlgorithm!");
        }
        this.b = 1;
        this.d = algorithmID;
        this.c = ObjectDigestInfo.calculateDigest(x509Certificate.getEncoded(), algorithmID);
    }

    public ObjectDigestInfo(PublicKey publicKey, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        if (publicKey == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing publicKey!");
        }
        String string = publicKey.getFormat().toLowerCase();
        if (!string.equals("x.509") && !string.equals("x509")) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo from public key: Invalid encoding format: " + string);
        }
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing digestAlgorithm!");
        }
        this.b = 0;
        this.d = algorithmID;
        this.c = ObjectDigestInfo.calculateDigest(publicKey.getEncoded(), algorithmID);
    }

    public ObjectDigestInfo(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public ObjectDigestInfo(int n2, AlgorithmID algorithmID, byte[] byArray, ObjectID objectID) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Invalid object type: " + n2);
        }
        if (n2 == 2 && objectID == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo for otherObjectTypes. Missing otherObjectTypeID!");
        }
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing digestAlgorithm!");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing digest value!");
        }
        this.b = n2;
        this.d = algorithmID;
        this.c = byArray;
        if (n2 == 2) {
            this.a = objectID;
        }
    }

    ObjectDigestInfo() {
        this.b = -1;
    }
}

