/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.Holder;
import iaik.x509.attr.V1Form;
import iaik.x509.attr.V2Form;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;

public class AttributeCertificate
extends Certificate
implements X509Extension,
Serializable,
ASN1Type {
    private byte[] m;
    private boolean i;
    private byte[] n;
    private X509Extensions j;
    private BigInteger f;
    private Vector l = new Vector();
    private ChoiceOfTime e;
    private ChoiceOfTime d;
    private BigInteger c;
    private AlgorithmID b;
    private AttCertIssuer g;
    private Holder h;
    private int a = 2;
    private transient ASN1 k = new ASN1();

    public void writeTo(OutputStream outputStream) throws IOException {
        this.c();
        this.k.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.toByteArray());
    }

    public void verify(DSAPublicKey dSAPublicKey, DSAParameterSpec dSAParameterSpec) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.c();
        Signature signature = Signature.getInstance("DSA", "IAIK");
        try {
            byte[] byArray = this.k.getFirstObject();
            signature.setParameter("DSAParameterSpec", dSAParameterSpec);
            signature.initVerify(dSAPublicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.n)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey, String string) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.c();
        Signature signature = null;
        signature = string == null ? this.b.getSignatureInstance() : this.b.getSignatureInstance(string);
        try {
            byte[] byArray = this.k.getFirstObject();
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.n)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.verify(publicKey, (String)null);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        stringBuffer.append("Holder: {" + this.h + "}\n");
        stringBuffer.append("Issuer: {" + this.g + "}\n");
        stringBuffer.append("Signature algorithm: " + this.b + "\n");
        stringBuffer.append("Serial number: " + this.c + "\n");
        stringBuffer.append("Valid not before time: " + this.d + "\n");
        stringBuffer.append("Valid not after  time: " + this.e + "\n");
        stringBuffer.append("Attributes: ");
        if (bl) {
            Enumeration enumeration = this.l.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("\n" + enumeration.nextElement());
            }
        } else {
            stringBuffer.append(this.l.size());
        }
        stringBuffer.append("\n");
        if (this.f != null) {
            stringBuffer.append("Issuer Unique ID: " + this.f + "\n");
        }
        stringBuffer.append("\n");
        if (this.j != null) {
            if (bl) {
                stringBuffer.append(this.j);
            } else {
                stringBuffer.append("Extensions: " + this.j.countExtensions() + "\n");
            }
        }
        stringBuffer.append("Certificate Fingerprint (MD5)  : " + Util.toString(this.getFingerprint()) + "\n");
        stringBuffer.append("Certificate Fingerprint (SHA-1): " + Util.toString(this.getFingerprint()) + "\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] toByteArray() {
        this.c();
        return this.k.toByteArray();
    }

    public ASN1Object toASN1Object() {
        this.c();
        return this.k.toASN1Object();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException {
        if (algorithmID == null) {
            throw new CertificateException("Cannot sign certificate! No signature algorithm specified!");
        }
        this.b = algorithmID;
        Signature signature = this.b.getSignatureInstance(string);
        ASN1Object aSN1Object = this.a();
        signature.initSign(privateKey);
        try {
            signature.update(DerCoder.encode(aSN1Object));
            this.n = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.n);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.b.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.k = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (SignatureException signatureException) {
            throw new CertificateException(signatureException.toString());
        }
        this.d();
        this.e();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException {
        this.sign(algorithmID, privateKey, null);
    }

    private void e() {
        this.i = false;
    }

    public void setSignatureAlgorithm(AlgorithmID algorithmID) {
        this.b = algorithmID;
        this.d();
    }

    public void setSignature(byte[] byArray) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Cannot sign certificate! No signature value specified!");
        }
        this.n = byArray;
        ASN1Object aSN1Object = this.a();
        try {
            BIT_STRING bIT_STRING = new BIT_STRING(this.n);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.b.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.k = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        this.d();
        this.e();
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.c = bigInteger;
        this.d();
    }

    public void setNotBeforeTime(Date date) {
        this.d = new ChoiceOfTime(date);
        this.d.setEncodingType(ASN.GeneralizedTime);
        this.d();
    }

    public void setNotAfterTime(Date date) {
        this.e = new ChoiceOfTime(date);
        this.e.setEncodingType(ASN.GeneralizedTime);
        this.d();
    }

    private void d() {
        this.i = true;
        this.m = null;
    }

    public void setIssuerUniqueID(boolean[] blArray) {
        this.f = new BigInteger(Util.fromBooleanArray(blArray), 2);
        this.d();
    }

    public void setIssuer(AttCertIssuer attCertIssuer) {
        this.g = attCertIssuer;
        this.d();
    }

    public void setHolder(Holder holder) {
        this.h = holder;
        this.d();
    }

    public void setAttributes(Attribute[] attributeArray) {
        if (attributeArray != null) {
            this.l.removeAllElements();
            int n2 = 0;
            while (n2 < attributeArray.length) {
                this.l.addElement(attributeArray[n2]);
                ++n2;
            }
            this.d();
        }
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.j == null ? false : this.j.removeExtension(objectID);
        if (bl) {
            this.d();
        }
        return bl;
    }

    public Attribute removeAttribute(ObjectID objectID) {
        if (objectID != null) {
            int n2 = this.l.size();
            int n3 = 0;
            while (n3 < n2) {
                if (objectID.equals(((Attribute)this.l.elementAt(n3)).getType())) {
                    Attribute attribute = (Attribute)this.l.elementAt(n3);
                    this.l.removeElementAt(n3);
                    this.d();
                    return attribute;
                }
                ++n3;
            }
        }
        return null;
    }

    public void removeAllExtensions() {
        if (this.j != null) {
            this.j.removeAllExtensions();
            this.d();
        }
        this.j = null;
    }

    public void removeAllAttributes() {
        this.l.removeAllElements();
        this.d();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        try {
            this.k = new ASN1(objectInputStream);
            this.b();
            return;
        }
        catch (Exception exception) {
            throw new IOException("Unable to restore Certificate: " + exception.toString());
        }
    }

    public Enumeration listExtensions() {
        if (this.j == null) {
            return null;
        }
        return this.j.listExtensions();
    }

    private void b() throws X509ExtensionException, CertificateException {
        int n2 = 0;
        try {
            Object object;
            ASN1Object aSN1Object = this.k.getComponentAt(0);
            AlgorithmID algorithmID = new AlgorithmID(this.k.getComponentAt(1));
            ASN1Object aSN1Object2 = this.k.getComponentAt(2);
            this.n = (byte[])((BIT_STRING)aSN1Object2).getValue();
            ASN1Object aSN1Object3 = aSN1Object.getComponentAt(0);
            if (aSN1Object3.isA(ASN.INTEGER)) {
                object = (BigInteger)aSN1Object3.getValue();
                this.a = ((BigInteger)object).intValue() + 1;
                ++n2;
            } else {
                this.a = 1;
            }
            this.h = new Holder(aSN1Object.getComponentAt(n2));
            aSN1Object3 = aSN1Object.getComponentAt(1 + n2);
            if (aSN1Object3.isA(ASN.CON_SPEC)) {
                object = (CON_SPEC)aSN1Object3;
                ((CON_SPEC)object).forceImplicitlyTagged(ASN.SEQUENCE);
                this.g = new V2Form((ASN1Object)((CON_SPEC)object).getValue());
            } else {
                this.g = new V1Form(aSN1Object3);
            }
            this.b = new AlgorithmID(aSN1Object.getComponentAt(2 + n2));
            if (!algorithmID.equals(this.b)) {
                throw new CertificateException("Certificate signature algorithm mismatch");
            }
            this.c = (BigInteger)aSN1Object.getComponentAt(3 + n2).getValue();
            object = new ASN1(aSN1Object.getComponentAt(4 + n2));
            this.d = new ChoiceOfTime(((ASN1)object).getComponentAt(0));
            this.e = new ChoiceOfTime(((ASN1)object).getComponentAt(1));
            aSN1Object3 = aSN1Object.getComponentAt(5 + n2);
            int n3 = 0;
            while (n3 < aSN1Object3.countComponents()) {
                this.l.addElement(new Attribute(aSN1Object3.getComponentAt(n3)));
                ++n3;
            }
            int n4 = 6 + n2;
            while (n4 < aSN1Object.countComponents()) {
                if ((aSN1Object3 = aSN1Object.getComponentAt(n4++)).isA(ASN.BIT_STRING)) {
                    this.f = new BigInteger(1, (byte[])aSN1Object3.getValue());
                    continue;
                }
                this.j = new X509Extensions(aSN1Object3);
            }
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        this.k.clearASN1Object();
        this.e();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.j == null) {
            return false;
        }
        return this.j.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        if (this.j == null) {
            return false;
        }
        return this.j.hasExtensions();
    }

    public int getVersion() {
        return this.a;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.b;
    }

    public byte[] getSignature() {
        return this.n;
    }

    public byte[] getSigAlgParams() {
        if (this.b == null) {
            return null;
        }
        try {
            ASN1Object aSN1Object = this.b.getParameter();
            if (aSN1Object == null) {
                return null;
            }
            return new ASN1(aSN1Object).toByteArray();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public String getSigAlgOID() {
        if (this.b == null) {
            return null;
        }
        return this.b.getAlgorithm().getID();
    }

    public String getSigAlgName() {
        if (this.b == null) {
            return null;
        }
        return this.b.getName();
    }

    public BigInteger getSerialNumber() {
        return this.c;
    }

    public PublicKey getPublicKey() {
        return null;
    }

    public Date getNotBeforeTime() {
        if (this.d == null) {
            return null;
        }
        return this.d.getDate();
    }

    public Date getNotAfterTime() {
        if (this.e == null) {
            return null;
        }
        return this.e.getDate();
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.j == null) {
            return null;
        }
        return this.j.getNonCriticalExtensionOIDs();
    }

    public boolean[] getIssuerUniqueID() {
        if (this.f == null) {
            return null;
        }
        String string = this.f.toString(2);
        return Util.toBooleanArray(string);
    }

    public AttCertIssuer getIssuer() {
        return this.g;
    }

    public Holder getHolder() {
        return this.h;
    }

    public byte[] getFingerprintSHA() {
        if (this.m == null) {
            try {
                this.m = this.getFingerprint("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Algorithm SHA not available: " + noSuchAlgorithmException.toString());
            }
        }
        return this.m;
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        this.c();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(this.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprint() {
        this.c();
        return this.k.fingerprint();
    }

    public byte[] getExtensionValue(String string) {
        if (this.j == null) {
            return null;
        }
        return this.j.getExtensionValue(string);
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        if (this.j == null) {
            return null;
        }
        return this.j.getExtension(objectID);
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        this.c();
        return this.toByteArray();
    }

    public Set getCriticalExtensionOIDs() {
        if (this.j == null) {
            return null;
        }
        return this.j.getCriticalExtensionOIDs();
    }

    public Enumeration getAttributes() {
        return this.l.elements();
    }

    public Attribute getAttribute(ObjectID objectID) {
        if (this.l == null) {
            return null;
        }
        Enumeration enumeration = this.l.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.getType().equals(objectID)) continue;
            return attribute;
        }
        return null;
    }

    public byte[] getAcInfo() throws CertificateEncodingException {
        try {
            if (this.k != null && this.k.toByteArray() != null) {
                return this.k.getFirstObject();
            }
            return DerCoder.encode(this.a());
        }
        catch (CodingException codingException) {
            throw new CertificateEncodingException(codingException.toString());
        }
    }

    public void decode(InputStream inputStream) throws CertificateException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("Cannot parse certificate from a null input stream!");
        }
        try {
            this.k = new ASN1(inputStream);
            this.b();
            return;
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse certificate from a null object!");
        }
        this.k = new ASN1(aSN1Object);
        try {
            this.b();
            return;
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    private ASN1Object a() throws CertificateEncodingException {
        if (this.h == null) {
            throw new CertificateEncodingException("Holder not set!");
        }
        if (this.g == null) {
            throw new CertificateEncodingException("Issuer not set!");
        }
        if (this.b == null) {
            throw new CertificateEncodingException("Signature algorithm not set!");
        }
        if (this.c == null) {
            throw new CertificateEncodingException("Serial number not set!");
        }
        if (this.d == null) {
            throw new CertificateEncodingException("Valid not before time not set!");
        }
        if (this.e == null) {
            throw new CertificateEncodingException("Valid not after time not set!");
        }
        if (this.l.isEmpty()) {
            throw new CertificateEncodingException("No Attributes set!");
        }
        if (this.j != null && !this.j.hasExtensions()) {
            this.j = null;
        }
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (this.a > 1) {
                sEQUENCE.addComponent(new INTEGER(this.a - 1));
            }
            sEQUENCE.addComponent(this.h.toASN1Object());
            boolean bl = true;
            if (this.g.getVForm() == 1) {
                sEQUENCE.addComponent(this.g.toASN1Object());
            } else {
                sEQUENCE.addComponent(new CON_SPEC(0, this.g.toASN1Object(), bl));
            }
            sEQUENCE.addComponent(this.b.toASN1Object());
            sEQUENCE.addComponent(new INTEGER(this.c));
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.d.toASN1Object());
            sEQUENCE2.addComponent(this.e.toASN1Object());
            sEQUENCE.addComponent(sEQUENCE2);
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            Enumeration enumeration = this.l.elements();
            while (enumeration.hasMoreElements()) {
                sEQUENCE3.addComponent(((Attribute)enumeration.nextElement()).toASN1Object(true));
            }
            sEQUENCE.addComponent(sEQUENCE3);
            if (this.f != null) {
                BIT_STRING bIT_STRING = new BIT_STRING(this.f.toByteArray());
                sEQUENCE.addComponent(bIT_STRING);
            }
            if (this.j != null) {
                sEQUENCE.addComponent(this.j.toASN1Object());
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(exception.toString());
        }
    }

    public int countExtensions() {
        if (this.j == null) {
            return 0;
        }
        return this.j.countExtensions();
    }

    public void checkValidity(Date date) throws CertificateNotYetValidException, CertificateExpiredException {
        if (this.d == null) {
            throw new CertificateNotYetValidException("ValidNotBefore date not set!");
        }
        if (date.before(this.d.getDate())) {
            throw new CertificateNotYetValidException();
        }
        if (this.e == null) {
            throw new CertificateExpiredException("ValidNotAfter date not set!");
        }
        if (date.after(this.e.getDate())) {
            throw new CertificateExpiredException();
        }
    }

    public void checkValidity() throws CertificateNotYetValidException, CertificateExpiredException {
        this.checkValidity(new Date());
    }

    private void c() {
        if (this.i) {
            throw new RuntimeException("Cannot perform operation, certificate has to be signed first");
        }
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.j == null) {
            this.j = new X509Extensions();
        }
        this.j.addExtension(v3Extension);
        this.d();
    }

    public void addAttribute(Attribute attribute) {
        if (attribute != null) {
            this.d();
            int n2 = this.l.size();
            int n3 = 0;
            while (n3 < n2) {
                if (attribute.getType().equals(((Attribute)this.l.elementAt(n3)).getType())) {
                    this.l.setElementAt(attribute, n3);
                    return;
                }
                ++n3;
            }
            this.l.addElement(attribute);
        }
    }

    public AttributeCertificate(byte[] byArray) throws CertificateException {
        this();
        if (byArray == null) {
            throw new NullPointerException("Cannot parse certificate from a null byte array!");
        }
        try {
            this.k = new ASN1(byArray);
            this.b();
            return;
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.getMessage());
        }
    }

    public AttributeCertificate(InputStream inputStream) throws CertificateException, IOException {
        this();
        if (inputStream == null) {
            throw new NullPointerException("Cannot parse certificate from a null input stream!");
        }
        this.decode(inputStream);
    }

    public AttributeCertificate() {
        super("X.509 AC");
        this.d();
    }

    static {
        Util.toString(null, -1, 1);
    }
}

