/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfoStream;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.DataStream;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.pkcs.pkcs7.a;
import iaik.pkcs.pkcs7.d;
import iaik.utils.CryptoUtils;
import iaik.utils.EOFListener;
import iaik.utils.NotifyEOFInputStream;
import iaik.utils.Util;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;

public class SignedDataStream
implements d,
EOFListener,
ContentStream {
    static /* synthetic */ Class b;
    static /* synthetic */ Class c;
    private boolean e = true;
    protected int block_size = 2048;
    protected int mode = 1;
    protected InputStream input_stream;
    protected DerInputStream this_object;
    protected Vector signer_infos;
    protected X509CRL[] crls;
    protected X509Certificate[] certificates;
    protected ContentInfoStream content_info;
    protected ObjectID content_type;
    a a = new a(this);
    protected int version = 1;
    public static final int EXPLICIT = 2;
    public static final int IMPLICIT = 1;
    private static final boolean d = false;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) throws IOException {
        try {
            DerCoder.encodeTo(this.toASN1Object(n2), outputStream);
            return;
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo(this.toASN1Object(), outputStream);
            return;
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public void verify(PublicKey publicKey, int n2) throws SignatureException {
        if (n2 < 0 || n2 >= this.signer_infos.size()) {
            throw new SignatureException("SignerInfo does not exist. Wrong index.");
        }
        ASN1Type[] aSN1TypeArray = ((SignerInfo)this.signer_infos.elementAt(n2)).getAuthenticatedAttributes();
        try {
            byte[] byArray;
            AlgorithmID algorithmID = ((SignerInfo)this.signer_infos.elementAt(n2)).getDigestAlgorithm();
            byte[] byArray2 = this.getMessageDigest(algorithmID);
            if (aSN1TypeArray != null) {
                byArray = this.getSignedDigest(n2);
                if (!CryptoUtils.equalsBlock(byArray2, byArray)) {
                    throw new SignatureException("Signature verification error: message hash!");
                }
                MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
                byArray2 = this.version == 2 ? messageDigest.digest(DerCoder.encode(ASN.createSequenceOf(aSN1TypeArray))) : messageDigest.digest(DerCoder.encode(ASN.createSetOf(aSN1TypeArray, this.e)));
            }
            if (!CryptoUtils.equalsBlock(byArray2, byArray = ((SignerInfo)this.signer_infos.elementAt(n2)).getDigest(publicKey))) {
                throw new SignatureException("Signature verification error: signature value!");
            }
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (Exception exception) {
            throw new SignatureException("Error verifying the signature: " + exception.getMessage());
        }
    }

    public SignerInfo verify(X509Certificate x509Certificate) throws SignatureException {
        int n2 = this.a(x509Certificate);
        if (n2 == -1) {
            throw new SignatureException("Cannot do verification. No signer for this certificate!");
        }
        this.verify(x509Certificate.getPublicKey(), n2);
        return (SignerInfo)this.signer_infos.elementAt(n2);
    }

    public X509Certificate verify(int n2) throws SignatureException {
        if (n2 < 0 || n2 >= this.signer_infos.size()) {
            throw new SignatureException("SignerInfo does not exist. Wrong index.");
        }
        try {
            X509Certificate x509Certificate = this.getCertificate(((SignerInfo)this.signer_infos.elementAt(n2)).getIssuerAndSerialNumber());
            if (x509Certificate == null) {
                throw new SignatureException("Certificate for verifying the signature not found!");
            }
            this.verify(x509Certificate.getPublicKey(), n2);
            return x509Certificate;
        }
        catch (Exception exception) {
            throw new SignatureException(exception.getMessage());
        }
    }

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        AlgorithmID[] algorithmIDArray = this.a.a();
        if (algorithmIDArray.length > 0) {
            stringBuffer.append("digestAlgorithms: ");
            n2 = 0;
            while (n2 < algorithmIDArray.length) {
                stringBuffer.append(String.valueOf(algorithmIDArray[n2].getName()) + ",");
                ++n2;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("ContentInfo: {\n" + this.content_info.toString(bl));
        stringBuffer.append("\n}\n");
        if (this.certificates != null) {
            stringBuffer.append("certificates: " + this.certificates.length + "\n");
        }
        if (this.crls != null) {
            stringBuffer.append("crls: " + this.crls.length + "\n");
        }
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signer_infos.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("signerInfo " + n2 + ": {\n");
                stringBuffer.append(String.valueOf(((SignerInfo)enumeration.nextElement()).toString(true)) + "}");
                ++n2;
            }
        } else {
            stringBuffer.append("signerInfos: " + this.signer_infos.size() + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        if (this.signer_infos == null) {
            throw new PKCSException("No SignerInfo specified!");
        }
        if (this.mode == 1) {
            try {
                this.input_stream = this.a.a(this.input_stream, true);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PKCSException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
            }
        }
        this.content_info = this.mode == 1 && this.input_stream != null ? new ContentInfoStream(new DataStream(this.input_stream, n2)) : new ContentInfoStream(ObjectID.pkcs7_data);
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        try {
            ASN1Object aSN1Object;
            sEQUENCE.addComponent(new INTEGER(this.version));
            sEQUENCE.addComponent(ASN.createSetOf(this.a.a()));
            sEQUENCE.addComponent(this.content_info.toASN1Object());
            if (this.certificates != null) {
                aSN1Object = ASN.createSetOf(this.certificates);
                sEQUENCE.addComponent(new CON_SPEC(0, aSN1Object, true));
            }
            if (this.crls != null) {
                aSN1Object = ASN.createSetOf(this.crls);
                sEQUENCE.addComponent(new CON_SPEC(1, aSN1Object, true));
            }
            sEQUENCE.addComponent(ASN.createSetOf(this.signer_infos));
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        return sEQUENCE;
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.toASN1Object(-1);
    }

    public void setSignerInfos(SignerInfo[] signerInfoArray) throws NoSuchAlgorithmException {
        int n2 = 0;
        while (n2 < signerInfoArray.length) {
            this.addSignerInfo(signerInfoArray[n2]);
            ++n2;
        }
    }

    public void setMessageDigest(AlgorithmID algorithmID, byte[] byArray) throws NoSuchAlgorithmException {
        this.a.b(algorithmID, byArray);
    }

    public void setInputStream(InputStream inputStream) {
        this.input_stream = inputStream;
    }

    public void setCertificates(X509Certificate[] x509CertificateArray) {
        this.certificates = x509CertificateArray;
    }

    public void setCRLs(X509CRL[] x509CRLArray) {
        this.crls = x509CRLArray;
    }

    public void setBlockSize(int n2) {
        this.block_size = n2;
    }

    public void notifyEOF() throws IOException {
        try {
            Object object;
            while (this.this_object.nextIsContextSpecific()) {
                int n2 = this.this_object.readContextSpecific(17);
                DerInputStream derInputStream = this.this_object.readSet();
                switch (n2) {
                    case 0: 
                    case 2: {
                        object = new Vector<X509Certificate>();
                        try {
                            while (derInputStream.nextTag() > -1) {
                                ((Vector)object).addElement(new X509Certificate(derInputStream));
                            }
                        }
                        catch (CertificateException certificateException) {
                            throw new IOException("Cannot parse certificate: " + certificateException.getMessage());
                        }
                        this.certificates = new X509Certificate[((Vector)object).size()];
                        ((Vector)object).copyInto(this.certificates);
                        break;
                    }
                    case 1: 
                    case 3: {
                        Vector<X509CRL> vector = new Vector<X509CRL>();
                        try {
                            while (derInputStream.nextTag() > -1) {
                                vector.addElement(new X509CRL(derInputStream));
                            }
                        }
                        catch (CRLException cRLException) {
                            throw new IOException("Cannot parse crl: " + cRLException.getMessage());
                        }
                        this.crls = new X509CRL[vector.size()];
                        vector.copyInto(this.crls);
                        break;
                    }
                }
            }
            this.signer_infos = Util.getVector(ASN.parseSequenceOf(DerCoder.decode(this.this_object), b != null ? b : (b = SignedDataStream.a("iaik.pkcs.pkcs7.SignerInfo"))));
            Object[] objectArray = Util.toArray(this.signer_infos);
            int n3 = 0;
            while (n3 < objectArray.length) {
                object = (SignerInfo)objectArray[n3];
                ((SignerInfo)object).f = this;
                ++n3;
            }
            this.this_object.readEOC();
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("Error parsing Object! " + codingException.getMessage());
        }
    }

    public int getVersion() {
        return this.version;
    }

    public SignerInfo[] getSignerInfos() {
        return (SignerInfo[])Util.toArray(this.signer_infos, b != null ? b : (b = SignedDataStream.a("iaik.pkcs.pkcs7.SignerInfo")));
    }

    private int a(X509Certificate x509Certificate) {
        Enumeration enumeration = this.signer_infos.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            SignerInfo signerInfo = (SignerInfo)enumeration.nextElement();
            IssuerAndSerialNumber issuerAndSerialNumber = signerInfo.getIssuerAndSerialNumber();
            if (issuerAndSerialNumber.isIssuerOf(x509Certificate)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public byte[] getSignedDigest(int n2) throws PKCSException {
        Attribute[] attributeArray = ((SignerInfo)this.signer_infos.elementAt(n2)).getAuthenticatedAttributes();
        if (attributeArray == null) {
            throw new PKCSException("No authenticated attributes included in SignerInfo!");
        }
        int n3 = 0;
        while (n3 < attributeArray.length) {
            if (attributeArray[n3].getType().equals(ObjectID.messageDigest)) {
                return (byte[])attributeArray[n3].getValue()[0].getValue();
            }
            ++n3;
        }
        throw new PKCSException("Message digest not included in authenticated attributes!");
    }

    public int getMode() {
        return this.mode;
    }

    public byte[] getMessageDigest(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        return this.a.c(algorithmID);
    }

    public InputStream getInputStream() {
        return this.input_stream;
    }

    public AlgorithmID[] getDigestAlgorithms() {
        return this.a.a();
    }

    public ObjectID getContentType() {
        return ObjectID.pkcs7_signedData;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public X509Certificate getCertificate(IssuerAndSerialNumber issuerAndSerialNumber) throws PKCSException {
        if (this.certificates == null) {
            throw new PKCSException("Certificate not found!");
        }
        int n2 = 0;
        while (n2 < this.certificates.length) {
            if (issuerAndSerialNumber.isIssuerOf(this.certificates[n2])) break;
            ++n2;
        }
        if (n2 == this.certificates.length) {
            throw new PKCSException("Certificate not found!");
        }
        return this.certificates[n2];
    }

    public X509CRL[] getCRLs() {
        return this.crls;
    }

    public int getBlockSize() {
        return this.block_size;
    }

    public void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        this.e = false;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        this.this_object = ((DerInputStream)inputStream).readSequence();
        this.version = this.this_object.readInteger().intValue();
        try {
            this.a.a((AlgorithmID[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), c != null ? c : (c = SignedDataStream.a("iaik.asn1.structures.AlgorithmID"))));
        }
        catch (CodingException codingException) {
            throw new IOException("Error parsing digest algorithms!");
        }
        this.content_info = new ContentInfoStream(this.this_object);
        this.content_type = this.content_info.getContentType();
        if (this.mode == 2 || !this.content_info.hasContent()) {
            if (this.content_info.hasContent()) {
                try {
                    DataStream dataStream = (DataStream)this.content_info.getContent();
                    InputStream inputStream2 = dataStream.getInputStream();
                    byte[] byArray = new byte[1024];
                    while (inputStream2.read(byArray) > -1) {
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mode = 2;
            this.notifyEOF();
            return;
        }
        if (!this.content_type.equals(ObjectID.pkcs7_data)) {
            throw new IOException("SignedData only for content type Data at this time!");
        }
        DataStream dataStream = (DataStream)this.content_info.getContent();
        this.input_stream = dataStream.getInputStream();
        try {
            this.input_stream = this.a.a(this.input_stream, true);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
        }
        this.input_stream = new NotifyEOFInputStream(this.input_stream);
        ((NotifyEOFInputStream)this.input_stream).addEOFListener(this);
    }

    public void addSignerInfo(SignerInfo signerInfo) throws NoSuchAlgorithmException {
        signerInfo.f = this;
        AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
        if (!this.a.b(algorithmID)) {
            this.a.a(algorithmID);
        }
        if (this.mode == 2) {
            this.input_stream = this.a.a(this.input_stream, false);
        }
        this.signer_infos.addElement(signerInfo);
    }

    public SignedDataStream(InputStream inputStream, AlgorithmID[] algorithmIDArray) throws IOException {
        this();
        this.input_stream = inputStream;
        this.mode = 2;
        this.a = new a(this, algorithmIDArray);
        try {
            this.input_stream = this.a.a(this.input_stream, true);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
        }
    }

    public SignedDataStream(InputStream inputStream, int n2) {
        this();
        this.content_type = ObjectID.pkcs7_data;
        this.input_stream = inputStream;
        this.mode = n2;
    }

    public SignedDataStream(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    public SignedDataStream(ObjectID objectID) {
        this();
        this.mode = 2;
        this.content_type = objectID;
    }

    protected SignedDataStream() {
        this.signer_infos = new Vector();
    }
}

