/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;

public class SignatureOutputStream
extends FilterOutputStream {
    protected boolean on_ = true;
    protected Signature signatureEngine_;
    protected boolean isClosed_;
    protected int bytesProcessed_;
    protected boolean passThroughClose_;

    public SignatureOutputStream(OutputStream outputStream, Signature signature, boolean bl) {
        super(outputStream);
        if (outputStream == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        this.setSignature(signature);
        this.passThroughClose_ = bl;
    }

    public int clearBytesProcessed() {
        int n2 = this.bytesProcessed_;
        this.bytesProcessed_ = 0;
        return n2;
    }

    public void close() throws IOException {
        if (this.passThroughClose_) {
            this.out.close();
        }
        this.isClosed_ = true;
    }

    public int getBytesProcessed() {
        return this.bytesProcessed_;
    }

    public Signature getSignature() {
        return this.signatureEngine_;
    }

    public boolean isOn() {
        return this.on_;
    }

    public boolean isStreamClosed() {
        return this.isClosed_;
    }

    public boolean setOn(boolean bl) {
        boolean bl2 = this.on_;
        this.on_ = bl;
        return bl2;
    }

    public void setSignature(Signature signature) {
        if (signature == null) {
            throw new NullPointerException("Argument \"signatureEngine\" must not be null.");
        }
        this.signatureEngine_ = signature;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this.out.toString());
        stringBuffer.append('|');
        stringBuffer.append(this.signatureEngine_.toString());
        return stringBuffer.toString();
    }

    public void write(int n2) throws IOException {
        this.out.write(n2);
        if (this.on_) {
            try {
                this.signatureEngine_.update((byte)n2);
                ++this.bytesProcessed_;
            }
            catch (SignatureException signatureException) {
                throw new IOException("Error updating signature engine: " + signatureException.toString());
            }
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
        if (this.on_) {
            try {
                this.signatureEngine_.update(byArray, n2, n3);
                this.bytesProcessed_ += n3;
            }
            catch (SignatureException signatureException) {
                throw new IOException("Error updating signature engine: " + signatureException.toString());
            }
        }
    }
}

