/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class PKCS11Signature
extends SignatureSpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    protected static final int SIGN = 1;
    protected static final int VERIFY = 2;
    protected Session session_;
    protected TokenManager tokenManager_;
    protected IAIKPKCS11PublicKey publicKey_;
    protected IAIKPKCS11PrivateKey privateKey_;
    protected int operationState_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected boolean currentKeyIsSoftwareKey_;
    protected Signature softwareDelegate_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;

    protected PKCS11Signature() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GetParameter(string);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getParameter(string);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof IAIKPKCS11Key) {
            this.pkcs11InitSign(privateKey);
            this.currentKeyIsSoftwareKey_ = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.initSign(privateKey);
            this.currentKeyIsSoftwareKey_ = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof IAIKPKCS11Key) {
            this.pkcs11InitVerify(publicKey);
            this.currentKeyIsSoftwareKey_ = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.initVerify(publicKey);
            this.currentKeyIsSoftwareKey_ = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        if (this.currentKeyIsSoftwareKey_) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.softwareDelegate_.setParameter(string, object);
            return;
        } else {
            this.pkcs11SetParameter(string, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (this.currentKeyIsSoftwareKey_) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.softwareDelegate_.setParameter(algorithmParameterSpec);
            return;
        } else {
            this.pkcs11SetParameter(algorithmParameterSpec);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineSign() throws SignatureException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11Sign();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.sign();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineUpdate(byte by) throws SignatureException {
        if (this.currentKeyIsSoftwareKey_) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.softwareDelegate_.update(by);
            return;
        } else {
            this.pkcs11Update(by);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.currentKeyIsSoftwareKey_) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.softwareDelegate_.update(byArray, n2, n3);
            return;
        } else {
            this.pkcs11Update(byArray, n2, n3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11Verify(byArray);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.verify(byArray);
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
            this.session_ = null;
        }
        super.finalize();
    }

    protected void finalizePkcs11Operation() {
        if (this.pkcs11OperationInitialized_) {
            this.pkcs11OperationInitialized_ = false;
            this.tokenManager_.closeSession(this.session_);
            this.session_ = null;
        } else {
            this.tokenManager_.disposeSession(this.session_);
            this.session_ = null;
        }
    }

    protected abstract String getAlgorithmName();

    protected abstract Mechanism getMechanism();

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setSign(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setVerify(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2}};
        }
        return this.usedMechanismInfos_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{this.getMechanism()};
        }
        return this.usedMechanisms_;
    }

    protected void initializePkcs11Operation() throws InvalidKeyException {
        this.initializeSession();
        try {
            if (this.operationState_ == 1) {
                this.session_.signInit(this.getMechanism(), this.privateKey_.getKeyObject());
            } else {
                this.session_.verifyInit(this.getMechanism(), this.publicKey_.getKeyObject());
            }
            this.pkcs11OperationInitialized_ = true;
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException(tokenException.toString());
        }
    }

    protected void initializeSession() {
        try {
            if (this.session_ == null) {
                this.session_ = this.tokenManager_.getSession(false);
            }
            this.tokenManager_.makeAuthorizedSession(this.session_, null);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getAlgorithmName();
        this.softwareDelegate_ = delegateProvider.getSignature(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate signature engine for " + string);
        }
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected Object pkcs11GetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("Method not supported!");
    }

    protected void pkcs11InitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof IAIKPKCS11PrivateKey)) {
            throw new InvalidKeyException("Private key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey!");
        }
        this.privateKey_ = (IAIKPKCS11PrivateKey)privateKey;
        this.tokenManager_ = this.privateKey_.getTokenManager();
        this.operationState_ = 1;
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    protected void pkcs11InitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof IAIKPKCS11PublicKey)) {
            throw new InvalidKeyException("Public key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey!");
        }
        this.publicKey_ = (IAIKPKCS11PublicKey)publicKey;
        this.tokenManager_ = this.publicKey_.getTokenManager();
        this.operationState_ = 2;
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    protected void pkcs11SetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("Method not supported!");
    }

    protected void pkcs11SetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException("This method not supported by this class!");
    }

    protected byte[] pkcs11Sign() throws SignatureException {
        if (this.operationState_ != 1) {
            throw new SignatureException("Signature object not in sign state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        byte[] byArray = null;
        try {
            try {
                byArray = this.session_.signFinal();
                this.pkcs11OperationInitialized_ = false;
            }
            catch (TokenException tokenException) {
                throw new SignatureException(tokenException.toString());
            }
            Object var3_4 = null;
            this.finalizePkcs11Operation();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.finalizePkcs11Operation();
            throw throwable;
        }
        return byArray;
    }

    protected void pkcs11Update(byte by) throws SignatureException {
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        byte[] byArray = new byte[]{by};
        this.pkcs11Update(byArray, 0, 1);
    }

    protected void pkcs11Update(byte[] byArray, int n2, int n3) throws SignatureException {
        block9: {
            if (!this.initialized_) {
                throw new SignatureException("Signature object not initialzed");
            }
            if (n2 + n3 > byArray.length) {
                throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
            }
            if (!this.pkcs11OperationInitialized_) {
                try {
                    this.initializePkcs11Operation();
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.finalizePkcs11Operation();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
                }
            }
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            try {
                if (this.operationState_ == 1) {
                    this.session_.signUpdate(byArray2);
                    break block9;
                }
                if (this.operationState_ == 2) {
                    this.session_.verifyUpdate(byArray2);
                    break block9;
                }
                throw new SignatureException("Signature object in undefined state");
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new SignatureException(tokenException.toString());
            }
        }
    }

    protected boolean pkcs11Verify(byte[] byArray) throws SignatureException {
        boolean bl;
        if (this.operationState_ != 2) {
            throw new SignatureException("Signature object not in verify state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        try {
            try {
                this.session_.verifyFinal(byArray);
                bl = true;
                this.pkcs11OperationInitialized_ = false;
            }
            catch (PKCS11Exception pKCS11Exception) {
                long l2 = pKCS11Exception.getErrorCode();
                if (l2 == 192L) {
                    bl = false;
                    this.pkcs11OperationInitialized_ = false;
                } else {
                    bl = false;
                }
            }
            catch (TokenException tokenException) {
                bl = false;
            }
            Object var4_7 = null;
            this.finalizePkcs11Operation();
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.finalizePkcs11Operation();
            throw throwable;
        }
        return bl;
    }
}

