/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.signatures.PKCS11Signature;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public abstract class PKCS11BufferingSignature
extends PKCS11Signature {
    private static final boolean DEBUG = false;
    protected ByteArrayOutputStream buffer_ = new ByteArrayOutputStream(64);

    protected PKCS11BufferingSignature() {
    }

    protected abstract Mechanism getMechanism();

    protected void pkcs11InitSign(PrivateKey privateKey) throws InvalidKeyException {
        super.pkcs11InitSign(privateKey);
        this.buffer_.reset();
    }

    protected void pkcs11InitVerify(PublicKey publicKey) throws InvalidKeyException {
        super.pkcs11InitVerify(publicKey);
        this.buffer_.reset();
    }

    protected byte[] pkcs11Sign() throws SignatureException {
        byte[] byArray;
        if (this.operationState_ != 1) {
            throw new SignatureException("Signature object not in sign state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        try {
            try {
                byArray = this.session_.sign(this.buffer_.toByteArray());
                this.pkcs11OperationInitialized_ = false;
            }
            catch (TokenException tokenException) {
                Object var1_3 = null;
                throw new SignatureException(tokenException.toString());
            }
            Object var3_5 = null;
            this.finalizePkcs11Operation();
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.finalizePkcs11Operation();
            throw throwable;
        }
        return byArray;
    }

    protected void pkcs11Update(byte[] byArray, int n2, int n3) throws SignatureException {
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        this.buffer_.write(byArray, n2, n3);
    }

    protected boolean pkcs11Verify(byte[] byArray) throws SignatureException {
        boolean bl;
        if (this.operationState_ != 2) {
            throw new SignatureException("Signature object not in verify state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        try {
            try {
                byte[] byArray2 = this.buffer_.toByteArray();
                this.session_.verify(byArray2, byArray);
                bl = true;
                this.pkcs11OperationInitialized_ = false;
            }
            catch (PKCS11Exception pKCS11Exception) {
                long l2 = pKCS11Exception.getErrorCode();
                if (l2 == 192L) {
                    bl = false;
                    this.pkcs11OperationInitialized_ = false;
                } else {
                    bl = false;
                }
            }
            catch (TokenException tokenException) {
                bl = false;
            }
            Object var4_8 = null;
            this.finalizePkcs11Operation();
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.finalizePkcs11Operation();
            throw throwable;
        }
        return bl;
    }
}

