/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.signatures.PKCS11Signature;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public abstract class ExternalHashSignature
extends PKCS11Signature {
    private static final boolean DEBUG = false;
    protected static String MESSAGE_DIGEST_ALGORITHM_NAME = "SHA";
    protected MessageDigest messageDigest_;

    protected ExternalHashSignature() throws IAIKPkcs11Exception {
    }

    protected abstract Mechanism getMechanism();

    protected MessageDigest getMessageDigest() throws IAIKPkcs11Exception {
        String string;
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        MessageDigest messageDigest = delegateProvider.getMessageDigest(string = this.getMessageDigestName());
        if (messageDigest == null) {
            throw new IAIKPkcs11Exception("Could not get delegate message digest engine for " + string);
        }
        return messageDigest;
    }

    protected abstract String getMessageDigestName();

    protected void pkcs11InitSign(PrivateKey privateKey) throws InvalidKeyException {
        super.pkcs11InitSign(privateKey);
        if (this.messageDigest_ == null) {
            this.messageDigest_ = this.getMessageDigest();
        } else {
            this.messageDigest_.reset();
        }
    }

    protected void pkcs11InitVerify(PublicKey publicKey) throws InvalidKeyException {
        super.pkcs11InitVerify(publicKey);
        if (this.messageDigest_ == null) {
            this.messageDigest_ = this.getMessageDigest();
        } else {
            this.messageDigest_.reset();
        }
    }

    protected byte[] pkcs11Sign() throws SignatureException {
        if (this.operationState_ != 1) {
            throw new SignatureException("Signature object not in sign state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        byte[] byArray = this.messageDigest_.digest();
        byte[] byArray2 = this.prepareHash(byArray);
        byte[] byArray3 = null;
        try {
            try {
                byArray3 = this.session_.sign(byArray2);
                this.pkcs11OperationInitialized_ = false;
            }
            catch (TokenException tokenException) {
                throw new SignatureException(tokenException.toString());
            }
            Object var5_6 = null;
            this.finalizePkcs11Operation();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.finalizePkcs11Operation();
            throw throwable;
        }
        return byArray3;
    }

    protected void pkcs11Update(byte by) throws SignatureException {
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        this.messageDigest_.update(by);
    }

    protected void pkcs11Update(byte[] byArray, int n2, int n3) throws SignatureException {
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        this.messageDigest_.update(byArray, n2, n3);
    }

    protected boolean pkcs11Verify(byte[] byArray) throws SignatureException {
        boolean bl;
        if (this.operationState_ != 2) {
            throw new SignatureException("Signature object not in verify state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        byte[] byArray2 = this.prepareHash(this.messageDigest_.digest());
        try {
            try {
                this.session_.verify(byArray2, byArray);
                bl = true;
                this.pkcs11OperationInitialized_ = false;
            }
            catch (PKCS11Exception pKCS11Exception) {
                long l2 = pKCS11Exception.getErrorCode();
                if (l2 == 192L) {
                    bl = false;
                    this.pkcs11OperationInitialized_ = false;
                } else {
                    bl = false;
                }
            }
            catch (TokenException tokenException) {
                bl = false;
            }
            Object var5_8 = null;
            this.finalizePkcs11Operation();
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.finalizePkcs11Operation();
            throw throwable;
        }
        return bl;
    }

    protected byte[] prepareHash(byte[] byArray) throws IAIKPkcs11Exception {
        return byArray;
    }
}

