/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.random;

import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.random.PKCS11RandomSpi;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.GeneralSecurityException;

public class PKCS11SeededRandomSpi
extends PKCS11RandomSpi {
    private static final boolean DEBUG = false;
    protected static final int INITIAL_SEED_BYTES = 128;
    protected boolean isSeeded_;

    public PKCS11SeededRandomSpi() throws IAIKPkcs11Exception {
    }

    public PKCS11SeededRandomSpi(TokenManager tokenManager) throws IAIKPkcs11Exception {
        super(tokenManager);
    }

    protected void engineNextBytes(byte[] byArray) throws IAIKPkcs11Exception {
        if (byArray == null) {
            throw new NullPointerException("Argument \"arrayToFill\" must not be null.");
        }
        if (!this.isSeeded_) {
            this.initializeSeed();
        }
        this.softwareDelegate_.nextBytes(byArray);
    }

    protected void engineSetSeed(byte[] byArray) throws IAIKPkcs11Exception {
        if (byArray == null) {
            throw new NullPointerException("Argument \"seedBytes\" must not be null.");
        }
        if (!this.isSeeded_) {
            this.initializeSeed();
        }
        this.softwareDelegate_.setSeed(byArray);
    }

    protected int getInitialSeedByteNumber() {
        return 128;
    }

    protected void initializeSeed() {
        byte[] byArray;
        int n2 = this.getInitialSeedByteNumber();
        if (this.softwareDelegate_ == null) {
            try {
                this.initializeSoftwareDelegate();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IAIKPkcs11Exception("Could not initialize software delegate secure random: " + generalSecurityException);
            }
        }
        if (this.useSoftwareDelegation_) {
            byArray = this.softwareDelegate_.generateSeed(n2);
        } else {
            if (!this.pkcs11OperationInitialized_) {
                this.initializePkcs11Operation();
            }
            try {
                try {
                    byArray = this.session_.generateRandom(n2);
                }
                catch (TokenException tokenException) {
                    if (tokenException instanceof PKCS11Exception) {
                        PKCS11Exception pKCS11Exception = (PKCS11Exception)tokenException;
                        if (pKCS11Exception.getErrorCode() == 257L) {
                            try {
                                this.tokenManager_.makeAuthorizedSession(this.session_, null);
                                byArray = this.session_.generateRandom(n2);
                            }
                            catch (TokenException tokenException2) {
                                throw new IAIKPkcs11Exception(tokenException.toString());
                            }
                        }
                        throw new IAIKPkcs11Exception(tokenException.toString());
                    }
                    throw new IAIKPkcs11Exception(tokenException.toString());
                }
                Object var4_7 = null;
                this.finalizePkcs11Operation();
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.finalizePkcs11Operation();
                throw throwable;
            }
        }
        this.softwareDelegate_.setSeed(byArray);
        this.isSeeded_ = true;
    }
}

