/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.macs;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.parameters.RC2Parameters;
import iaik.pkcs.pkcs11.provider.macs.PKCS11Mac;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class Rc2Mac
extends PKCS11Mac {
    private static final boolean DEBUG = false;
    protected static String MAC_ALGORITHM_NAME = "MacRC2";
    protected RC2ParameterSpec rc2ParameterSpec_;
    protected boolean rc2ParameterSpecChanged_;
    protected Mechanism mechanism_;

    protected String getAlgorithmName() {
        return MAC_ALGORITHM_NAME;
    }

    protected Mechanism getMechanism() {
        if (this.rc2ParameterSpecChanged_) {
            Mechanism mechanism = (Mechanism)Mechanism.RC2_MAC.clone();
            if (this.rc2ParameterSpec_ != null) {
                int n2 = this.rc2ParameterSpec_.getEffectiveKeyBits();
                RC2Parameters rC2Parameters = new RC2Parameters(n2);
                mechanism.setParameters(rC2Parameters);
                this.rc2ParameterSpecChanged_ = false;
            }
            this.mechanism_ = mechanism;
        }
        return this.mechanism_;
    }

    public Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.RC2_MAC};
        }
        return this.usedMechanisms_;
    }

    protected int pkcs11GetMacLength() {
        return 4;
    }

    protected void pkcs11Init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("key must be of type javax.crypto.spec.RC2ParameterSpec!");
        }
        this.rc2ParameterSpec_ = (RC2ParameterSpec)algorithmParameterSpec;
        this.rc2ParameterSpecChanged_ = true;
        super.pkcs11Init(key, algorithmParameterSpec);
    }
}

