/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.macs;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.MacSpi;

public abstract class PKCS11Mac
extends MacSpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    protected Session session_;
    protected TokenManager tokenManager_;
    protected IAIKPKCS11SecretKey key_;
    protected SecretKey keyObject_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected boolean updateUsed_;
    protected byte[] buffer_;
    protected boolean currentKeyIsSoftwareKey_;
    protected Mac softwareDelegate_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;

    protected PKCS11Mac() {
    }

    protected void checkKeyObject(iaik.pkcs.pkcs11.objects.Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type SecretKey");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineDoFinal() throws IllegalStateException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11DoFinal();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.doFinal();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetMacLength() {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GetMacLength();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getMacLength();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(key, algorithmParameterSpec);
            this.currentKeyIsSoftwareKey_ = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init(key, algorithmParameterSpec);
            this.currentKeyIsSoftwareKey_ = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineReset() {
        if (this.currentKeyIsSoftwareKey_) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.softwareDelegate_.reset();
            return;
        } else {
            this.pkcs11Reset();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineUpdate(byte by) throws IllegalStateException {
        if (this.currentKeyIsSoftwareKey_) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.softwareDelegate_.update(by);
            return;
        } else {
            this.pkcs11Update(by);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws IllegalStateException {
        if (this.currentKeyIsSoftwareKey_) {
            if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
            this.softwareDelegate_.update(byArray, n2, n3);
            return;
        } else {
            this.pkcs11Update(byArray, n2, n3);
        }
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }

    protected void finalizePkcs11Operation() {
        if (this.pkcs11OperationInitialized_) {
            this.pkcs11OperationInitialized_ = false;
            this.tokenManager_.closeSession(this.session_);
            this.session_ = null;
        } else {
            this.pkcs11OperationInitialized_ = false;
            this.tokenManager_.disposeSession(this.session_);
            this.session_ = null;
        }
    }

    protected abstract String getAlgorithmName();

    protected abstract Mechanism getMechanism();

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setSign(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setVerify(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2}};
        }
        return this.usedMechanismInfos_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{this.getMechanism()};
        }
        return this.usedMechanisms_;
    }

    protected void initialize() throws InvalidAlgorithmParameterException, InvalidKeyException {
        try {
            this.initializePkcs11Operation();
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException(tokenException.toString());
        }
        this.initialized_ = true;
        this.updateUsed_ = false;
        this.buffer_ = null;
    }

    protected void initializePkcs11Operation() throws TokenException {
        this.initializeSession();
        this.session_.signInit(this.getMechanism(), this.key_.getKeyObject());
        this.pkcs11OperationInitialized_ = true;
        this.updateUsed_ = false;
        this.buffer_ = null;
    }

    protected void initializeSession() {
        this.tokenManager_ = this.key_.getTokenManager();
        try {
            if (this.session_ == null) {
                this.session_ = this.tokenManager_.getSession(false);
            }
            this.tokenManager_.makeAuthorizedSession(this.session_, null);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getAlgorithmName();
        this.softwareDelegate_ = delegateProvider.getMac(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate MAC engine for " + string);
        }
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected byte[] pkcs11DoFinal() throws IllegalStateException {
        if (!this.initialized_) {
            throw new IllegalStateException("MAC not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + tokenException.toString());
            }
        }
        byte[] byArray = null;
        try {
            try {
                if (!this.updateUsed_ && this.buffer_ != null) {
                    byArray = this.session_.sign(this.buffer_);
                } else {
                    byArray = this.session_.signFinal();
                    this.pkcs11OperationInitialized_ = false;
                }
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception(tokenException.toString());
            }
            Object var3_4 = null;
            this.finalizePkcs11Operation();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.finalizePkcs11Operation();
            throw throwable;
        }
        return byArray;
    }

    protected abstract int pkcs11GetMacLength();

    protected void pkcs11Init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        this.key_ = (IAIKPKCS11SecretKey)key;
        this.keyObject_ = (SecretKey)this.key_.getKeyObject();
        this.checkKeyObject(this.keyObject_);
        this.initialize();
    }

    protected void pkcs11Reset() {
        if (this.session_ != null) {
            this.finalizePkcs11Operation();
        }
        try {
            this.initializePkcs11Operation();
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception("Error initializing the PKCS#11 MAC: " + tokenException.toString());
        }
        this.initialized_ = true;
        this.updateUsed_ = false;
        this.buffer_ = null;
    }

    protected void pkcs11Update(byte by) throws IllegalStateException {
        if (!this.initialized_) {
            throw new IllegalStateException("MAC not initialized!");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + tokenException.toString());
            }
        }
        byte[] byArray = new byte[]{by};
        if (!this.updateUsed_ && this.buffer_ == null) {
            this.buffer_ = byArray;
        } else {
            try {
                if (this.buffer_ != null) {
                    this.session_.signUpdate(this.buffer_);
                    this.buffer_ = null;
                }
                this.session_.signUpdate(byArray);
                this.updateUsed_ = true;
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Error updating digest: " + tokenException);
            }
        }
    }

    protected void pkcs11Update(byte[] byArray, int n2, int n3) throws IllegalStateException {
        if (!this.initialized_) {
            throw new IllegalStateException("MAC not initialized!");
        }
        if (byArray == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + tokenException.toString());
            }
        }
        byte[] byArray2 = null;
        if (n2 == 0 && n3 == byArray.length) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        }
        if (!this.updateUsed_ && this.buffer_ == null) {
            this.buffer_ = byArray2;
        } else {
            try {
                if (this.buffer_ != null) {
                    this.session_.signUpdate(this.buffer_);
                    this.buffer_ = null;
                }
                this.session_.signUpdate(byArray2);
                this.updateUsed_ = true;
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Error updating MAC: " + tokenException);
            }
        }
    }
}

