/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keys;

import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.KeyFactoryAdapter;
import iaik.pkcs.pkcs11.provider.keyfactories.RsaKeyFactory;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;

public class IAIKPKCS11RsaPrivateKey
extends IAIKPKCS11PrivateKey
implements RSAPrivateCrtKey {
    private static final boolean DEBUG = false;

    public IAIKPKCS11RsaPrivateKey(TokenManager tokenManager, RSAPrivateKey rSAPrivateKey) {
        super(tokenManager, rSAPrivateKey);
    }

    public static IAIKPKCS11RsaPrivateKey create(TokenManager tokenManager, RSAPrivateKey rSAPrivateKey) {
        return new IAIKPKCS11RsaPrivateKey(tokenManager, rSAPrivateKey);
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public BigInteger getCrtCoefficient() {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getCoefficient();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("CRT Coefficient not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("CRT Coefficient value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }

    protected KeyFactory getKeyFactory() {
        return new KeyFactoryAdapter(new RsaKeyFactory(), this.tokenManager_.getProvider(), this.getAlgorithm());
    }

    public BigInteger getModulus() {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getModulus();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Modulus not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Modulus value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }

    public BigInteger getPrimeExponentP() {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getExponent1();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Prime Exponent P not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Prime Exponent P value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }

    public BigInteger getPrimeExponentQ() {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getExponent2();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Prime Exponent Q not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Prime Exponent Q value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }

    public BigInteger getPrimeP() {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getPrime1();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Prime P not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Prime P value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }

    public BigInteger getPrimeQ() {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getPrime2();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Prime Q not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Prime Q value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }

    public BigInteger getPrivateExponent() {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getPrivateExponent();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Private Exponent not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Private Exponent value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }

    public BigInteger getPublicExponent() {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getPublicExponent();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Public Exponent not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Public Exponent value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }
}

