/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keys;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.Constants;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.Key;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class IAIKPKCS11Key
implements Key {
    private static final boolean DEBUG = false;
    public static final String RSA = "RSA";
    public static final String DSA = "DSA";
    public static final String DH = "DH";
    public static final String ECDSA = "ECDSA";
    public static final String KEA = "KEA";
    public static final String GENERIC_SECRET = "GENERIC_SECRET";
    public static final String RC2 = "RC2";
    public static final String RC4 = "RC4";
    public static final String DES = "DES";
    public static final String DES2 = "DES2";
    public static final String DESede = "DESede";
    public static final String CAST = "CAST";
    public static final String CAST3 = "CAST3";
    public static final String CAST5 = "CAST5";
    public static final String CAST128 = "CAST128";
    public static final String RC5 = "RC5";
    public static final String IDEA = "IDEA";
    public static final String SKIPJACK = "SKIPJACK";
    public static final String BATON = "BATON";
    public static final String JUNIPER = "JUNIPER";
    public static final String CDMF = "CDMF";
    public static final String AES = "AES";
    public static final String VENDOR_DEFINED = "VENDOR_DEFINED";
    protected static final String KEY_TYPE_NAME_PROPERTIES = "iaik/pkcs/pkcs11/provider/keys/IAIKPKCS11Key.properties";
    protected static Map keyTypeNames_;
    protected static Map keyTypeCodes_;
    protected TokenManager tokenManager_;
    protected iaik.pkcs.pkcs11.objects.Key keyObject_;
    protected String alias_;
    protected Session session_;
    static /* synthetic */ Class class$iaik$pkcs$pkcs11$provider$keys$IAIKPKCS11Key;

    static {
        String string;
        Object object;
        Iterator iterator;
        keyTypeNames_ = new HashMap(32);
        keyTypeNames_.put(new Long(0L), RSA);
        keyTypeNames_.put(new Long(1L), DSA);
        keyTypeNames_.put(new Long(2L), DH);
        keyTypeNames_.put(new Long(3L), ECDSA);
        keyTypeNames_.put(new Long(5L), KEA);
        keyTypeNames_.put(new Long(16L), GENERIC_SECRET);
        keyTypeNames_.put(new Long(17L), RC2);
        keyTypeNames_.put(new Long(18L), RC4);
        keyTypeNames_.put(new Long(19L), DES);
        keyTypeNames_.put(new Long(20L), DES2);
        keyTypeNames_.put(new Long(21L), DESede);
        keyTypeNames_.put(new Long(22L), CAST);
        keyTypeNames_.put(new Long(23L), CAST3);
        keyTypeNames_.put(new Long(24L), CAST5);
        keyTypeNames_.put(new Long(24L), CAST128);
        keyTypeNames_.put(new Long(25L), RC5);
        keyTypeNames_.put(new Long(26L), IDEA);
        keyTypeNames_.put(new Long(27L), SKIPJACK);
        keyTypeNames_.put(new Long(28L), BATON);
        keyTypeNames_.put(new Long(29L), JUNIPER);
        keyTypeNames_.put(new Long(30L), CDMF);
        keyTypeNames_.put(new Long(0x80000000L), VENDOR_DEFINED);
        Properties properties = new Properties();
        try {
            properties.load((class$iaik$pkcs$pkcs11$provider$keys$IAIKPKCS11Key != null ? class$iaik$pkcs$pkcs11$provider$keys$IAIKPKCS11Key : (class$iaik$pkcs$pkcs11$provider$keys$IAIKPKCS11Key = IAIKPKCS11Key.class$("iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key"))).getClassLoader().getResourceAsStream(KEY_TYPE_NAME_PROPERTIES));
            iterator = ((Hashtable)properties).keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                string = properties.getProperty((String)object);
                try {
                    if (((String)object).startsWith("0x")) {
                        object = ((String)object).substring(2);
                    }
                    Long l2 = Long.valueOf((String)object, 16);
                    keyTypeNames_.put(l2, string);
                }
                catch (Exception exception) {
                    IAIKPkcs11.errorStream_.println("Error in properties file iaik/pkcs/pkcs11/provider/keys/IAIKPKCS11Key.properties in entry " + (String)object + ". Trying to continue.");
                }
            }
        }
        catch (Exception exception) {}
        keyTypeCodes_ = new HashMap(32);
        iterator = keyTypeNames_.keySet().iterator();
        while (iterator.hasNext()) {
            object = (Long)iterator.next();
            string = (String)keyTypeNames_.get(object);
            keyTypeCodes_.put(string, object);
        }
    }

    protected IAIKPKCS11Key(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.Key key) {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null");
        }
        this.tokenManager_ = tokenManager;
        this.keyObject_ = key;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static IAIKPKCS11Key create(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.Key key) {
        IAIKPKCS11Key iAIKPKCS11Key;
        if (key instanceof PrivateKey) {
            iAIKPKCS11Key = IAIKPKCS11PrivateKey.create(tokenManager, (PrivateKey)key);
        } else if (key instanceof PublicKey) {
            iAIKPKCS11Key = IAIKPKCS11PublicKey.create(tokenManager, (PublicKey)key);
        } else if (key instanceof SecretKey) {
            iAIKPKCS11Key = IAIKPKCS11SecretKey.create(tokenManager, (SecretKey)key);
        } else {
            throw new IAIKPkcs11Exception("Unrecognized PKCS#11 object type: " + key.getClass().getName());
        }
        return iAIKPKCS11Key;
    }

    public void finalize() throws Throwable {
        this.setSession(null);
        super.finalize();
    }

    public String getAlgorithm() {
        return IAIKPKCS11Key.getAlgorithmName(this.keyObject_.getKeyType().getLongValue().intValue());
    }

    public static Long getAlgorithmCode(String string) {
        return (Long)keyTypeCodes_.get(string);
    }

    public static String getAlgorithmName(int n2) {
        return (String)keyTypeNames_.get(new Long(n2));
    }

    public String getAlias() {
        if (this.alias_ == null) {
            char[] cArray = this.keyObject_.getLabel().getCharArrayValue();
            this.alias_ = cArray != null ? new String(cArray) : null;
        }
        return this.alias_;
    }

    public byte[] getEncoded() {
        return null;
    }

    public String getFormat() {
        return null;
    }

    public byte[] getKeyID() {
        return this.keyObject_.getId().getByteArrayValue();
    }

    public iaik.pkcs.pkcs11.objects.Key getKeyObject() {
        return this.keyObject_;
    }

    public Session getSession() {
        return this.session_;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager_;
    }

    public void setSession(Session session) {
        if (session != null) {
            this.session_ = session;
            this.tokenManager_.acquireSessionCloseLock(session);
        } else if (this.session_ != null) {
            this.tokenManager_.releaseSessionCloseLock(this.session_);
            this.session_ = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKCS#11 key object: ");
        stringBuffer.append(Constants.LINE_SEPARATOR);
        stringBuffer.append(this.keyObject_.toString());
        stringBuffer.append(Constants.LINE_SEPARATOR);
        stringBuffer.append("on token: ");
        stringBuffer.append(Constants.LINE_SEPARATOR);
        try {
            stringBuffer.append(this.tokenManager_.getToken().getTokenInfo().toString());
        }
        catch (TokenException tokenException) {
            stringBuffer.append("Error getting token info: " + tokenException.toString());
        }
        return stringBuffer.toString();
    }
}

