/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keys;

import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.DhKeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.KeyFactoryAdapter;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import java.math.BigInteger;
import java.security.KeyFactory;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

public class IAIKPKCS11DhPrivateKey
extends IAIKPKCS11PrivateKey
implements DHPrivateKey {
    private static final boolean DEBUG = false;

    public IAIKPKCS11DhPrivateKey(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.DHPrivateKey dHPrivateKey) {
        super(tokenManager, dHPrivateKey);
    }

    public static IAIKPKCS11DhPrivateKey create(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.DHPrivateKey dHPrivateKey) {
        return new IAIKPKCS11DhPrivateKey(tokenManager, dHPrivateKey);
    }

    public String getAlgorithm() {
        return "DH";
    }

    protected KeyFactory getKeyFactory() {
        return new KeyFactoryAdapter(new DhKeyFactory(), this.tokenManager_.getProvider(), this.getAlgorithm());
    }

    public DHParameterSpec getParams() {
        iaik.pkcs.pkcs11.objects.DHPrivateKey dHPrivateKey = (iaik.pkcs.pkcs11.objects.DHPrivateKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = dHPrivateKey.getPrime();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Prime P not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Prime P value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        byteArrayAttribute = dHPrivateKey.getBase();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Base G not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Base G value is sensitive.");
        }
        byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
        LongAttribute longAttribute = dHPrivateKey.getValueBits();
        long l2 = -1L;
        if (longAttribute.isPresent() && !longAttribute.isSensitive()) {
            l2 = longAttribute.getLongValue();
        }
        return l2 >= 0L ? new DHParameterSpec(new BigInteger(1, byArray), new BigInteger(1, byArray2), (int)l2) : new DHParameterSpec(new BigInteger(1, byArray), new BigInteger(1, byArray2));
    }

    public BigInteger getX() {
        iaik.pkcs.pkcs11.objects.DHPrivateKey dHPrivateKey = (iaik.pkcs.pkcs11.objects.DHPrivateKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = dHPrivateKey.getValue();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("X not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("X value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }
}

