/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keypairgenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerationSpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class PKCS11KeyPairGenerator
extends KeyPairGeneratorSpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    protected TokenManager tokenManager_;
    protected Session session_;
    protected PKCS11KeyPairGenerationSpec keyPairGenerationSpec_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;

    protected PKCS11KeyPairGenerator() {
    }

    protected IAIKPKCS11PrivateKey createPkcs11PrivateKey(TokenManager tokenManager, PrivateKey privateKey) {
        return IAIKPKCS11PrivateKey.create(tokenManager, privateKey);
    }

    protected IAIKPKCS11PublicKey createPkcs11PublicKey(TokenManager tokenManager, PublicKey publicKey) {
        return IAIKPKCS11PublicKey.create(tokenManager, publicKey);
    }

    protected iaik.pkcs.pkcs11.objects.Object createPrivateKeyCreationTemplate(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        return this.keyPairGenerationSpec_.getPrivateKeyTemplate();
    }

    protected iaik.pkcs.pkcs11.objects.Object createPublicKeyCreationTemplate(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        return this.keyPairGenerationSpec_.getPublicKeyTemplate();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    public KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        Mechanism mechanism = this.getMechanism();
        iaik.pkcs.pkcs11.objects.Object object = this.createPrivateKeyCreationTemplate(this.keyPairGenerationSpec_);
        iaik.pkcs.pkcs11.objects.Object object2 = this.createPublicKeyCreationTemplate(this.keyPairGenerationSpec_);
        iaik.pkcs.pkcs11.objects.KeyPair keyPair2 = null;
        if (!this.pkcs11OperationInitialized_) {
            this.initializePkcs11Operation();
        }
        try {
            keyPair2 = this.session_.generateKeyPair(mechanism, object2, object);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        PrivateKey privateKey = keyPair2.getPrivateKey();
        PublicKey publicKey = keyPair2.getPublicKey();
        Token token = this.session_.getToken();
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = this.createPkcs11PrivateKey(this.tokenManager_, privateKey);
        boolean bl = false;
        if (!privateKey.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11PrivateKey.setSession(this.session_);
            bl = true;
        }
        IAIKPKCS11PublicKey iAIKPKCS11PublicKey = this.createPkcs11PublicKey(this.tokenManager_, publicKey);
        if (!publicKey.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11PublicKey.setSession(this.session_);
            bl = true;
        }
        if (bl) {
            this.session_ = null;
            this.pkcs11OperationInitialized_ = false;
        } else {
            this.finalizePkcs11Operation();
        }
        keyPair = new KeyPair(iAIKPKCS11PublicKey, iAIKPKCS11PrivateKey);
        return keyPair;
    }

    protected abstract Mechanism getMechanism();

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setGenerateKeyPair(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.usedMechanismInfos_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{this.getMechanism()};
        }
        return this.usedMechanisms_;
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("This method is not supported. Use initialize(AlgorithmParameterSpec, SecureRandom) instead.");
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11KeyPairGenerationSpec)) {
            throw new InvalidAlgorithmParameterException("params must be an instance of PKCS11KeyPairGenerationSpec and must not be null");
        }
        this.keyPairGenerationSpec_ = (PKCS11KeyPairGenerationSpec)algorithmParameterSpec;
        this.validateAlgorithmParameterSpec(this.keyPairGenerationSpec_.getAlgorithmParameterSpec());
        this.tokenManager_ = this.keyPairGenerationSpec_.getTokenManager();
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    protected void initializePkcs11Operation() {
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    protected void initializeSession() {
        try {
            if (this.session_ == null) {
                Session session = this.session_ = this.keyPairGenerationSpec_.isUseROSession() ? this.tokenManager_.getSession(false) : this.tokenManager_.getSession(true);
            }
            if (this.keyPairGenerationSpec_.isUseUserSession()) {
                this.tokenManager_.makeAuthorizedSession(this.session_, null);
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected void validateAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("This key-pair generator does not accept parameters.");
        }
    }
}

