/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keygenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keygenerators.PKCS11KeyGenerationSpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;

public abstract class PKCS11KeyGenerator
extends KeyGeneratorSpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    protected TokenManager tokenManager_;
    protected Session session_;
    protected PKCS11KeyGenerationSpec keyGenerationSpec_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;

    protected javax.crypto.SecretKey engineGenerateKey() {
        if (!this.initialized_) {
            throw new IllegalStateException("Key generator not initialized!");
        }
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = null;
        Mechanism mechanism = this.getMechanism();
        SecretKey secretKey = this.keyGenerationSpec_.getKeyTemplate();
        SecretKey secretKey2 = null;
        if (!this.pkcs11OperationInitialized_) {
            this.initializePkcs11Operation();
        }
        try {
            secretKey2 = (SecretKey)this.session_.generateKey(mechanism, secretKey);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        iAIKPKCS11SecretKey = IAIKPKCS11SecretKey.create(this.tokenManager_, secretKey2);
        if (!secretKey2.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11SecretKey.setSession(this.session_);
            this.session_ = null;
            this.pkcs11OperationInitialized_ = false;
        } else {
            this.finalizePkcs11Operation();
        }
        return iAIKPKCS11SecretKey;
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("This method is not supported. Use engineInit(AlgorithmParameterSpec, SecureRandom) instead.");
    }

    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("This method is not supported. Use engineInit(AlgorithmParameterSpec, SecureRandom) instead.");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11KeyGenerationSpec)) {
            throw new InvalidAlgorithmParameterException("params must be null or instance of PKCS11KeyGenerationSpec");
        }
        this.keyGenerationSpec_ = (PKCS11KeyGenerationSpec)algorithmParameterSpec;
        this.tokenManager_ = this.keyGenerationSpec_.getTokenManager();
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected abstract Mechanism getMechanism();

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setGenerate(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.usedMechanismInfos_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{this.getMechanism()};
        }
        return this.usedMechanisms_;
    }

    protected void initializePkcs11Operation() {
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    protected void initializeSession() {
        try {
            if (this.session_ == null) {
                Session session = this.session_ = this.keyGenerationSpec_.isUseROSession() ? this.tokenManager_.getSession(false) : this.tokenManager_.getSession(true);
            }
            if (this.keyGenerationSpec_.isUseUserSession()) {
                this.tokenManager_.makeAuthorizedSession(this.session_, null);
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }
}

