/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keygenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.keygenerators.PKCS11KeyDerivationSpec;
import iaik.pkcs.pkcs11.provider.keygenerators.PKCS11KeyGenerator;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class PKCS11KeyDerivation
extends PKCS11KeyGenerator {
    private static final boolean DEBUG = false;

    protected javax.crypto.SecretKey engineGenerateKey() {
        if (!this.initialized_) {
            throw new IllegalStateException("Key generator (derivator) not initialized!");
        }
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = null;
        Mechanism mechanism = this.getMechanism();
        PKCS11KeyDerivationSpec pKCS11KeyDerivationSpec = (PKCS11KeyDerivationSpec)this.keyGenerationSpec_;
        SecretKey secretKey = pKCS11KeyDerivationSpec.getBaseKey();
        SecretKey secretKey2 = pKCS11KeyDerivationSpec.getKeyTemplate();
        SecretKey secretKey3 = null;
        if (!this.pkcs11OperationInitialized_) {
            this.initializePkcs11Operation();
        }
        try {
            secretKey3 = (SecretKey)this.session_.deriveKey(mechanism, secretKey, secretKey2);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        iAIKPKCS11SecretKey = IAIKPKCS11SecretKey.create(this.tokenManager_, secretKey3);
        if (!secretKey3.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11SecretKey.setSession(this.session_);
            this.session_ = null;
            this.pkcs11OperationInitialized_ = false;
        } else {
            this.finalizePkcs11Operation();
        }
        return iAIKPKCS11SecretKey;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11KeyDerivationSpec)) {
            throw new InvalidAlgorithmParameterException("params must be null or instance of PKCS11KeyDerivationSpec");
        }
        super.engineInit(algorithmParameterSpec, secureRandom);
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setDerive(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.usedMechanismInfos_;
    }
}

