/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11SecretKeyFactory;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Hashtable;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class SecretKeyFactory
extends PKCS11SecretKeyFactory {
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$javax$crypto$spec$SecretKeySpec;
    static /* synthetic */ Class class$iaik$pkcs$pkcs11$provider$keyfactories$PKCS11KeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected abstract iaik.pkcs.pkcs11.objects.Object createKeyCreationTemplate(KeySpec var1) throws InvalidKeySpecException;

    protected byte[] extractKeyMaterial(Key key) throws InvalidKeySpecException {
        byte[] byArray = null;
        Hashtable hashtable = key.getAttributeTable();
        ByteArrayAttribute byteArrayAttribute = (ByteArrayAttribute)hashtable.get(Attribute.VALUE);
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 key object does not possess a value attribute.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 key object's value attribute is sensitive.");
        }
        byArray = byteArrayAttribute.getByteArrayValue();
        return byArray;
    }

    protected abstract String getAlgorithmName();

    protected String getSoftwareDelegateAlgorithm() {
        return this.getAlgorithmName();
    }

    protected abstract boolean isAlgorithmAccepted(String var1);

    protected boolean isFormatAccepted(String string) {
        return true;
    }

    protected SecretKey pkcs11GenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.pkcs11KeySpec_.getKeySpec();
        iaik.pkcs.pkcs11.objects.Object object = this.createKeyCreationTemplate(keySpec2);
        GenericTemplate genericTemplate = new GenericTemplate();
        iaik.pkcs.pkcs11.objects.Object object2 = this.pkcs11KeySpec_.getKeyTemplate();
        if (object2 != null) {
            genericTemplate.addAllPresentAttributes(object2);
        }
        genericTemplate.addAllPresentAttributes(object);
        return (SecretKey)this.createKey(genericTemplate);
    }

    protected KeySpec pkcs11GetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        KeySpec keySpec;
        if (secretKey == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        if (!(secretKey instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11SecretKey.");
        }
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = (IAIKPKCS11SecretKey)secretKey;
        Key key = iAIKPKCS11SecretKey.getKeyObject();
        byte[] byArray = this.extractKeyMaterial(key);
        if (clazz.equals(class$javax$crypto$spec$SecretKeySpec != null ? class$javax$crypto$spec$SecretKeySpec : (class$javax$crypto$spec$SecretKeySpec = SecretKeyFactory.class$("javax.crypto.spec.SecretKeySpec")))) {
            keySpec = new SecretKeySpec(byArray, this.getAlgorithmName());
        } else if (clazz.equals(class$iaik$pkcs$pkcs11$provider$keyfactories$PKCS11KeySpec != null ? class$iaik$pkcs$pkcs11$provider$keyfactories$PKCS11KeySpec : (class$iaik$pkcs$pkcs11$provider$keyfactories$PKCS11KeySpec = SecretKeyFactory.class$("iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec")))) {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, this.getAlgorithmName());
            boolean bl = key.getPrivate().getBooleanValue();
            keySpec = new PKCS11KeySpec(secretKeySpec, iAIKPKCS11SecretKey.getTokenManager(), null, bl ^ true, bl);
        } else {
            throw new InvalidKeySpecException("The given key spec class is invalid. It must be of SecretKeySpec.");
        }
        return keySpec;
    }

    protected SecretKey pkcs11TranslateKey(SecretKey secretKey) throws InvalidKeyException {
        throw new UnsupportedOperationException("This method is unsupported by this factory.");
    }

    protected void validateKeySpec(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (keySpec instanceof SecretKeySpec) {
            SecretKeySpec secretKeySpec = (SecretKeySpec)keySpec;
            String string = secretKeySpec.getAlgorithm();
            if (!this.isAlgorithmAccepted(string)) {
                throw new InvalidKeySpecException("The algorithm of the given spec is unsupported: " + string);
            }
            String string2 = secretKeySpec.getAlgorithm();
            if (!this.isFormatAccepted(string2)) {
                throw new InvalidKeySpecException("The format of the key encoding of the given spec is unsupported: " + string2);
            }
        } else {
            throw new InvalidKeySpecException("The key spec must be of type javax.crypto.spec.SecretKeySpec.");
        }
    }
}

