/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.asn1.ASN1;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RsaKeyFactory
extends PKCS11KeyFactory {
    private static final boolean DEBUG = false;
    public static final int PKCS1_VERSION = 0;
    protected static String KEY_FACTORY_ALGORITHM_NAME = "RSA";
    static /* synthetic */ Class class$java$security$spec$RSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateCrtKeySpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected String getSoftwareDelegateAlgorithm() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected PrivateKey pkcs11GeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        byte[] byArray6;
        byte[] byArray7;
        byte[] byArray8;
        Object object3;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        Object var2_2 = null;
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.pkcs11KeySpec_.getKeySpec();
        if (keySpec2 instanceof RSAPrivateKeySpec) {
            if (keySpec2 instanceof RSAPrivateCrtKeySpec) {
                object3 = (RSAPrivateCrtKeySpec)keySpec2;
                byArray8 = Util.unsignedBigIntergerToByteArray(((RSAPrivateKeySpec)object3).getModulus());
                byArray7 = Util.unsignedBigIntergerToByteArray(((RSAPrivateKeySpec)object3).getPrivateExponent());
                byArray6 = Util.unsignedBigIntergerToByteArray(((RSAPrivateCrtKeySpec)object3).getPublicExponent());
                byArray5 = Util.unsignedBigIntergerToByteArray(((RSAPrivateCrtKeySpec)object3).getPrimeP());
                byArray4 = Util.unsignedBigIntergerToByteArray(((RSAPrivateCrtKeySpec)object3).getPrimeQ());
                byArray3 = Util.unsignedBigIntergerToByteArray(((RSAPrivateCrtKeySpec)object3).getPrimeExponentP());
                byArray2 = Util.unsignedBigIntergerToByteArray(((RSAPrivateCrtKeySpec)object3).getPrimeExponentQ());
                byArray = Util.unsignedBigIntergerToByteArray(((RSAPrivateCrtKeySpec)object3).getCrtCoefficient());
            } else {
                object3 = (RSAPrivateKeySpec)keySpec2;
                byArray8 = Util.unsignedBigIntergerToByteArray(((RSAPrivateKeySpec)object3).getModulus());
                byArray7 = Util.unsignedBigIntergerToByteArray(((RSAPrivateKeySpec)object3).getPrivateExponent());
                byArray6 = null;
                byArray5 = null;
                byArray4 = null;
                byArray3 = null;
                byArray2 = null;
                byArray = null;
            }
        } else if (keySpec2 instanceof PKCS8EncodedKeySpec) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            object3 = (PKCS8EncodedKeySpec)keySpec2;
            object2 = ((PKCS8EncodedKeySpec)object3).getEncoded();
            try {
                ASN1 aSN1 = new ASN1((byte[])object2);
                int n2 = ((BigInteger)aSN1.getComponentAt(0).getValue()).intValue();
                AlgorithmID algorithmID = new AlgorithmID(aSN1.getComponentAt(1));
                byte[] byArray9 = (byte[])aSN1.getComponentAt(2).getValue();
                ASN1 aSN12 = new ASN1(byArray9);
                int n3 = ((BigInteger)aSN12.getComponentAt(0).getValue()).intValue();
                object = (BigInteger)aSN12.getComponentAt(1).getValue();
                bigInteger7 = (BigInteger)aSN12.getComponentAt(2).getValue();
                bigInteger6 = (BigInteger)aSN12.getComponentAt(3).getValue();
                bigInteger5 = (BigInteger)aSN12.getComponentAt(4).getValue();
                bigInteger4 = (BigInteger)aSN12.getComponentAt(5).getValue();
                bigInteger3 = (BigInteger)aSN12.getComponentAt(6).getValue();
                bigInteger2 = (BigInteger)aSN12.getComponentAt(7).getValue();
                bigInteger = (BigInteger)aSN12.getComponentAt(8).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The private key spec could not be parsed: " + codingException.toString());
            }
            byArray8 = Util.unsignedBigIntergerToByteArray((BigInteger)object);
            byArray7 = Util.unsignedBigIntergerToByteArray(bigInteger6);
            byArray6 = Util.unsignedBigIntergerToByteArray(bigInteger7);
            byArray5 = Util.unsignedBigIntergerToByteArray(bigInteger5);
            byArray4 = Util.unsignedBigIntergerToByteArray(bigInteger4);
            byArray3 = Util.unsignedBigIntergerToByteArray(bigInteger3);
            byArray2 = Util.unsignedBigIntergerToByteArray(bigInteger2);
            byArray = Util.unsignedBigIntergerToByteArray(bigInteger);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.RSAPrivateKeySpec.");
        }
        object3 = new GenericTemplate();
        object2 = new RSAPrivateKey();
        ((RSAPrivateKey)object2).getModulus().setByteArrayValue(byArray8);
        ((RSAPrivateKey)object2).getPrivateExponent().setByteArrayValue(byArray7);
        if (byArray6 != null) {
            ((RSAPrivateKey)object2).getPublicExponent().setByteArrayValue(byArray6);
        }
        if (byArray5 != null && byArray4 != null && byArray3 != null && byArray2 != null && byArray != null) {
            ((RSAPrivateKey)object2).getPrime1().setByteArrayValue(byArray5);
            ((RSAPrivateKey)object2).getPrime2().setByteArrayValue(byArray4);
            ((RSAPrivateKey)object2).getExponent1().setByteArrayValue(byArray3);
            ((RSAPrivateKey)object2).getExponent2().setByteArrayValue(byArray2);
            ((RSAPrivateKey)object2).getCoefficient().setByteArrayValue(byArray);
        }
        ((GenericTemplate)object3).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object2);
        object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            ((GenericTemplate)object3).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        return (PrivateKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object3);
    }

    protected PublicKey pkcs11GeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        byte[] byArray;
        byte[] byArray2;
        Object object3;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.pkcs11KeySpec_.getKeySpec();
        Object var5_3 = null;
        if (keySpec2 instanceof RSAPublicKeySpec) {
            object3 = (RSAPublicKeySpec)keySpec2;
            byArray2 = Util.unsignedBigIntergerToByteArray(((RSAPublicKeySpec)object3).getModulus());
            byArray = Util.unsignedBigIntergerToByteArray(((RSAPublicKeySpec)object3).getPublicExponent());
        } else if (keySpec2 instanceof X509EncodedKeySpec) {
            BigInteger bigInteger;
            object3 = (X509EncodedKeySpec)keySpec2;
            object2 = ((X509EncodedKeySpec)object3).getEncoded();
            try {
                ASN1 aSN1 = new ASN1((byte[])object2);
                AlgorithmID algorithmID = new AlgorithmID(aSN1.getComponentAt(0));
                byte[] byArray3 = (byte[])aSN1.getComponentAt(1).getValue();
                ASN1 aSN12 = new ASN1(byArray3);
                object = (BigInteger)aSN12.getComponentAt(0).getValue();
                bigInteger = (BigInteger)aSN12.getComponentAt(1).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The public key spec could not be parsed: " + codingException.toString());
            }
            byArray2 = Util.unsignedBigIntergerToByteArray((BigInteger)object);
            byArray = Util.unsignedBigIntergerToByteArray(bigInteger);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.RSAPublicKeySpec.");
        }
        object3 = new RSAPublicKey();
        ((RSAPublicKey)object3).getModulus().setByteArrayValue(byArray2);
        ((RSAPublicKey)object3).getPublicExponent().setByteArrayValue(byArray);
        object2 = new GenericTemplate();
        ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object3);
        object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        return (PublicKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected KeySpec pkcs11GetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        byte[] byArray;
        void var3_9;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        Object var3_3 = null;
        if (clazz.equals(class$java$security$spec$RSAPublicKeySpec != null ? class$java$security$spec$RSAPublicKeySpec : (class$java$security$spec$RSAPublicKeySpec = RsaKeyFactory.class$("java.security.spec.RSAPublicKeySpec")))) {
            if (!(key instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get a RSAPublicKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)key;
            iaik.pkcs.pkcs11.objects.Key key2 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key2 instanceof RSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key2);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key2;
            this.verifyPublicKeyExtractable(rSAPublicKey);
            ByteArrayAttribute byteArrayAttribute = rSAPublicKey.getModulus();
            ByteArrayAttribute byteArrayAttribute2 = rSAPublicKey.getPublicExponent();
            byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray3 = byteArrayAttribute2.getByteArrayValue();
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
            return var3_9;
        }
        if (clazz.equals(class$java$security$spec$RSAPrivateKeySpec != null ? class$java$security$spec$RSAPrivateKeySpec : (class$java$security$spec$RSAPrivateKeySpec = RsaKeyFactory.class$("java.security.spec.RSAPrivateKeySpec")))) {
            if (!(key instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a RSAPrivateKeySpec.");
            IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)key;
            iaik.pkcs.pkcs11.objects.Key key3 = iAIKPKCS11PrivateKey.getKeyObject();
            if (!(key3 instanceof RSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key3);
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key3;
            this.verifyPrivateKeyExtractable(rSAPrivateKey);
            ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getModulus();
            ByteArrayAttribute byteArrayAttribute3 = rSAPrivateKey.getPrivateExponent();
            byte[] byArray4 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray5 = byteArrayAttribute3.getByteArrayValue();
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger(1, byArray4), new BigInteger(1, byArray5));
            return var3_9;
        }
        if (clazz.equals(class$java$security$spec$RSAPrivateCrtKeySpec != null ? class$java$security$spec$RSAPrivateCrtKeySpec : (class$java$security$spec$RSAPrivateCrtKeySpec = RsaKeyFactory.class$("java.security.spec.RSAPrivateCrtKeySpec")))) {
            if (!(key instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a RSAPrivateCrtKeySpec.");
            IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)key;
            iaik.pkcs.pkcs11.objects.Key key4 = iAIKPKCS11PrivateKey.getKeyObject();
            if (!(key4 instanceof RSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key4);
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key4;
            this.verifyPrivateCRTKeyExtractable(rSAPrivateKey);
            ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getModulus();
            ByteArrayAttribute byteArrayAttribute4 = rSAPrivateKey.getPrivateExponent();
            ByteArrayAttribute byteArrayAttribute5 = rSAPrivateKey.getPublicExponent();
            ByteArrayAttribute byteArrayAttribute6 = rSAPrivateKey.getPrime1();
            ByteArrayAttribute byteArrayAttribute7 = rSAPrivateKey.getPrime2();
            ByteArrayAttribute byteArrayAttribute8 = rSAPrivateKey.getExponent1();
            ByteArrayAttribute byteArrayAttribute9 = rSAPrivateKey.getExponent2();
            ByteArrayAttribute byteArrayAttribute10 = rSAPrivateKey.getCoefficient();
            byte[] byArray6 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray7 = byteArrayAttribute4.getByteArrayValue();
            byte[] byArray8 = byteArrayAttribute5.getByteArrayValue();
            byte[] byArray9 = byteArrayAttribute6.getByteArrayValue();
            byte[] byArray10 = byteArrayAttribute7.getByteArrayValue();
            byte[] byArray11 = byteArrayAttribute8.getByteArrayValue();
            byte[] byArray12 = byteArrayAttribute9.getByteArrayValue();
            byte[] byArray13 = byteArrayAttribute10.getByteArrayValue();
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(new BigInteger(1, byArray6), new BigInteger(1, byArray8), new BigInteger(1, byArray7), new BigInteger(1, byArray9), new BigInteger(1, byArray10), new BigInteger(1, byArray11), new BigInteger(1, byArray12), new BigInteger(1, byArray13));
            return var3_9;
        }
        if (clazz.equals(class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = RsaKeyFactory.class$("java.security.spec.X509EncodedKeySpec")))) {
            byte[] byArray14;
            if (!(key instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get a X509EncodedKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)key;
            iaik.pkcs.pkcs11.objects.Key key5 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key5 instanceof RSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key5);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key5;
            this.verifyPublicKeyExtractable(rSAPublicKey);
            ByteArrayAttribute byteArrayAttribute = rSAPublicKey.getModulus();
            ByteArrayAttribute byteArrayAttribute11 = rSAPublicKey.getPublicExponent();
            byte[] byArray15 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray16 = byteArrayAttribute11.getByteArrayValue();
            try {
                AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray15)));
                sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray16)));
                ASN1 aSN1 = new ASN1(sEQUENCE);
                byte[] byArray17 = aSN1.toByteArray();
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent(algorithmID.toASN1Object());
                sEQUENCE2.addComponent(new BIT_STRING(byArray17));
                byArray14 = DerCoder.encode(sEQUENCE2);
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("Error during encoding of RSA public key: " + codingException.toString());
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray14);
            return var3_9;
        }
        if (!clazz.equals(class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = RsaKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")))) throw new InvalidKeySpecException("The given key spec class is invalid. It must be of either RSAPublicKeySpec, X509EncodedKeySpec, RSAPrivateKeySpec, RSAPrivateCrtKeySpec or PKCS8EncodedKeySpec.");
        if (!(key instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a PKCS8EncodedKeySpec.");
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)key;
        iaik.pkcs.pkcs11.objects.Key key6 = iAIKPKCS11PrivateKey.getKeyObject();
        if (!(key6 instanceof RSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key6);
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key6;
        this.verifyPrivateCRTKeyExtractable(rSAPrivateKey);
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getModulus();
        ByteArrayAttribute byteArrayAttribute12 = rSAPrivateKey.getPrivateExponent();
        ByteArrayAttribute byteArrayAttribute13 = rSAPrivateKey.getPublicExponent();
        ByteArrayAttribute byteArrayAttribute14 = rSAPrivateKey.getPrime1();
        ByteArrayAttribute byteArrayAttribute15 = rSAPrivateKey.getPrime2();
        ByteArrayAttribute byteArrayAttribute16 = rSAPrivateKey.getExponent1();
        ByteArrayAttribute byteArrayAttribute17 = rSAPrivateKey.getExponent2();
        ByteArrayAttribute byteArrayAttribute18 = rSAPrivateKey.getCoefficient();
        byte[] byArray18 = byteArrayAttribute.getByteArrayValue();
        byte[] byArray19 = byteArrayAttribute12.getByteArrayValue();
        byte[] byArray20 = byteArrayAttribute13.getByteArrayValue();
        byte[] byArray21 = byteArrayAttribute14.getByteArrayValue();
        byte[] byArray22 = byteArrayAttribute15.getByteArrayValue();
        byte[] byArray23 = byteArrayAttribute16.getByteArrayValue();
        byte[] byArray24 = byteArrayAttribute17.getByteArrayValue();
        byte[] byArray25 = byteArrayAttribute18.getByteArrayValue();
        try {
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(0));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray18)));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray20)));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray19)));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray21)));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray22)));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray23)));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray24)));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray25)));
            ASN1 aSN1 = new ASN1(sEQUENCE);
            byte[] byArray26 = aSN1.toByteArray();
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            sEQUENCE3.addComponent(new INTEGER(0));
            sEQUENCE3.addComponent(algorithmID.toASN1Object());
            sEQUENCE3.addComponent(new OCTET_STRING(byArray26));
            byArray = DerCoder.encode(sEQUENCE3);
        }
        catch (CodingException codingException) {
            throw new InvalidKeySpecException("Error during encoding of RSA private key: " + codingException.toString());
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return var3_9;
    }

    protected Key pkcs11TranslateKey(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException("This method is unsupported by this factory.");
    }

    protected void verifyPrivateCRTKeyExtractable(RSAPrivateKey rSAPrivateKey) throws IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getModulus();
        ByteArrayAttribute byteArrayAttribute2 = rSAPrivateKey.getPrivateExponent();
        ByteArrayAttribute byteArrayAttribute3 = rSAPrivateKey.getPublicExponent();
        ByteArrayAttribute byteArrayAttribute4 = rSAPrivateKey.getPrime1();
        ByteArrayAttribute byteArrayAttribute5 = rSAPrivateKey.getPrime2();
        ByteArrayAttribute byteArrayAttribute6 = rSAPrivateKey.getExponent1();
        ByteArrayAttribute byteArrayAttribute7 = rSAPrivateKey.getExponent2();
        ByteArrayAttribute byteArrayAttribute8 = rSAPrivateKey.getCoefficient();
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a modulus attribute.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a private exponent attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a public exponent attribute.");
        }
        if (!byteArrayAttribute4.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a prime 1 attribute.");
        }
        if (!byteArrayAttribute5.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a prime 2 attribute.");
        }
        if (!byteArrayAttribute6.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a exponent 1 attribute.");
        }
        if (!byteArrayAttribute7.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a exponent 2 attribute.");
        }
        if (!byteArrayAttribute8.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a CRT coefficent attribute.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's modulus attribute is sensitive.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's private exponent attribute is sensitive.");
        }
        if (byteArrayAttribute3.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's public exponent attribute is sensitive.");
        }
        if (byteArrayAttribute4.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's prime 1 attribute is sensitive.");
        }
        if (byteArrayAttribute5.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's prime 2 attribute is sensitive.");
        }
        if (byteArrayAttribute6.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's exponent 1 attribute is sensitive.");
        }
        if (byteArrayAttribute6.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's exponent 2 attribute is sensitive.");
        }
        if (byteArrayAttribute8.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's CRT coefficent attribute is sensitive.");
        }
    }

    protected void verifyPrivateKeyExtractable(RSAPrivateKey rSAPrivateKey) throws IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getModulus();
        ByteArrayAttribute byteArrayAttribute2 = rSAPrivateKey.getPrivateExponent();
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a modulus attribute.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a private exponent attribute.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's modulus attribute is sensitive.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's private exponent attribute is sensitive.");
        }
    }

    protected void verifyPublicKeyExtractable(RSAPublicKey rSAPublicKey) throws IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute = rSAPublicKey.getModulus();
        ByteArrayAttribute byteArrayAttribute2 = rSAPublicKey.getPublicExponent();
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a modulus attribute.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a public exponent attribute.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's modulus attribute is sensitive.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object's public exponent attribute is sensitive.");
        }
    }
}

