/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DhKeyFactory
extends PKCS11KeyFactory {
    private static final boolean DEBUG = false;
    protected static String KEY_FACTORY_ALGORITHM_NAME = "DH";
    static /* synthetic */ Class class$javax$crypto$spec$DHPublicKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHPrivateKeySpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected String getSoftwareDelegateAlgorithm() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected PrivateKey pkcs11GeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        Object object3;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.pkcs11KeySpec_.getKeySpec();
        Object var6_3 = null;
        if (keySpec2 instanceof DHPrivateKeySpec) {
            object3 = (DHPrivateKeySpec)keySpec2;
            byArray3 = Util.unsignedBigIntergerToByteArray(((DHPrivateKeySpec)object3).getG());
            byArray2 = Util.unsignedBigIntergerToByteArray(((DHPrivateKeySpec)object3).getP());
            byArray = Util.unsignedBigIntergerToByteArray(((DHPrivateKeySpec)object3).getX());
        } else if (keySpec2 instanceof PKCS8EncodedKeySpec) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            object3 = (PKCS8EncodedKeySpec)keySpec2;
            object2 = ((PKCS8EncodedKeySpec)object3).getEncoded();
            try {
                ASN1 aSN1 = new ASN1((byte[])object2);
                int n2 = ((BigInteger)aSN1.getComponentAt(0).getValue()).intValue();
                AlgorithmID algorithmID = new AlgorithmID(aSN1.getComponentAt(1));
                byte[] byArray4 = (byte[])aSN1.getComponentAt(2).getValue();
                ASN1 aSN12 = new ASN1(byArray4);
                object = (BigInteger)aSN12.toASN1Object().getValue();
                ASN1Object aSN1Object = algorithmID.getParameter();
                if (aSN1Object != null && !aSN1Object.isA(ASN.NULL)) {
                    if (!aSN1Object.isA(ASN.SEQUENCE)) {
                        throw new InvalidKeySpecException("The private key spec could not be parsed. The key parameters are no ASN.1 SEQUENCE.");
                    }
                    if (aSN1Object.countComponents() < 2) {
                        throw new InvalidKeySpecException("The private key spec could not be parsed. The key parameters do not have 2 components.");
                    }
                } else {
                    throw new InvalidKeySpecException("The private key spec does not contain key parameters, which are required by this key factory.");
                }
                bigInteger2 = (BigInteger)aSN1Object.getComponentAt(0).getValue();
                bigInteger = (BigInteger)aSN1Object.getComponentAt(1).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The private key spec could not be parsed: " + codingException.toString());
            }
            byArray3 = Util.unsignedBigIntergerToByteArray(bigInteger);
            byArray2 = Util.unsignedBigIntergerToByteArray(bigInteger2);
            byArray = Util.unsignedBigIntergerToByteArray((BigInteger)object);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.DHPrivateKeySpec.");
        }
        object3 = new DHPrivateKey();
        ((DHPrivateKey)object3).getBase().setByteArrayValue(byArray3);
        ((DHPrivateKey)object3).getPrime().setByteArrayValue(byArray2);
        ((DHPrivateKey)object3).getValue().setByteArrayValue(byArray);
        object2 = new GenericTemplate();
        ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object3);
        object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        return (PrivateKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object2);
    }

    protected PublicKey pkcs11GeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        Object object3;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.pkcs11KeySpec_.getKeySpec();
        Object var6_3 = null;
        if (keySpec2 instanceof DHPublicKeySpec) {
            object3 = (DHPublicKeySpec)keySpec2;
            byArray3 = Util.unsignedBigIntergerToByteArray(((DHPublicKeySpec)object3).getG());
            byArray2 = Util.unsignedBigIntergerToByteArray(((DHPublicKeySpec)object3).getP());
            byArray = Util.unsignedBigIntergerToByteArray(((DHPublicKeySpec)object3).getY());
        } else if (keySpec2 instanceof X509EncodedKeySpec) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            object3 = (X509EncodedKeySpec)keySpec2;
            object2 = ((X509EncodedKeySpec)object3).getEncoded();
            try {
                ASN1 aSN1 = new ASN1((byte[])object2);
                AlgorithmID algorithmID = new AlgorithmID(aSN1.getComponentAt(0));
                byte[] byArray4 = (byte[])aSN1.getComponentAt(1).getValue();
                ASN1 aSN12 = new ASN1(byArray4);
                object = (BigInteger)aSN12.toASN1Object().getValue();
                ASN1Object aSN1Object = algorithmID.getParameter();
                if (aSN1Object != null && !aSN1Object.isA(ASN.NULL)) {
                    if (!aSN1Object.isA(ASN.SEQUENCE)) {
                        throw new InvalidKeySpecException("The public key spec could not be parsed. The key parameters are no ASN.1 SEQUENCE.");
                    }
                    if (aSN1Object.countComponents() < 2) {
                        throw new InvalidKeySpecException("The public key spec could not be parsed. The key parameters do not have 2 components.");
                    }
                } else {
                    throw new InvalidKeySpecException("The public key spec does not contain key parameters, which are required by this key factory.");
                }
                bigInteger2 = (BigInteger)aSN1Object.getComponentAt(0).getValue();
                bigInteger = (BigInteger)aSN1Object.getComponentAt(1).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The public key spec could not be parsed: " + codingException.toString());
            }
            byArray3 = Util.unsignedBigIntergerToByteArray(bigInteger);
            byArray2 = Util.unsignedBigIntergerToByteArray(bigInteger2);
            byArray = Util.unsignedBigIntergerToByteArray((BigInteger)object);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.DHPublicKeySpec.");
        }
        object3 = new DHPublicKey();
        ((DHPublicKey)object3).getBase().setByteArrayValue(byArray3);
        ((DHPublicKey)object3).getPrime().setByteArrayValue(byArray2);
        ((DHPublicKey)object3).getValue().setByteArrayValue(byArray);
        object2 = new GenericTemplate();
        object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object3);
        return (PublicKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected KeySpec pkcs11GetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        byte[] byArray;
        void var3_8;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        Object var3_3 = null;
        if (clazz.equals(class$javax$crypto$spec$DHPublicKeySpec != null ? class$javax$crypto$spec$DHPublicKeySpec : (class$javax$crypto$spec$DHPublicKeySpec = DhKeyFactory.class$("javax.crypto.spec.DHPublicKeySpec")))) {
            if (!(key instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get a DHPublicKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)key;
            iaik.pkcs.pkcs11.objects.Key key2 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key2 instanceof DHPublicKey)) throw new InvalidKeySpecException("This factory does only accept DH keys, but the PKCS#11 key object in the given key is: " + key2);
            DHPublicKey dHPublicKey = (DHPublicKey)key2;
            this.verifyPublicKeyExtractable(dHPublicKey);
            ByteArrayAttribute byteArrayAttribute = dHPublicKey.getBase();
            ByteArrayAttribute byteArrayAttribute2 = dHPublicKey.getPrime();
            ByteArrayAttribute byteArrayAttribute3 = dHPublicKey.getValue();
            byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray3 = byteArrayAttribute2.getByteArrayValue();
            byte[] byArray4 = byteArrayAttribute3.getByteArrayValue();
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(new BigInteger(1, byArray4), new BigInteger(1, byArray3), new BigInteger(1, byArray2));
            return var3_8;
        }
        if (clazz.equals(class$javax$crypto$spec$DHPrivateKeySpec != null ? class$javax$crypto$spec$DHPrivateKeySpec : (class$javax$crypto$spec$DHPrivateKeySpec = DhKeyFactory.class$("javax.crypto.spec.DHPrivateKeySpec")))) {
            if (!(key instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a DHPrivateKeySpec.");
            IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)key;
            iaik.pkcs.pkcs11.objects.Key key3 = iAIKPKCS11PrivateKey.getKeyObject();
            if (!(key3 instanceof DHPrivateKey)) throw new InvalidKeySpecException("This factory does only accept DH keys, but the PKCS#11 key object in the given key is: " + key3);
            DHPrivateKey dHPrivateKey = (DHPrivateKey)key3;
            this.verifyPrivateKeyExtractable(dHPrivateKey);
            ByteArrayAttribute byteArrayAttribute = dHPrivateKey.getBase();
            ByteArrayAttribute byteArrayAttribute4 = dHPrivateKey.getPrime();
            ByteArrayAttribute byteArrayAttribute5 = dHPrivateKey.getValue();
            byte[] byArray5 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray6 = byteArrayAttribute4.getByteArrayValue();
            byte[] byArray7 = byteArrayAttribute5.getByteArrayValue();
            DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(new BigInteger(1, byArray7), new BigInteger(1, byArray6), new BigInteger(1, byArray5));
            return var3_8;
        }
        if (clazz.equals(class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = DhKeyFactory.class$("java.security.spec.X509EncodedKeySpec")))) {
            byte[] byArray8;
            if (!(key instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get a X509EncodedKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)key;
            iaik.pkcs.pkcs11.objects.Key key4 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key4 instanceof DHPublicKey)) throw new InvalidKeySpecException("This factory does only accept DH keys, but the PKCS#11 key object in the given key is: " + key4);
            DHPublicKey dHPublicKey = (DHPublicKey)key4;
            this.verifyPublicKeyExtractable(dHPublicKey);
            ByteArrayAttribute byteArrayAttribute = dHPublicKey.getBase();
            ByteArrayAttribute byteArrayAttribute6 = dHPublicKey.getPrime();
            ByteArrayAttribute byteArrayAttribute7 = dHPublicKey.getValue();
            byte[] byArray9 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray10 = byteArrayAttribute6.getByteArrayValue();
            byte[] byArray11 = byteArrayAttribute7.getByteArrayValue();
            try {
                AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.dhKeyAgreement.clone();
                ASN1 aSN1 = new ASN1(new INTEGER(new BigInteger(1, byArray11)));
                byte[] byArray12 = aSN1.toByteArray();
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray10)));
                sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray9)));
                algorithmID.setParameter(sEQUENCE);
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent(algorithmID.toASN1Object());
                sEQUENCE2.addComponent(new BIT_STRING(byArray12));
                byArray8 = DerCoder.encode(sEQUENCE2);
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("Error during encoding of DH public key: " + codingException.toString());
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray8);
            return var3_8;
        }
        if (!clazz.equals(class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = DhKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")))) throw new InvalidKeySpecException("The given key spec class is invalid. It must be of either DHPublicKeySpec, DHPrivateKeySpec, X509EncodedKeySpec or PKCS8EncodedKeySpec.");
        if (!(key instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a PKCS8EncodedKeySpec.");
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)key;
        iaik.pkcs.pkcs11.objects.Key key5 = iAIKPKCS11PrivateKey.getKeyObject();
        if (!(key5 instanceof DHPrivateKey)) throw new InvalidKeySpecException("This factory does only accept DH keys, but the PKCS#11 key object in the given key is: " + key5);
        DHPrivateKey dHPrivateKey = (DHPrivateKey)key5;
        this.verifyPrivateKeyExtractable(dHPrivateKey);
        ByteArrayAttribute byteArrayAttribute = dHPrivateKey.getBase();
        ByteArrayAttribute byteArrayAttribute8 = dHPrivateKey.getPrime();
        ByteArrayAttribute byteArrayAttribute9 = dHPrivateKey.getValue();
        byte[] byArray13 = byteArrayAttribute.getByteArrayValue();
        byte[] byArray14 = byteArrayAttribute8.getByteArrayValue();
        byte[] byArray15 = byteArrayAttribute9.getByteArrayValue();
        try {
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            ASN1 aSN1 = new ASN1(new INTEGER(new BigInteger(1, byArray15)));
            byte[] byArray16 = aSN1.toByteArray();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray14)));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray13)));
            algorithmID.setParameter(sEQUENCE);
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            sEQUENCE3.addComponent(new INTEGER(0));
            sEQUENCE3.addComponent(algorithmID.toASN1Object());
            sEQUENCE3.addComponent(new OCTET_STRING(byArray16));
            byArray = DerCoder.encode(sEQUENCE3);
        }
        catch (CodingException codingException) {
            throw new InvalidKeySpecException("Error during encoding of DH private key: " + codingException.toString());
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return var3_8;
    }

    protected Key pkcs11TranslateKey(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException("This method is unsupported by this factory.");
    }

    protected void verifyPrivateKeyExtractable(DHPrivateKey dHPrivateKey) throws IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute = dHPrivateKey.getBase();
        ByteArrayAttribute byteArrayAttribute2 = dHPrivateKey.getPrime();
        ByteArrayAttribute byteArrayAttribute3 = dHPrivateKey.getValue();
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a base attribute.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a prime attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a value attribute.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object's base attribute is sensitive.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object's prime attribute is sensitive.");
        }
        if (byteArrayAttribute3.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object's value attribute is sensitive.");
        }
    }

    protected void verifyPublicKeyExtractable(DHPublicKey dHPublicKey) throws IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute = dHPublicKey.getBase();
        ByteArrayAttribute byteArrayAttribute2 = dHPublicKey.getPrime();
        ByteArrayAttribute byteArrayAttribute3 = dHPublicKey.getValue();
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a base attribute.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a prime attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a value attribute.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object's base attribute is sensitive.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object's prime attribute is sensitive.");
        }
        if (byteArrayAttribute3.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object's value attribute is sensitive.");
        }
    }
}

