/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyagreements;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyagreements.PKCS11KeyAgreementSpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.ShortBufferException;

public abstract class PKCS11KeyAgreement
extends KeyAgreementSpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    protected TokenManager tokenManager_;
    protected Session session_;
    protected PKCS11KeyAgreementSpec keyAgreementSpec_;
    protected boolean keyAgreementSpecChanged_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected IAIKPKCS11Key initKey_;
    protected iaik.pkcs.pkcs11.objects.Key initKeyObject_;
    protected IAIKPKCS11Key phaseKey_;
    protected iaik.pkcs.pkcs11.objects.Key phaseKeyObject_;
    protected IAIKPKCS11SecretKey agreedKey_;
    protected boolean currentKeyIsSoftwareKey_;
    protected KeyAgreement softwareDelegate_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;

    protected abstract void checkInitKeyObject(iaik.pkcs.pkcs11.objects.Key var1) throws InvalidKeyException;

    protected abstract void checkPhaseKeyObject(iaik.pkcs.pkcs11.objects.Key var1) throws InvalidKeyException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11DoPhase(key, bl);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.doPhase(key, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GenerateSecret();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.generateSecret();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected javax.crypto.SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GenerateSecret(string);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.generateSecret(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GenerateSecret(byArray, n2);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.generateSecret(byArray, n2);
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(key, secureRandom);
            this.currentKeyIsSoftwareKey_ = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init(key, secureRandom);
            this.currentKeyIsSoftwareKey_ = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(key, algorithmParameterSpec, secureRandom);
            this.currentKeyIsSoftwareKey_ = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init(key, algorithmParameterSpec, secureRandom);
            this.currentKeyIsSoftwareKey_ = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected byte[] extractValue(SecretKey secretKey) {
        if (secretKey == null) {
            throw new NullPointerException("Argument \"secretKeyObject\" must not be null.");
        }
        Hashtable hashtable = secretKey.getAttributeTable();
        ByteArrayAttribute byteArrayAttribute = (ByteArrayAttribute)hashtable.get(Attribute.VALUE);
        byte[] byArray = byteArrayAttribute != null && byteArrayAttribute.isPresent() && !byteArrayAttribute.isSensitive() ? byteArrayAttribute.getByteArrayValue() : null;
        return byArray;
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected abstract String getAlgorithmName();

    protected abstract Mechanism getMechanism();

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setDerive(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.usedMechanismInfos_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{this.getMechanism()};
        }
        return this.usedMechanisms_;
    }

    protected void initializePkcs11Operation() {
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    protected void initializeSession() {
        try {
            if (this.session_ == null) {
                Session session = this.session_ = this.keyAgreementSpec_.isUseROSession() ? this.tokenManager_.getSession(false) : this.tokenManager_.getSession(true);
            }
            if (this.keyAgreementSpec_.isUseUserSession()) {
                this.tokenManager_.makeAuthorizedSession(this.session_, null);
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getAlgorithmName();
        this.softwareDelegate_ = delegateProvider.getKeyAgreement(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate key agreement engine for " + string);
        }
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected Key pkcs11DoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!this.initialized_) {
            throw new IllegalStateException("Key agreement not initialized!");
        }
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (key instanceof IAIKPKCS11Key) {
            throw new NullPointerException("Argument \"key\" must not of type IAIKPKCS11Key.");
        }
        this.phaseKey_ = (IAIKPKCS11Key)key;
        this.phaseKeyObject_ = this.phaseKey_.getKeyObject();
        this.checkPhaseKeyObject(this.phaseKeyObject_);
        Mechanism mechanism = this.getMechanism();
        iaik.pkcs.pkcs11.objects.Key key2 = this.keyAgreementSpec_.getKeyTemplate();
        iaik.pkcs.pkcs11.objects.Key key3 = null;
        try {
            key3 = this.session_.deriveKey(mechanism, this.initKeyObject_, key2);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        if (key3 instanceof SecretKey) {
            this.agreedKey_ = IAIKPKCS11SecretKey.create(this.tokenManager_, (SecretKey)key3);
            if (!key3.getToken().getBooleanValue().booleanValue()) {
                this.agreedKey_.setSession(this.session_);
                this.session_ = null;
                this.pkcs11OperationInitialized_ = false;
            }
        } else {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception("Expected a secret key, key derivation returned key: " + key3);
        }
        return null;
    }

    protected byte[] pkcs11GenerateSecret() throws IllegalStateException {
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = null;
        try {
            iAIKPKCS11SecretKey = (IAIKPKCS11SecretKey)this.pkcs11GenerateSecret(null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IAIKPkcs11Exception(noSuchAlgorithmException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IAIKPkcs11Exception(invalidKeyException.toString());
        }
        SecretKey secretKey = (SecretKey)iAIKPKCS11SecretKey.getKeyObject();
        byte[] byArray = null;
        if (secretKey.getExtractable().getBooleanValue().booleanValue() && !secretKey.getSensitive().getBooleanValue().booleanValue()) {
            byArray = this.extractValue(secretKey);
        }
        return byArray;
    }

    protected javax.crypto.SecretKey pkcs11GenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.initialized_) {
            throw new IllegalStateException("Key agreement not initialized!");
        }
        if (this.agreedKey_ == null) {
            throw new IllegalStateException("Key agreement not finished yet. Call doPhase(Key, boolean) before.");
        }
        return this.agreedKey_;
    }

    protected int pkcs11GenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.engineGenerateSecret();
        int n3 = -1;
        if (byArray2 != null) {
            n3 = byArray2.length;
            if (byArray == null) {
                throw new NullPointerException("Argument \"sharedSecret\" must not be null.");
            }
            if (n3 > byArray.length - n2) {
                throw new ShortBufferException("Buffer too small. Bytes available: " + (byArray.length - n2) + ", bytes needed: " + n3);
            }
            System.arraycopy(byArray2, 0, byArray, n2, n3);
        }
        return n3;
    }

    protected void pkcs11Init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        throw new UnsupportedOperationException("This method is not supported. Use engineInit(Key, AlgorithmParameterSpec, SecureRandom) instead.");
    }

    protected void pkcs11Init(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (key instanceof IAIKPKCS11Key) {
            throw new NullPointerException("Argument \"key\" must not of type IAIKPKCS11Key.");
        }
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11KeyAgreementSpec)) {
            throw new InvalidAlgorithmParameterException("params must be null or instance of PKCS11KeyAgreementSpec");
        }
        this.initKey_ = (IAIKPKCS11Key)key;
        iaik.pkcs.pkcs11.objects.Key key2 = this.initKey_.getKeyObject();
        this.checkPhaseKeyObject(key2);
        this.initKeyObject_ = key2;
        this.keyAgreementSpec_ = (PKCS11KeyAgreementSpec)algorithmParameterSpec;
        this.tokenManager_ = this.keyAgreementSpec_.getTokenManager();
        this.keyAgreementSpecChanged_ = true;
        this.initializePkcs11Operation();
        this.initialized_ = true;
        this.agreedKey_ = null;
    }
}

