/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public abstract class DHKeyDerivationParameters
implements Parameters {
    protected long keyDerivationFunction_;
    protected byte[] publicData_;

    protected DHKeyDerivationParameters(long l2, byte[] byArray) {
        if (l2 != 1L && l2 != 2L && l2 != 3L && l2 != 4L) {
            throw new IllegalArgumentException("Illegal value for argument\"keyDerivationFunction\": " + Functions.toHexString(l2));
        }
        if (byArray == null) {
            throw new NullPointerException("Argument \"publicData\" must not be null.");
        }
        this.keyDerivationFunction_ = l2;
        this.publicData_ = byArray;
    }

    public Object clone() {
        DHKeyDerivationParameters dHKeyDerivationParameters;
        try {
            dHKeyDerivationParameters = (DHKeyDerivationParameters)super.clone();
            dHKeyDerivationParameters.publicData_ = (byte[])this.publicData_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return dHKeyDerivationParameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DHKeyDerivationParameters) {
            DHKeyDerivationParameters dHKeyDerivationParameters = (DHKeyDerivationParameters)object;
            bl = this == dHKeyDerivationParameters || this.keyDerivationFunction_ == dHKeyDerivationParameters.keyDerivationFunction_ && Functions.equals(this.publicData_, dHKeyDerivationParameters.publicData_);
        }
        return bl;
    }

    public long getKeyDerivationFunction() {
        return this.keyDerivationFunction_;
    }

    public abstract Object getPKCS11ParamsObject();

    public byte[] getPublicData() {
        return this.publicData_;
    }

    public int hashCode() {
        return (int)this.keyDerivationFunction_ ^ Functions.hashCode(this.publicData_);
    }

    public void setKeyDerivationFunction(long l2) {
        if (l2 != 1L && l2 != 2L && l2 != 3L && l2 != 4L) {
            throw new IllegalArgumentException("Illegal value for argument\"keyDerivationFunction\": " + Functions.toHexString(l2));
        }
        this.keyDerivationFunction_ = l2;
    }

    public void setPublicData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"publicData\" must not be null.");
        }
        this.publicData_ = byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Key Derivation Function: ");
        if (this.keyDerivationFunction_ == 1L) {
            stringBuffer.append("NULL");
        } else if (this.keyDerivationFunction_ == 2L) {
            stringBuffer.append("SHA1_KDF");
        } else if (this.keyDerivationFunction_ == 3L) {
            stringBuffer.append("SHA1_KDF_ASN1");
        } else if (this.keyDerivationFunction_ == 4L) {
            stringBuffer.append("SHA1_KDF_CONCATENATE");
        } else {
            stringBuffer.append("<unknown>");
        }
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Public Data: ");
        stringBuffer.append(Functions.toHexString(this.publicData_));
        return stringBuffer.toString();
    }

    public static interface KeyDerivationFunctionType {
        public static final long NULL = 1L;
        public static final long SHA1_KDF = 2L;
        public static final long SHA1_KDF_ASN1 = 3L;
        public static final long SHA1_KDF_CONCATENATE = 4L;
    }
}

