/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DomainParameters;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class X942DHParams
extends DomainParameters {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute base_;
    protected ByteArrayAttribute subprime_;
    protected LongAttribute primeBits_;
    protected LongAttribute subprimeBits_;

    public X942DHParams() {
        this.keyType_.setLongValue(Key.KeyType.DH);
    }

    protected X942DHParams(Session session, long l2) throws TokenException {
        super(session, l2);
        this.keyType_.setLongValue(Key.KeyType.DH);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.subprime_ = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.primeBits_ = new LongAttribute(Attribute.PRIME_BITS);
        this.subprimeBits_ = new LongAttribute(Attribute.SUB_PRIME_BITS);
        X942DHParams.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        X942DHParams x942DHParams = (X942DHParams)super.clone();
        x942DHParams.prime_ = (ByteArrayAttribute)this.prime_.clone();
        x942DHParams.base_ = (ByteArrayAttribute)this.base_.clone();
        x942DHParams.subprime_ = (ByteArrayAttribute)this.subprime_.clone();
        x942DHParams.primeBits_ = (LongAttribute)this.primeBits_.clone();
        x942DHParams.subprimeBits_ = (LongAttribute)this.subprimeBits_.clone();
        X942DHParams.putAttributesInTable(x942DHParams);
        return x942DHParams;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof X942DHParams) {
            X942DHParams x942DHParams = (X942DHParams)object;
            bl = this == x942DHParams || super.equals(x942DHParams) && this.prime_.equals(x942DHParams.prime_) && this.base_.equals(x942DHParams.base_) && this.subprime_.equals(x942DHParams.subprime_) && this.primeBits_.equals(x942DHParams.primeBits_) && this.subprimeBits_.equals(x942DHParams.subprimeBits_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        return new X942DHParams(session, l2);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public LongAttribute getPrimeBits() {
        return this.primeBits_;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime_;
    }

    public LongAttribute getSubprimeBits() {
        return this.subprimeBits_;
    }

    protected static void putAttributesInTable(X942DHParams x942DHParams) {
        if (x942DHParams == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        x942DHParams.attributeTable_.put(Attribute.PRIME, x942DHParams.prime_);
        x942DHParams.attributeTable_.put(Attribute.BASE, x942DHParams.base_);
        x942DHParams.attributeTable_.put(Attribute.SUBPRIME, x942DHParams.subprime_);
        x942DHParams.attributeTable_.put(Attribute.PRIME_BITS, x942DHParams.primeBits_);
        x942DHParams.attributeTable_.put(Attribute.SUB_PRIME_BITS, x942DHParams.subprimeBits_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.prime_);
        Object.getAttributeValue(session, this.objectHandle_, this.base_);
        Object.getAttributeValue(session, this.objectHandle_, this.subprime_);
        Object.getAttributeValue(session, this.objectHandle_, this.primeBits_);
        Object.getAttributeValue(session, this.objectHandle_, this.subprimeBits_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subprime (hex): ");
        stringBuffer.append(this.subprime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime Bits (dec): ");
        stringBuffer.append(this.primeBits_.toString(10));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subprime Bits (dec): ");
        stringBuffer.append(this.subprimeBits_.toString(10));
        return stringBuffer.toString();
    }
}

