/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class X509PublicKeyCertificate
extends Certificate {
    protected ByteArrayAttribute subject_;
    protected ByteArrayAttribute id_;
    protected ByteArrayAttribute issuer_;
    protected ByteArrayAttribute serialNumber_;
    protected ByteArrayAttribute value_;

    public X509PublicKeyCertificate() {
        this.certificateType_.setLongValue(Certificate.CertificateType.X_509_PUBLIC_KEY);
    }

    protected X509PublicKeyCertificate(Session session, long l2) throws TokenException {
        super(session, l2);
        this.certificateType_.setLongValue(Certificate.CertificateType.X_509_PUBLIC_KEY);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject_ = new ByteArrayAttribute(Attribute.SUBJECT);
        this.id_ = new ByteArrayAttribute(Attribute.ID);
        this.issuer_ = new ByteArrayAttribute(Attribute.ISSUER);
        this.serialNumber_ = new ByteArrayAttribute(Attribute.SERIAL_NUMBER);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        X509PublicKeyCertificate.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        X509PublicKeyCertificate x509PublicKeyCertificate = (X509PublicKeyCertificate)super.clone();
        x509PublicKeyCertificate.subject_ = (ByteArrayAttribute)this.subject_.clone();
        x509PublicKeyCertificate.id_ = (ByteArrayAttribute)this.id_.clone();
        x509PublicKeyCertificate.issuer_ = (ByteArrayAttribute)this.issuer_.clone();
        x509PublicKeyCertificate.serialNumber_ = (ByteArrayAttribute)this.serialNumber_.clone();
        x509PublicKeyCertificate.value_ = (ByteArrayAttribute)this.value_.clone();
        X509PublicKeyCertificate.putAttributesInTable(x509PublicKeyCertificate);
        return x509PublicKeyCertificate;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof X509PublicKeyCertificate) {
            X509PublicKeyCertificate x509PublicKeyCertificate = (X509PublicKeyCertificate)object;
            bl = this == x509PublicKeyCertificate || super.equals(x509PublicKeyCertificate) && this.subject_.equals(x509PublicKeyCertificate.subject_) && this.id_.equals(x509PublicKeyCertificate.id_) && this.issuer_.equals(x509PublicKeyCertificate.issuer_) && this.serialNumber_.equals(x509PublicKeyCertificate.serialNumber_) && this.value_.equals(x509PublicKeyCertificate.value_);
        }
        return bl;
    }

    public ByteArrayAttribute getId() {
        return this.id_;
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        return new X509PublicKeyCertificate(session, l2);
    }

    public ByteArrayAttribute getIssuer() {
        return this.issuer_;
    }

    public ByteArrayAttribute getSerialNumber() {
        return this.serialNumber_;
    }

    public ByteArrayAttribute getSubject() {
        return this.subject_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public int hashCode() {
        return this.issuer_.hashCode() ^ this.serialNumber_.hashCode();
    }

    protected static void putAttributesInTable(X509PublicKeyCertificate x509PublicKeyCertificate) {
        if (x509PublicKeyCertificate == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        x509PublicKeyCertificate.attributeTable_.put(Attribute.SUBJECT, x509PublicKeyCertificate.subject_);
        x509PublicKeyCertificate.attributeTable_.put(Attribute.ID, x509PublicKeyCertificate.id_);
        x509PublicKeyCertificate.attributeTable_.put(Attribute.ISSUER, x509PublicKeyCertificate.issuer_);
        x509PublicKeyCertificate.attributeTable_.put(Attribute.SERIAL_NUMBER, x509PublicKeyCertificate.serialNumber_);
        x509PublicKeyCertificate.attributeTable_.put(Attribute.VALUE, x509PublicKeyCertificate.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.subject_);
        Object.getAttributeValue(session, this.objectHandle_, this.id_);
        Object.getAttributeValue(session, this.objectHandle_, this.issuer_);
        Object.getAttributeValue(session, this.objectHandle_, this.serialNumber_);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subject (DER, hex): ");
        stringBuffer.append(this.subject_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("ID (hex): ");
        stringBuffer.append(this.id_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Issuer (DER, hex): ");
        stringBuffer.append(this.issuer_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Serial Number (DER, hex): ");
        stringBuffer.append(this.serialNumber_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (BER, hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

