/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.KEAPublicKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class PublicKey
extends Key {
    protected ByteArrayAttribute subject_;
    protected BooleanAttribute encrypt_;
    protected BooleanAttribute verify_;
    protected BooleanAttribute verifyRecover_;
    protected BooleanAttribute wrap_;

    public PublicKey() {
        this.objectClass_.setLongValue(Object.ObjectClass.PUBLIC_KEY);
    }

    protected PublicKey(Session session, long l2) throws TokenException {
        super(session, l2);
        this.objectClass_.setLongValue(Object.ObjectClass.PUBLIC_KEY);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject_ = new ByteArrayAttribute(Attribute.SUBJECT);
        this.encrypt_ = new BooleanAttribute(Attribute.ENCRYPT);
        this.verify_ = new BooleanAttribute(Attribute.VERIFY);
        this.verifyRecover_ = new BooleanAttribute(Attribute.VERIFY_RECOVER);
        this.wrap_ = new BooleanAttribute(Attribute.WRAP);
        PublicKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        PublicKey publicKey = (PublicKey)super.clone();
        publicKey.subject_ = (ByteArrayAttribute)this.subject_.clone();
        publicKey.encrypt_ = (BooleanAttribute)this.encrypt_.clone();
        publicKey.verify_ = (BooleanAttribute)this.verify_.clone();
        publicKey.verifyRecover_ = (BooleanAttribute)this.verifyRecover_.clone();
        publicKey.wrap_ = (BooleanAttribute)this.wrap_.clone();
        PublicKey.putAttributesInTable(publicKey);
        return publicKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof PublicKey) {
            PublicKey publicKey = (PublicKey)object;
            bl = this == publicKey || super.equals(publicKey) && this.subject_.equals(publicKey.subject_) && this.encrypt_.equals(publicKey.encrypt_) && this.verify_.equals(publicKey.verify_) && this.verifyRecover_.equals(publicKey.verifyRecover_) && this.wrap_.equals(publicKey.wrap_);
        }
        return bl;
    }

    public BooleanAttribute getEncrypt() {
        return this.encrypt_;
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        PKCS11 pKCS11 = session.getModule().getPKCS11Module();
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        Object.getAttributeValue(session, l2, keyTypeAttribute);
        Long l3 = keyTypeAttribute.getLongValue();
        Object object = keyTypeAttribute.isPresent() && l3 != null ? (l3.equals(Key.KeyType.RSA) ? RSAPublicKey.getInstance(session, l2) : (l3.equals(Key.KeyType.DSA) ? DSAPublicKey.getInstance(session, l2) : (l3.equals(Key.KeyType.ECDSA) ? ECDSAPublicKey.getInstance(session, l2) : (l3.equals(Key.KeyType.DH) ? DHPublicKey.getInstance(session, l2) : (l3.equals(Key.KeyType.KEA) ? KEAPublicKey.getInstance(session, l2) : ((l3 & Key.KeyType.VENDOR_DEFINED) != 0L ? PublicKey.getUnknownPublicKey(session, l2) : PublicKey.getUnknownPublicKey(session, l2))))))) : PublicKey.getUnknownPublicKey(session, l2);
        return object;
    }

    public ByteArrayAttribute getSubject() {
        return this.subject_;
    }

    protected static Object getUnknownPublicKey(Session session, long l2) throws TokenException {
        Object object;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (Key.vendorKeyBuilder_ != null) {
            try {
                object = Key.vendorKeyBuilder_.build(session, l2);
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = new PublicKey(session, l2);
            }
        } else {
            object = new PublicKey(session, l2);
        }
        return object;
    }

    public BooleanAttribute getVerify() {
        return this.verify_;
    }

    public BooleanAttribute getVerifyRecover() {
        return this.verifyRecover_;
    }

    public BooleanAttribute getWrap() {
        return this.wrap_;
    }

    protected static void putAttributesInTable(PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        publicKey.attributeTable_.put(Attribute.SUBJECT, publicKey.subject_);
        publicKey.attributeTable_.put(Attribute.ENCRYPT, publicKey.encrypt_);
        publicKey.attributeTable_.put(Attribute.VERIFY, publicKey.verify_);
        publicKey.attributeTable_.put(Attribute.VERIFY_RECOVER, publicKey.verifyRecover_);
        publicKey.attributeTable_.put(Attribute.WRAP, publicKey.wrap_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.subject_);
        Object.getAttributeValue(session, this.objectHandle_, this.encrypt_);
        Object.getAttributeValue(session, this.objectHandle_, this.verify_);
        Object.getAttributeValue(session, this.objectHandle_, this.verifyRecover_);
        Object.getAttributeValue(session, this.objectHandle_, this.wrap_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subject (DER, hex): ");
        stringBuffer.append(this.subject_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Encrypt: ");
        stringBuffer.append(this.encrypt_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Verify: ");
        stringBuffer.append(this.verify_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Verify Recover: ");
        stringBuffer.append(this.verifyRecover_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Wrap: ");
        stringBuffer.append(this.wrap_.toString());
        return stringBuffer.toString();
    }
}

