/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class GenericSecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;
    protected LongAttribute valueLen_;

    public GenericSecretKey() {
        this.keyType_.setLongValue(Key.KeyType.GENERIC_SECRET);
    }

    protected GenericSecretKey(Session session, long l2) throws TokenException {
        super(session, l2);
        this.keyType_.setLongValue(Key.KeyType.GENERIC_SECRET);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        this.valueLen_ = new LongAttribute(Attribute.VALUE_LEN);
        GenericSecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        GenericSecretKey genericSecretKey = (GenericSecretKey)super.clone();
        genericSecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        genericSecretKey.valueLen_ = (LongAttribute)this.valueLen_.clone();
        GenericSecretKey.putAttributesInTable(genericSecretKey);
        return genericSecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof GenericSecretKey) {
            GenericSecretKey genericSecretKey = (GenericSecretKey)object;
            bl = this == genericSecretKey || super.equals(genericSecretKey) && this.value_.equals(genericSecretKey.value_) && this.valueLen_.equals(genericSecretKey.valueLen_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        return new GenericSecretKey(session, l2);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public LongAttribute getValueLen() {
        return this.valueLen_;
    }

    protected static void putAttributesInTable(GenericSecretKey genericSecretKey) {
        if (genericSecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        genericSecretKey.attributeTable_.put(Attribute.VALUE, genericSecretKey.value_);
        genericSecretKey.attributeTable_.put(Attribute.VALUE_LEN, genericSecretKey.valueLen_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
        Object.getAttributeValue(session, this.objectHandle_, this.valueLen_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value Length (dec): ");
        stringBuffer.append(this.valueLen_.toString(10));
        return stringBuffer.toString();
    }
}

