/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.DHParams;
import iaik.pkcs.pkcs11.objects.DSAParams;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.X942DHParams;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class DomainParameters
extends Storage {
    protected static VendorDefinedDomainParametersBuilder vendorDomainParametersBuilder_;
    protected KeyTypeAttribute keyType_;
    protected BooleanAttribute local_;

    public DomainParameters() {
    }

    protected DomainParameters(Session session, long l2) throws TokenException {
        super(session, l2);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.keyType_ = new KeyTypeAttribute();
        this.local_ = new BooleanAttribute(Attribute.LOCAL);
        DomainParameters.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        DomainParameters domainParameters = (DomainParameters)super.clone();
        domainParameters.keyType_ = (KeyTypeAttribute)this.keyType_.clone();
        domainParameters.local_ = (BooleanAttribute)this.local_.clone();
        DomainParameters.putAttributesInTable(domainParameters);
        return domainParameters;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof DomainParameters) {
            DomainParameters domainParameters = (DomainParameters)object;
            bl = this == domainParameters || super.equals(domainParameters) && this.keyType_.equals(domainParameters.keyType_) && this.local_.equals(domainParameters.local_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        PKCS11 pKCS11 = session.getModule().getPKCS11Module();
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        Object.getAttributeValue(session, l2, keyTypeAttribute);
        Long l3 = keyTypeAttribute.getLongValue();
        Object object = keyTypeAttribute.isPresent() && l3 != null ? (l3.equals(Key.KeyType.DSA) ? DSAParams.getInstance(session, l2) : (l3.equals(Key.KeyType.DH) ? DHParams.getInstance(session, l2) : (l3.equals(Key.KeyType.X9_42_DH) ? X942DHParams.getInstance(session, l2) : ((l3 & Key.KeyType.VENDOR_DEFINED) != 0L ? DomainParameters.getUnknownDomainParameters(session, l2) : DomainParameters.getUnknownDomainParameters(session, l2))))) : DomainParameters.getUnknownDomainParameters(session, l2);
        return object;
    }

    public LongAttribute getKeyType() {
        return this.keyType_;
    }

    protected static Object getUnknownDomainParameters(Session session, long l2) throws TokenException {
        Object object;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (vendorDomainParametersBuilder_ != null) {
            try {
                object = vendorDomainParametersBuilder_.build(session, l2);
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = new DomainParameters(session, l2);
            }
        } else {
            object = new DomainParameters(session, l2);
        }
        return object;
    }

    public static VendorDefinedDomainParametersBuilder getVendorDefinedDomainParametersBuilder() {
        return vendorDomainParametersBuilder_;
    }

    public int hashCode() {
        return this.keyType_.hashCode() ^ this.local_.hashCode();
    }

    public BooleanAttribute isLocal() {
        return this.local_;
    }

    protected static void putAttributesInTable(DomainParameters domainParameters) {
        if (domainParameters == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        domainParameters.attributeTable_.put(Attribute.KEY_TYPE, domainParameters.keyType_);
        domainParameters.attributeTable_.put(Attribute.LOCAL, domainParameters.local_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.local_);
    }

    public static void setVendorDefinedDomainParametersBuilder(VendorDefinedDomainParametersBuilder vendorDefinedDomainParametersBuilder) {
        vendorDomainParametersBuilder_ = vendorDefinedDomainParametersBuilder;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Key Type: ");
        if (this.keyType_ != null) {
            stringBuffer.append(this.keyType_.toString());
        } else {
            stringBuffer.append("<unavailable>");
        }
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Local: ");
        stringBuffer.append(this.local_.toString());
        return stringBuffer.toString();
    }

    public static interface VendorDefinedDomainParametersBuilder {
        public Object build(Session var1, long var2) throws PKCS11Exception;
    }
}

